/*
 * Decompiled with CFR 0.152.
 */
package com.example.coppergolemshulker.mixin;

import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import net.minecraft.class_11573;
import net.minecraft.class_1297;
import net.minecraft.class_1308;
import net.minecraft.class_1799;
import net.minecraft.class_1937;
import net.minecraft.class_2281;
import net.minecraft.class_2338;
import net.minecraft.class_2480;
import net.minecraft.class_2586;
import net.minecraft.class_2621;
import net.minecraft.class_2680;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_3708;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.spongepowered.asm.mixin.Mixin;

@Mixin(value={class_11573.class})
public class CopperGolemChestSearchMixin {
    private static final Logger LOGGER = LoggerFactory.getLogger((String)"CopperGolemMixin");
    private static final Map<UUID, String> playerPreferences = new HashMap<UUID, String>();

    public static void setPlayerPreference(UUID playerId, String preference) {
        playerPreferences.put(playerId, preference);
        LOGGER.info("Set preference for player {}: {}", (Object)playerId, (Object)preference);
    }

    public static String getPlayerPreference(UUID playerId) {
        return playerPreferences.getOrDefault(playerId, "any");
    }

    public static Map<UUID, String> getAllPreferences() {
        return new HashMap<UUID, String>(playerPreferences);
    }

    public static void removePlayerPreference(UUID playerId) {
        String oldPref = playerPreferences.remove(playerId);
        LOGGER.info("Removed preference for player {} (was: {})", (Object)playerId, (Object)oldPref);
    }

    public static boolean hasPlayerPreference(UUID playerId) {
        return playerPreferences.containsKey(playerId);
    }

    public static class_2338 searchForPreferredContainerWithItemMatching(class_2338 golemPos, class_1937 world, String preference, int depositRange, int verticalRange, class_1799 heldItem) {
        class_2338 bestMatchingContainer = null;
        double bestMatchingScore = Double.MAX_VALUE;
        class_2338 bestEmptyContainer = null;
        double bestEmptyScore = Double.MAX_VALUE;
        int searchRange = Math.max(depositRange * 2, 16);
        for (int x = -searchRange; x <= searchRange; ++x) {
            for (int y = -verticalRange; y <= verticalRange; ++y) {
                for (int z = -searchRange; z <= searchRange; ++z) {
                    class_2680 state;
                    double verticalDist;
                    class_2338 pos = golemPos.method_10069(x, y, z);
                    double horizontalDist = Math.sqrt(Math.pow(pos.method_10263() - golemPos.method_10263(), 2.0) + Math.pow(pos.method_10260() - golemPos.method_10260(), 2.0));
                    if (horizontalDist > (double)searchRange || (verticalDist = (double)Math.abs(pos.method_10264() - golemPos.method_10264())) > (double)depositRange || !CopperGolemChestSearchMixin.matchesPreference(state = world.method_8320(pos), world, pos, preference)) continue;
                    boolean hasSpace = CopperGolemChestSearchMixin.hasAvailableSpaceForItem(world, pos, heldItem);
                    boolean hasItemMatch = CopperGolemChestSearchMixin.containerHasItemType(world, pos, heldItem);
                    if (!hasSpace) continue;
                    if (hasItemMatch) {
                        double matchScore = horizontalDist * 0.01;
                        if (!((matchScore += verticalDist * 0.001) < bestMatchingScore)) continue;
                        bestMatchingContainer = pos;
                        bestMatchingScore = matchScore;
                        LOGGER.debug("New best MATCHING at {} (h: {}, v: {}, score: {})", new Object[]{pos, horizontalDist, verticalDist, matchScore});
                        continue;
                    }
                    double emptyScore = horizontalDist * 10.0;
                    if (!((emptyScore += verticalDist * 5.0) < bestEmptyScore)) continue;
                    bestEmptyContainer = pos;
                    bestEmptyScore = emptyScore;
                }
            }
        }
        if (bestMatchingContainer != null) {
            LOGGER.info("Selected MATCHING container at {} (score: {})", bestMatchingContainer, (Object)bestMatchingScore);
            return bestMatchingContainer;
        }
        if (bestEmptyContainer != null) {
            LOGGER.info("Selected EMPTY container at {} (score: {})", bestEmptyContainer, (Object)bestEmptyScore);
        }
        return bestEmptyContainer;
    }

    private static boolean matchesPreference(class_2680 state, class_1937 world, class_2338 pos, String preference) {
        return switch (preference) {
            case "shulker" -> state.method_26204() instanceof class_2480;
            case "barrel" -> state.method_26204() instanceof class_3708;
            case "chest" -> {
                if (state.method_26204() instanceof class_2281 && !CopperGolemChestSearchMixin.isCopperChest(state, world, pos)) {
                    yield true;
                }
                yield false;
            }
            case "any" -> {
                if (state.method_26204() instanceof class_2480 || state.method_26204() instanceof class_3708 || state.method_26204() instanceof class_2281 && !CopperGolemChestSearchMixin.isCopperChest(state, world, pos)) {
                    yield true;
                }
                yield false;
            }
            default -> false;
        };
    }

    private static boolean containerHasItemType(class_1937 world, class_2338 pos, class_1799 heldItem) {
        class_2586 blockEntity = world.method_8321(pos);
        if (!(blockEntity instanceof class_2621)) {
            return false;
        }
        class_2621 container = (class_2621)blockEntity;
        for (int i = 0; i < container.method_5439(); ++i) {
            class_1799 slotStack = container.method_5438(i);
            if (slotStack.method_7960() || slotStack.method_7909() != heldItem.method_7909() || slotStack.method_7947() >= slotStack.method_7914()) continue;
            return true;
        }
        return false;
    }

    private static boolean hasAvailableSpaceForItem(class_1937 world, class_2338 pos, class_1799 heldItem) {
        class_2586 blockEntity = world.method_8321(pos);
        if (!(blockEntity instanceof class_2621)) {
            return false;
        }
        class_2621 container = (class_2621)blockEntity;
        for (int i = 0; i < container.method_5439(); ++i) {
            class_1799 slotStack = container.method_5438(i);
            if (slotStack.method_7960()) {
                return true;
            }
            if (slotStack.method_7909() != heldItem.method_7909() || slotStack.method_7947() >= slotStack.method_7914()) continue;
            return true;
        }
        return false;
    }

    private static class_3222 findNearestPlayer(class_1308 copperGolem, class_1937 world) {
        if (world.method_8608()) {
            return null;
        }
        class_3218 serverWorld = (class_3218)world;
        class_3222 nearestPlayer = null;
        double nearestDistance = Double.MAX_VALUE;
        for (class_3222 player : serverWorld.method_18456()) {
            double distance = player.method_5858((class_1297)copperGolem);
            if (!(distance < nearestDistance) || !(distance < 4096.0)) continue;
            nearestDistance = distance;
            nearestPlayer = player;
        }
        return nearestPlayer;
    }

    private static boolean isCopperChest(class_2680 state, class_1937 world, class_2338 pos) {
        try {
            String className;
            String blockName = state.method_26204().method_63499().toLowerCase();
            if (blockName.contains("copper") && blockName.contains("chest")) {
                return true;
            }
            class_2586 entity = world.method_8321(pos);
            return entity != null && (className = entity.getClass().getSimpleName().toLowerCase()).contains("copper");
        }
        catch (Exception e) {
            return false;
        }
    }

    public static class_2338 searchForContainer(class_2338 golemPos, class_1937 world, String preference, int range) {
        return CopperGolemChestSearchMixin.searchForPreferredContainerWithItemMatching(golemPos, world, preference, range, 8, class_1799.field_8037);
    }
}

