/*
 * Decompiled with CFR 0.152.
 */
package com.example.coppergolemshulker;

import com.example.coppergolemshulker.mixin.CopperGolemChestSearchMixin;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import java.util.HashMap;
import java.util.Map;
import net.fabricmc.api.ModInitializer;
import net.fabricmc.fabric.api.command.v2.CommandRegistrationCallback;
import net.fabricmc.fabric.api.event.lifecycle.v1.ServerTickEvents;
import net.minecraft.class_1268;
import net.minecraft.class_1297;
import net.minecraft.class_1308;
import net.minecraft.class_1799;
import net.minecraft.class_1937;
import net.minecraft.class_2168;
import net.minecraft.class_2170;
import net.minecraft.class_2281;
import net.minecraft.class_2338;
import net.minecraft.class_2382;
import net.minecraft.class_2480;
import net.minecraft.class_2561;
import net.minecraft.class_2586;
import net.minecraft.class_2621;
import net.minecraft.class_2680;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_3417;
import net.minecraft.class_3708;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CopperGolemShulkerExtension
implements ModInitializer {
    public static final String MOD_ID = "copper_golem_shulker_extension";
    public static final Logger LOGGER = LoggerFactory.getLogger((String)"copper_golem_shulker_extension");
    private static final Map<Integer, Integer> lastUpdate = new HashMap<Integer, Integer>();

    public void onInitialize() {
        LOGGER.info("Initializing Copper Golem Container Extension (Smart Navigation)");
        CommandRegistrationCallback.EVENT.register((dispatcher, registryAccess, environment) -> dispatcher.register((LiteralArgumentBuilder)class_2170.method_9247((String)"coppergolem").then(((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)class_2170.method_9247((String)"prefer").then(class_2170.method_9247((String)"shulker").executes(context -> {
            class_3222 player = ((class_2168)context.getSource()).method_9207();
            CopperGolemChestSearchMixin.setPlayerPreference(player.method_5667(), "shulker");
            player.method_64398((class_2561)class_2561.method_43470((String)"\u00a76Copper Golems will now prefer Shulker Boxes for item storage!"));
            return 1;
        }))).then(class_2170.method_9247((String)"barrel").executes(context -> {
            class_3222 player = ((class_2168)context.getSource()).method_9207();
            CopperGolemChestSearchMixin.setPlayerPreference(player.method_5667(), "barrel");
            player.method_64398((class_2561)class_2561.method_43470((String)"\u00a76Copper Golems will now prefer Barrels for item storage!"));
            return 1;
        }))).then(class_2170.method_9247((String)"chest").executes(context -> {
            class_3222 player = ((class_2168)context.getSource()).method_9207();
            CopperGolemChestSearchMixin.setPlayerPreference(player.method_5667(), "chest");
            player.method_64398((class_2561)class_2561.method_43470((String)"\u00a76Copper Golems will now prefer regular Chests for item storage!"));
            return 1;
        }))).then(class_2170.method_9247((String)"any").executes(context -> {
            class_3222 player = ((class_2168)context.getSource()).method_9207();
            CopperGolemChestSearchMixin.setPlayerPreference(player.method_5667(), "any");
            player.method_64398((class_2561)class_2561.method_43470((String)"\u00a76Copper Golems restored to vanilla behavior!"));
            return 1;
        }))).then(class_2170.method_9247((String)"status").executes(context -> {
            class_3222 player = ((class_2168)context.getSource()).method_9207();
            String preference = CopperGolemChestSearchMixin.getPlayerPreference(player.method_5667());
            player.method_64398((class_2561)class_2561.method_43470((String)("\u00a76Current preference: " + preference)));
            return 1;
        })))));
        ServerTickEvents.END_SERVER_TICK.register(server -> {
            int currentTick = server.method_3780();
            for (class_3218 world : server.method_3738()) {
                for (class_1297 entity : world.method_27909()) {
                    if (!entity.getClass().getSimpleName().equals("class_11573")) continue;
                    this.enhanceGolemNavigation((class_1308)entity, (class_1937)world, currentTick);
                }
            }
            lastUpdate.entrySet().removeIf(entry -> currentTick - (Integer)entry.getValue() > 1200);
        });
    }

    private void enhanceGolemNavigation(class_1308 copperGolem, class_1937 world, int currentTick) {
        int entityId = copperGolem.method_5628();
        class_1799 heldItem = copperGolem.method_6047();
        if (heldItem.method_7960()) {
            return;
        }
        if (lastUpdate.containsKey(entityId) && currentTick - lastUpdate.get(entityId) < 40) {
            return;
        }
        class_3222 owner = this.findNearestPlayer(copperGolem, world);
        String preference = owner != null ? CopperGolemChestSearchMixin.getPlayerPreference(owner.method_5667()) : "any";
        class_2338 target = this.findBestContainer(copperGolem.method_24515(), world, preference);
        if (target != null) {
            double distance = copperGolem.method_24515().method_10262((class_2382)target);
            if (distance <= 4.0 && this.tryDepositItemDirect(copperGolem, target, world, heldItem)) {
                LOGGER.info("Successfully deposited item from golem {} into {} at {}", new Object[]{entityId, preference, target});
                lastUpdate.put(entityId, currentTick);
                return;
            }
            if (distance > 4.0) {
                copperGolem.method_5942().method_6340();
                boolean success = copperGolem.method_5942().method_6337((double)target.method_10263() + 0.5, (double)target.method_10264(), (double)target.method_10260() + 0.5, 1.0);
                if (success) {
                    LOGGER.info("Guiding golem {} to {} at {} (distance: {})", new Object[]{entityId, preference, target, Math.sqrt(distance)});
                }
            }
        } else {
            LOGGER.info("No suitable {} container found for golem {}", (Object)preference, (Object)entityId);
        }
        lastUpdate.put(entityId, currentTick);
    }

    private boolean tryDepositItemDirect(class_1308 copperGolem, class_2338 containerPos, class_1937 world, class_1799 heldItem) {
        class_2586 blockEntity = world.method_8321(containerPos);
        if (blockEntity instanceof class_2621) {
            class_2621 container = (class_2621)blockEntity;
            class_2680 state = world.method_8320(containerPos);
            if (!this.isAllowedContainer(state)) {
                LOGGER.info("Rejected container deposit at {} (not in allowed list)", (Object)containerPos);
                return false;
            }
            for (int i = 0; i < container.method_5439(); ++i) {
                int spaceLeft;
                class_1799 slotStack = container.method_5438(i);
                if (slotStack.method_7960()) {
                    container.method_5447(i, heldItem.method_7972());
                    copperGolem.method_6122(class_1268.field_5808, class_1799.field_8037);
                    container.method_5431();
                    copperGolem.method_5783(class_3417.field_15197, 0.8f, 1.0f);
                    return true;
                }
                if (!this.canStackItemsDirect(slotStack, heldItem) || (spaceLeft = slotStack.method_7914() - slotStack.method_7947()) <= 0) continue;
                int amountToAdd = Math.min(spaceLeft, heldItem.method_7947());
                slotStack.method_7933(amountToAdd);
                heldItem.method_7934(amountToAdd);
                if (heldItem.method_7960()) {
                    copperGolem.method_6122(class_1268.field_5808, class_1799.field_8037);
                }
                container.method_5431();
                copperGolem.method_5783(class_3417.field_15197, 0.8f, 1.0f);
                return true;
            }
        }
        return false;
    }

    private boolean canStackItemsDirect(class_1799 stack1, class_1799 stack2) {
        return stack1.method_7909() == stack2.method_7909();
    }

    private boolean isAllowedContainer(class_2680 state) {
        String blockName = state.method_26204().method_63499().toLowerCase();
        LOGGER.info("DEBUG: Checking container block '{}' for deposit", (Object)blockName);
        if (state.method_26204() instanceof class_2480) {
            LOGGER.info("DEBUG: Accepted shulker box: {}", (Object)blockName);
            return true;
        }
        if (state.method_26204() instanceof class_3708) {
            LOGGER.info("DEBUG: Accepted barrel: {}", (Object)blockName);
            return true;
        }
        if (state.method_26204() instanceof class_2281) {
            if (blockName.contains("chest") && !blockName.contains("copper")) {
                LOGGER.info("DEBUG: Accepted chest (non-copper): {}", (Object)blockName);
                return true;
            }
            LOGGER.info("DEBUG: Rejected chest (copper or other): {}", (Object)blockName);
            return false;
        }
        LOGGER.info("DEBUG: Rejected unknown container type: {}", (Object)blockName);
        return false;
    }

    private class_3222 findNearestPlayer(class_1308 copperGolem, class_1937 world) {
        class_3222 nearestPlayer = null;
        double nearestDistance = Double.MAX_VALUE;
        for (class_3222 player : ((class_3218)world).method_18456()) {
            double distance = player.method_5858((class_1297)copperGolem);
            if (!(distance < nearestDistance) || !(distance < 4096.0)) continue;
            nearestDistance = distance;
            nearestPlayer = player;
        }
        return nearestPlayer;
    }

    private class_2338 findBestContainer(class_2338 golemPos, class_1937 world, String preference) {
        class_2338 nearestContainer = null;
        double nearestDistance = Double.MAX_VALUE;
        LOGGER.info("Searching for {} containers around {}", (Object)preference, (Object)golemPos);
        for (int x = -32; x <= 32; ++x) {
            for (int y = -8; y <= 8; ++y) {
                for (int z = -32; z <= 32; ++z) {
                    class_2338 pos = golemPos.method_10069(x, y, z);
                    double distance = golemPos.method_10262((class_2382)pos);
                    boolean isTargetType = false;
                    class_2680 state = world.method_8320(pos);
                    switch (preference) {
                        case "shulker": {
                            if (!(state.method_26204() instanceof class_2480)) break;
                            isTargetType = true;
                            LOGGER.info("Found shulker box at {} (distance: {})", (Object)pos, (Object)Math.sqrt(distance));
                            break;
                        }
                        case "barrel": {
                            if (!(state.method_26204() instanceof class_3708)) break;
                            isTargetType = true;
                            LOGGER.info("Found barrel at {} (distance: {})", (Object)pos, (Object)Math.sqrt(distance));
                            break;
                        }
                        case "chest": {
                            String blockName;
                            if (!(state.method_26204() instanceof class_2281) || !(blockName = state.method_26204().method_63499().toLowerCase()).contains("chest") || blockName.contains("copper")) break;
                            isTargetType = true;
                            LOGGER.info("Found chest {} at {} (distance: {})", new Object[]{blockName, pos, Math.sqrt(distance)});
                            break;
                        }
                        case "any": {
                            if (state.method_26204() instanceof class_2480) {
                                isTargetType = true;
                                LOGGER.info("Found shulker box at {} (distance: {})", (Object)pos, (Object)Math.sqrt(distance));
                                break;
                            }
                            if (state.method_26204() instanceof class_3708) {
                                isTargetType = true;
                                LOGGER.info("Found barrel at {} (distance: {})", (Object)pos, (Object)Math.sqrt(distance));
                                break;
                            }
                            if (!(state.method_26204() instanceof class_2281)) break;
                            String blockName = state.method_26204().method_63499().toLowerCase();
                            if (blockName.contains("chest") && !blockName.contains("copper")) {
                                isTargetType = true;
                                LOGGER.info("Found chest {} at {} (distance: {})", new Object[]{blockName, pos, Math.sqrt(distance)});
                                break;
                            }
                            LOGGER.debug("Skipped copper chest {} at {}", (Object)blockName, (Object)pos);
                        }
                    }
                    if (!isTargetType || !(distance < nearestDistance) || !this.hasAvailableSpace(world, pos)) continue;
                    nearestContainer = pos;
                    nearestDistance = distance;
                    LOGGER.info("New nearest {} container: {} (distance: {})", new Object[]{preference, pos, Math.sqrt(distance)});
                }
            }
        }
        if (nearestContainer != null) {
            LOGGER.info("Best {} container found: {} (distance: {})", new Object[]{preference, nearestContainer, Math.sqrt(nearestDistance)});
        } else {
            LOGGER.info("No suitable {} container found", (Object)preference);
        }
        return nearestContainer;
    }

    private boolean hasAvailableSpace(class_1937 world, class_2338 pos) {
        class_2586 blockEntity = world.method_8321(pos);
        if (!(blockEntity instanceof class_2621)) {
            return false;
        }
        class_2621 container = (class_2621)blockEntity;
        for (int i = 0; i < container.method_5439(); ++i) {
            if (!container.method_5438(i).method_7960()) continue;
            return true;
        }
        return false;
    }
}

