/*
 * Decompiled with CFR 0.152.
 */
package com.example.coppergolemshulker.mixin;

import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import net.minecraft.class_1268;
import net.minecraft.class_1297;
import net.minecraft.class_1308;
import net.minecraft.class_1799;
import net.minecraft.class_1937;
import net.minecraft.class_2281;
import net.minecraft.class_2338;
import net.minecraft.class_2382;
import net.minecraft.class_2480;
import net.minecraft.class_2586;
import net.minecraft.class_2621;
import net.minecraft.class_2680;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_3417;
import net.minecraft.class_3708;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(targets={"net.minecraft.class_11573"}, remap=false)
public class CopperGolemChestSearchMixin {
    private static final Logger LOGGER = LoggerFactory.getLogger((String)"CopperGolemMixin");
    private static final Map<UUID, String> playerPreferences = new HashMap<UUID, String>();

    public static void setPlayerPreference(UUID playerId, String preference) {
        playerPreferences.put(playerId, preference);
        LOGGER.info("Set preference for player {}: {}", (Object)playerId, (Object)preference);
    }

    public static String getPlayerPreference(UUID playerId) {
        return playerPreferences.getOrDefault(playerId, "any");
    }

    public static Map<UUID, String> getAllPreferences() {
        return new HashMap<UUID, String>(playerPreferences);
    }

    @Inject(method={"*"}, at={@At(value="HEAD")}, cancellable=true, require=0)
    private void interceptContainerSearch(CallbackInfoReturnable<class_2338> cir) {
        try {
            class_1308 copperGolem = (class_1308)this;
            class_1937 world = copperGolem.method_73183();
            if (copperGolem.method_6047().method_7960()) {
                return;
            }
            String preference = this.findPlayerPreference(copperGolem, world);
            if ("any".equals(preference)) {
                return;
            }
            class_2338 preferredContainer = CopperGolemChestSearchMixin.searchForPreferredContainer(copperGolem.method_24515(), world, preference);
            if (preferredContainer != null) {
                LOGGER.info("Mixin: Redirecting golem {} to {} container at {}", new Object[]{copperGolem.method_5628(), preference, preferredContainer});
                cir.setReturnValue((Object)preferredContainer);
                cir.cancel();
            }
        }
        catch (Exception e) {
            LOGGER.debug("Mixin intercept skipped: {}", (Object)e.getMessage());
        }
    }

    @Inject(method={"*"}, at={@At(value="HEAD")}, cancellable=true, require=0)
    private void interceptItemDeposit(CallbackInfo ci) {
        try {
            double distance;
            class_1308 copperGolem = (class_1308)this;
            class_1937 world = copperGolem.method_73183();
            class_1799 heldItem = copperGolem.method_6047();
            if (heldItem.method_7960()) {
                return;
            }
            String preference = this.findPlayerPreference(copperGolem, world);
            class_2338 targetPos = CopperGolemChestSearchMixin.searchForPreferredContainer(copperGolem.method_24515(), world, preference);
            if (targetPos != null && (distance = copperGolem.method_24515().method_10262((class_2382)targetPos)) <= 4.0 && this.tryDepositItem(copperGolem, targetPos, world, heldItem)) {
                LOGGER.info("Mixin: Successfully deposited item from golem {} into {} at {}", new Object[]{copperGolem.method_5628(), preference, targetPos});
                ci.cancel();
            }
        }
        catch (Exception e) {
            LOGGER.debug("Mixin deposit skipped: {}", (Object)e.getMessage());
        }
    }

    private boolean tryDepositItem(class_1308 copperGolem, class_2338 containerPos, class_1937 world, class_1799 heldItem) {
        class_2586 blockEntity = world.method_8321(containerPos);
        if (blockEntity instanceof class_2621) {
            class_2621 container = (class_2621)blockEntity;
            for (int i = 0; i < container.method_5439(); ++i) {
                int spaceLeft;
                class_1799 slotStack = container.method_5438(i);
                if (slotStack.method_7960()) {
                    container.method_5447(i, heldItem.method_7972());
                    copperGolem.method_6122(class_1268.field_5808, class_1799.field_8037);
                    container.method_5431();
                    copperGolem.method_5783(class_3417.field_15197, 0.8f, 1.0f);
                    return true;
                }
                if (!this.canStackItems(slotStack, heldItem) || (spaceLeft = slotStack.method_7914() - slotStack.method_7947()) <= 0) continue;
                int amountToAdd = Math.min(spaceLeft, heldItem.method_7947());
                slotStack.method_7933(amountToAdd);
                heldItem.method_7934(amountToAdd);
                if (heldItem.method_7960()) {
                    copperGolem.method_6122(class_1268.field_5808, class_1799.field_8037);
                }
                container.method_5431();
                copperGolem.method_5783(class_3417.field_15197, 0.8f, 1.0f);
                return true;
            }
        }
        return false;
    }

    private static boolean isCopperChest(class_2680 state, class_1937 world, class_2338 pos) {
        try {
            String blockName = state.method_26204().method_63499().toLowerCase();
            if (blockName.contains("copper") && blockName.contains("chest")) {
                return true;
            }
            class_2586 entity = world.method_8321(pos);
            if (entity != null) {
                String className = entity.getClass().getSimpleName().toLowerCase();
                if (className.contains("copper")) {
                    return true;
                }
                String fullClassName = entity.getClass().getName().toLowerCase();
                if (fullClassName.contains("copper") && fullClassName.contains("chest")) {
                    return true;
                }
            }
            try {
                String translationKey = state.method_26204().method_63499();
                if (translationKey.contains("copper_chest")) {
                    return true;
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            return false;
        }
        catch (Exception e) {
            return false;
        }
    }

    private boolean canStackItems(class_1799 stack1, class_1799 stack2) {
        return stack1.method_7909() == stack2.method_7909();
    }

    private String findPlayerPreference(class_1308 copperGolem, class_1937 world) {
        if (world.method_8608()) {
            return "any";
        }
        class_3218 serverWorld = (class_3218)world;
        class_3222 nearestPlayer = null;
        double nearestDistance = Double.MAX_VALUE;
        for (class_3222 player : serverWorld.method_18456()) {
            double distance = player.method_5858((class_1297)copperGolem);
            if (!(distance < nearestDistance) || !(distance < 4096.0)) continue;
            nearestDistance = distance;
            nearestPlayer = player;
        }
        return nearestPlayer != null ? CopperGolemChestSearchMixin.getPlayerPreference(nearestPlayer.method_5667()) : "any";
    }

    public static class_2338 searchForContainer(class_2338 golemPos, class_1937 world, String preference) {
        return CopperGolemChestSearchMixin.searchForPreferredContainer(golemPos, world, preference);
    }

    private static class_2338 searchForPreferredContainer(class_2338 golemPos, class_1937 world, String preference) {
        class_2338 nearestContainer = null;
        double nearestDistance = Double.MAX_VALUE;
        for (int x = -32; x <= 32; ++x) {
            for (int y = -8; y <= 8; ++y) {
                for (int z = -32; z <= 32; ++z) {
                    class_2338 pos = golemPos.method_10069(x, y, z);
                    double distance = golemPos.method_10262((class_2382)pos);
                    boolean isTargetType = false;
                    class_2680 state = world.method_8320(pos);
                    switch (preference) {
                        case "shulker": {
                            isTargetType = state.method_26204() instanceof class_2480;
                            break;
                        }
                        case "barrel": {
                            isTargetType = state.method_26204() instanceof class_3708;
                            break;
                        }
                        case "chest": {
                            class_2586 entity;
                            if (!(state.method_26204() instanceof class_2281) || (entity = world.method_8321(pos)) == null) break;
                            String className = entity.getClass().getSimpleName().toLowerCase();
                            isTargetType = !className.contains("copper");
                            break;
                        }
                        case "any": {
                            String className;
                            class_2586 entity;
                            if (state.method_26204() instanceof class_2281) {
                                entity = world.method_8321(pos);
                                if (entity == null) break;
                                className = entity.getClass().getSimpleName().toLowerCase();
                                isTargetType = !className.contains("copper");
                                break;
                            }
                            if (state.method_26204() instanceof class_3708) {
                                isTargetType = true;
                                break;
                            }
                            if (!(state.method_26204() instanceof class_2480)) break;
                            isTargetType = true;
                        }
                    }
                    if (!isTargetType || !(distance < nearestDistance) || !CopperGolemChestSearchMixin.hasAvailableSpace(world, pos)) continue;
                    nearestContainer = pos;
                    nearestDistance = distance;
                }
            }
        }
        return nearestContainer;
    }

    private static boolean hasAvailableSpace(class_1937 world, class_2338 pos) {
        class_2586 blockEntity = world.method_8321(pos);
        if (!(blockEntity instanceof class_2621)) {
            return false;
        }
        class_2621 container = (class_2621)blockEntity;
        for (int i = 0; i < container.method_5439(); ++i) {
            if (!container.method_5438(i).method_7960()) continue;
            return true;
        }
        return false;
    }
}

