/*
 * Decompiled with CFR 0.152.
 */
package com.example.coppergolemshulker.mixin;

import com.example.coppergolemshulker.CopperGolemShulkerExtension;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import net.minecraft.class_1297;
import net.minecraft.class_1308;
import net.minecraft.class_1937;
import net.minecraft.class_2281;
import net.minecraft.class_2338;
import net.minecraft.class_2382;
import net.minecraft.class_2480;
import net.minecraft.class_2586;
import net.minecraft.class_2621;
import net.minecraft.class_2680;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_3708;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(targets={"net.minecraft.class_11573"}, remap=false)
public class CopperGolemChestSearchMixin {
    private static final Logger LOGGER = LoggerFactory.getLogger((String)"CopperGolemMixin");
    private static final Map<UUID, String> playerPreferences = new HashMap<UUID, String>();

    public static void setPlayerPreference(UUID playerId, String preference) {
        playerPreferences.put(playerId, preference);
        LOGGER.info("Set preference for player {}: {}", (Object)playerId, (Object)preference);
    }

    public static String getPlayerPreference(UUID playerId) {
        return playerPreferences.getOrDefault(playerId, "any");
    }

    public static Map<UUID, String> getAllPreferences() {
        return new HashMap<UUID, String>(playerPreferences);
    }

    public static void removePlayerPreference(UUID playerId) {
        String oldPref = playerPreferences.remove(playerId);
        LOGGER.info("Removed preference for player {} (was: {})", (Object)playerId, (Object)oldPref);
    }

    public static boolean hasPlayerPreference(UUID playerId) {
        return playerPreferences.containsKey(playerId);
    }

    @Inject(method={"*"}, at={@At(value="HEAD")}, cancellable=true, require=0)
    private void interceptContainerSearch(CallbackInfoReturnable<class_2338> cir) {
        try {
            class_3222 owner;
            class_1308 copperGolem = (class_1308)this;
            class_1937 world = copperGolem.method_73183();
            if (!copperGolem.method_6047().method_7960() && (owner = this.findPlayerPreference(copperGolem, world)) != null && CopperGolemChestSearchMixin.hasPlayerPreference(owner.method_5667())) {
                String preference = CopperGolemChestSearchMixin.getPlayerPreference(owner.method_5667());
                int range = CopperGolemShulkerExtension.getPlayerDepositRange(owner.method_5667());
                class_2338 customContainer = CopperGolemChestSearchMixin.searchForPreferredContainer(copperGolem.method_24515(), world, preference, range);
                if (customContainer != null) {
                    LOGGER.info("Mixin Search: Golem {} -> {} container at {} (range: {})", new Object[]{copperGolem.method_5628(), preference, customContainer, range});
                    cir.setReturnValue((Object)customContainer);
                    cir.cancel();
                } else {
                    LOGGER.debug("Mixin Search: No {} container found in {} block range", (Object)preference, (Object)range);
                    cir.setReturnValue(null);
                    cir.cancel();
                }
            }
        }
        catch (Exception e) {
            LOGGER.debug("Mixin Search failed: {}", (Object)e.getMessage());
        }
    }

    private class_3222 findPlayerPreference(class_1308 copperGolem, class_1937 world) {
        if (world.method_8608()) {
            return null;
        }
        class_3218 serverWorld = (class_3218)world;
        class_3222 nearestPlayer = null;
        double nearestDistance = Double.MAX_VALUE;
        for (class_3222 player : serverWorld.method_18456()) {
            double distance = player.method_5858((class_1297)copperGolem);
            if (!(distance < nearestDistance) || !(distance < 4096.0)) continue;
            nearestDistance = distance;
            nearestPlayer = player;
        }
        return nearestPlayer;
    }

    public static class_2338 searchForContainer(class_2338 golemPos, class_1937 world, String preference, int range) {
        return CopperGolemChestSearchMixin.searchForPreferredContainer(golemPos, world, preference, range);
    }

    private static class_2338 searchForPreferredContainer(class_2338 golemPos, class_1937 world, String preference, int range) {
        class_2338 bestContainer = null;
        double bestScore = Double.MAX_VALUE;
        int verticalRange = 8;
        if (world instanceof class_3218) {
            class_3218 serverWorld = (class_3218)world;
            class_3222 nearestPlayer = null;
            double nearestDistance = Double.MAX_VALUE;
            for (class_3222 player : serverWorld.method_18456()) {
                double distance = player.method_5649((double)golemPos.method_10263(), (double)golemPos.method_10264(), (double)golemPos.method_10260());
                if (!(distance < nearestDistance) || !(distance < 4096.0)) continue;
                nearestDistance = distance;
                nearestPlayer = player;
            }
            if (nearestPlayer != null) {
                verticalRange = CopperGolemShulkerExtension.getPlayerVerticalRange(nearestPlayer.method_5667());
            }
        }
        int searchRange = Math.max(range * 2, 16);
        for (int x = -searchRange; x <= searchRange; ++x) {
            for (int y = -verticalRange; y <= verticalRange; ++y) {
                for (int z = -searchRange; z <= searchRange; ++z) {
                    double heightPenalty;
                    double score;
                    class_2338 pos = golemPos.method_10069(x, y, z);
                    double distance = golemPos.method_10262((class_2382)pos);
                    if (distance > (double)(searchRange * searchRange) || !CopperGolemChestSearchMixin.isValidContainer(world, pos)) continue;
                    boolean isTargetType = false;
                    double priorityMultiplier = 1.0;
                    class_2680 state = world.method_8320(pos);
                    switch (preference) {
                        case "shulker": {
                            isTargetType = state.method_26204() instanceof class_2480;
                            break;
                        }
                        case "barrel": {
                            isTargetType = state.method_26204() instanceof class_3708;
                            break;
                        }
                        case "chest": {
                            isTargetType = state.method_26204() instanceof class_2281 && !CopperGolemChestSearchMixin.isCopperChest(state, world, pos);
                            break;
                        }
                        case "any": {
                            if (state.method_26204() instanceof class_2480) {
                                isTargetType = true;
                                priorityMultiplier = 0.8;
                                break;
                            }
                            if (state.method_26204() instanceof class_3708) {
                                isTargetType = true;
                                priorityMultiplier = 0.9;
                                break;
                            }
                            if (!(state.method_26204() instanceof class_2281) || CopperGolemChestSearchMixin.isCopperChest(state, world, pos)) break;
                            isTargetType = true;
                        }
                    }
                    if (!isTargetType || !CopperGolemChestSearchMixin.hasAvailableSpace(world, pos) || !((score = distance * priorityMultiplier + (heightPenalty = (double)Math.max(0, pos.method_10264() - golemPos.method_10264()) * 0.5)) < bestScore)) continue;
                    bestContainer = pos;
                    bestScore = score;
                }
            }
        }
        if (bestContainer != null) {
            String finalType = CopperGolemChestSearchMixin.getContainerTypeName(world.method_8320(bestContainer));
            LOGGER.info("Smart Mixin Search: Best {} {} at {} (score: {}, vRange: {})", new Object[]{preference, finalType, bestContainer, bestScore, verticalRange});
        }
        return bestContainer;
    }

    private static boolean isValidContainer(class_1937 world, class_2338 pos) {
        class_2680 state = world.method_8320(pos);
        return state.method_26204() instanceof class_2480 || state.method_26204() instanceof class_3708 || state.method_26204() instanceof class_2281;
    }

    private static boolean isCopperChest(class_2680 state, class_1937 world, class_2338 pos) {
        try {
            String className;
            String blockName = state.method_26204().method_63499().toLowerCase();
            if (blockName.contains("copper") && blockName.contains("chest")) {
                return true;
            }
            class_2586 entity = world.method_8321(pos);
            return entity != null && (className = entity.getClass().getSimpleName().toLowerCase()).contains("copper");
        }
        catch (Exception e) {
            return false;
        }
    }

    private static String getContainerTypeName(class_2680 state) {
        if (state.method_26204() instanceof class_2480) {
            return "shulker";
        }
        if (state.method_26204() instanceof class_3708) {
            return "barrel";
        }
        if (state.method_26204() instanceof class_2281) {
            return "chest";
        }
        return "unknown";
    }

    private static boolean hasAvailableSpace(class_1937 world, class_2338 pos) {
        class_2586 blockEntity = world.method_8321(pos);
        if (!(blockEntity instanceof class_2621)) {
            return false;
        }
        class_2621 container = (class_2621)blockEntity;
        for (int i = 0; i < container.method_5439(); ++i) {
            if (!container.method_5438(i).method_7960()) continue;
            return true;
        }
        return false;
    }
}

