/*
 * Decompiled with CFR 0.152.
 */
package de.miraculixx.kpaper.scoreboard;

import de.miraculixx.kpaper.scoreboard.PlayerScoreboardKt;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.UUID;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import net.kyori.adventure.text.Component;
import org.bukkit.Bukkit;
import org.bukkit.entity.Player;
import org.bukkit.scoreboard.Criteria;
import org.bukkit.scoreboard.DisplaySlot;
import org.bukkit.scoreboard.Objective;
import org.bukkit.scoreboard.Scoreboard;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010%\n\u0002\u0010\b\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\b\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u000e\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\nJ\u0016\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\t2\u0006\u0010\u0012\u001a\u00020\nJ\u0006\u0010\u0016\u001a\u00020\u0011J\u0006\u0010\u0017\u001a\u00020\u0011J\u000e\u0010\u0018\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\tJ\u000e\u0010\u0019\u001a\u00020\u00112\u0006\u0010\u001a\u001a\u00020\u0005J\u0006\u0010\u001b\u001a\u00020\u0011R\u001a\u0010\u0007\u001a\u000e\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00020\n0\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0013\u0010\u000b\u001a\u00070\f\u00a2\u0006\u0002\b\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0013\u0010\u000e\u001a\u00070\u000f\u00a2\u0006\u0002\b\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001c"}, d2={"Lde/miraculixx/kpaper/scoreboard/PlayerScoreboard;", "", "player", "Lorg/bukkit/entity/Player;", "displayName", "Lnet/kyori/adventure/text/Component;", "(Lorg/bukkit/entity/Player;Lnet/kyori/adventure/text/Component;)V", "lines", "", "", "", "objective", "Lorg/bukkit/scoreboard/Objective;", "Lorg/jetbrains/annotations/NotNull;", "scoreboard", "Lorg/bukkit/scoreboard/Scoreboard;", "addLine", "", "name", "editLine", "", "line", "hide", "removeComplete", "removeLine", "setTitle", "title", "show", "KPaper-Light"})
public final class PlayerScoreboard {
    @NotNull
    private final Scoreboard scoreboard;
    @NotNull
    private final Objective objective;
    @NotNull
    private final Map<Integer, String> lines;

    public PlayerScoreboard(@NotNull Player player, @NotNull Component displayName) {
        Intrinsics.checkNotNullParameter((Object)player, (String)"player");
        Intrinsics.checkNotNullParameter((Object)displayName, (String)"displayName");
        Scoreboard scoreboard = Bukkit.getScoreboardManager().getNewScoreboard();
        Intrinsics.checkNotNullExpressionValue((Object)scoreboard, (String)"getNewScoreboard(...)");
        this.scoreboard = scoreboard;
        Objective objective = this.scoreboard.registerNewObjective("kpaper_player_scoreboard", Criteria.DUMMY, displayName);
        Intrinsics.checkNotNullExpressionValue((Object)objective, (String)"registerNewObjective(...)");
        this.objective = objective;
        this.lines = new LinkedHashMap();
        this.objective.setDisplaySlot(DisplaySlot.SIDEBAR);
        player.setScoreboard(this.scoreboard);
        Map map = PlayerScoreboardKt.access$getScoreboards$p();
        UUID uUID = player.getUniqueId();
        Intrinsics.checkNotNullExpressionValue((Object)uUID, (String)"getUniqueId(...)");
        map.put(uUID, this);
    }

    public final void removeComplete() {
        this.objective.unregister();
    }

    public final void show() {
        this.objective.setDisplaySlot(DisplaySlot.SIDEBAR);
    }

    public final void hide() {
        this.objective.setDisplaySlot(null);
    }

    public final void setTitle(@NotNull Component title) {
        Intrinsics.checkNotNullParameter((Object)title, (String)"title");
        this.objective.displayName(title);
    }

    public final void addLine(@NotNull String name) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        int id = this.lines.size();
        this.objective.getScore(name).setScore(15 - id);
        Integer n = id;
        this.lines.put(n, name);
    }

    public final boolean editLine(int line, @NotNull String name) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        String string = this.lines.get(line);
        if (string == null) {
            return false;
        }
        this.objective.getScore(string).resetScore();
        this.objective.getScore(name).setScore(15 - line);
        Integer n = line;
        this.lines.put(n, name);
        return true;
    }

    public final boolean removeLine(int line) {
        String string = this.lines.get(line);
        if (string == null) {
            return false;
        }
        String key = string;
        if (this.lines.size() - 1 == line) {
            this.objective.getScore(key).resetScore();
            this.lines.remove(line);
            return true;
        }
        int riser = line + 1;
        while (this.lines.containsKey(riser)) {
            String currentKey;
            Intrinsics.checkNotNull((Object)this.lines.get(riser));
            this.objective.getScore(currentKey).resetScore();
            this.lines.remove(riser);
            this.editLine(riser - 1, currentKey);
            ++riser;
        }
        return true;
    }
}

