/*
 * Decompiled with CFR 0.152.
 */
package de.miraculixx.mcommons.text;

import de.miraculixx.mcommons.serializer.YAMLSerializer;
import de.miraculixx.mcommons.text.ComponentExtensionsKt;
import de.miraculixx.mcommons.text.GlobalColorsKt;
import de.miraculixx.mcommons.text.GlobalTextKt;
import de.miraculixx.mcommons.text.LocalizationKt;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.io.FilesKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import net.kyori.adventure.audience.Audience;
import net.kyori.adventure.text.Component;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010!\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\u0018\u00002\u00020\u0001B1\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u001a\u0010\u0006\u001a\u0016\u0012\u0012\u0012\u0010\u0012\u0004\u0012\u00020\u0005\u0012\u0006\u0012\u0004\u0018\u00010\t0\b0\u0007\u00a2\u0006\u0002\u0010\nJ\u0010\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0010H\u0002J\b\u0010\u0011\u001a\u00020\u0012H\u0002J\f\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u00050\u0007J\u000e\u0010\u0014\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0005R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\u00050\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0015"}, d2={"Lde/miraculixx/mcommons/text/Localization;", "", "folder", "Ljava/io/File;", "active", "Ljava/util/Locale;", "keys", "", "Lkotlin/Pair;", "Ljava/io/InputStream;", "(Ljava/io/File;Ljava/util/Locale;Ljava/util/List;)V", "languages", "", "checkFile", "", "key", "", "checkFiles", "", "getLoadedKeys", "setLanguage", "MCCommons"})
@SourceDebugExtension(value={"SMAP\nLocalization.kt\nKotlin\n*S Kotlin\n*F\n+ 1 Localization.kt\nde/miraculixx/mcommons/text/Localization\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 4 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n*L\n1#1,142:1\n1855#2:143\n1856#2:145\n1#3:144\n13309#4,2:146\n*S KotlinDebug\n*F\n+ 1 Localization.kt\nde/miraculixx/mcommons/text/Localization\n*L\n135#1:143\n135#1:145\n112#1:146,2\n*E\n"})
public final class Localization {
    @NotNull
    private final File folder;
    @NotNull
    private final List<Locale> languages;

    public Localization(@NotNull File folder, @NotNull Locale active, @NotNull List<? extends Pair<Locale, ? extends InputStream>> keys) {
        Intrinsics.checkNotNullParameter((Object)folder, (String)"folder");
        Intrinsics.checkNotNullParameter((Object)active, (String)"active");
        Intrinsics.checkNotNullParameter(keys, (String)"keys");
        this.folder = folder;
        this.languages = new ArrayList();
        if (!this.folder.exists()) {
            this.folder.mkdirs();
        }
        Iterable $this$forEach$iv = keys;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            Pair it = (Pair)element$iv;
            boolean bl = false;
            Object object = (InputStream)it.getSecond();
            if (object == null) continue;
            byte[] byArray = ((InputStream)object).readAllBytes();
            object = byArray;
            if (byArray == null) continue;
            Intrinsics.checkNotNull((Object)object);
            byte[] bytes = byArray;
            boolean bl2 = false;
            FilesKt.writeBytes((File)new File(this.folder.getPath() + "/" + it.getFirst() + ".yml"), (byte[])bytes);
        }
        this.checkFiles();
        this.setLanguage(active);
    }

    @NotNull
    public final List<Locale> getLoadedKeys() {
        return this.languages;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public final boolean setLanguage(@NotNull Locale key) {
        Intrinsics.checkNotNullParameter((Object)key, (String)"key");
        if (LocalizationKt.access$getLocalization$p().get(key) == null) {
            String string = key.toString();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
            if (!this.checkFile(string)) return false;
        }
        LocalizationKt.setDefaultLocale(key);
        Audience audience = GlobalTextKt.getConsoleAudience();
        Component component2 = ComponentExtensionsKt.plus(GlobalTextKt.getPrefix(), ComponentExtensionsKt.cmp$default("Changed default language to ", null, false, false, false, false, 62, null));
        String string = key.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
        audience.sendMessage(ComponentExtensionsKt.plus(component2, ComponentExtensionsKt.cmp$default(string, GlobalColorsKt.getCHighlight(), false, false, false, false, 60, null)));
        return true;
    }

    private final void checkFiles() {
        block1: {
            this.languages.clear();
            File[] fileArray = this.folder.listFiles();
            if (fileArray == null) break block1;
            File[] $this$forEach$iv = fileArray;
            boolean $i$f$forEach = false;
            int n = $this$forEach$iv.length;
            for (int j = 0; j < n; ++j) {
                File element$iv;
                File it = element$iv = $this$forEach$iv[j];
                boolean bl = false;
                Intrinsics.checkNotNull((Object)it);
                String key = FilesKt.getNameWithoutExtension((File)it);
                if (!this.checkFile(key)) continue;
                Locale locale = Locale.forLanguageTag(key);
                Intrinsics.checkNotNull((Object)locale);
                this.languages.add(locale);
                GlobalTextKt.getConsoleAudience().sendMessage(ComponentExtensionsKt.plus(ComponentExtensionsKt.plus(GlobalTextKt.getPrefix(), ComponentExtensionsKt.cmp$default("Loaded language ", null, false, false, false, false, 62, null)), ComponentExtensionsKt.cmp$default(key, GlobalColorsKt.getCHighlight(), false, false, false, false, 60, null)));
            }
        }
    }

    private final boolean checkFile(String key) {
        File file = new File(this.folder.getPath() + "/" + key + ".yml");
        if (!file.exists()) {
            GlobalTextKt.getConsoleAudience().sendMessage(ComponentExtensionsKt.plus(GlobalTextKt.getPrefix(), ComponentExtensionsKt.cmp$default("LANG - " + key + " file not exist", null, false, false, false, false, 62, null)));
            return false;
        }
        YAMLSerializer config = new YAMLSerializer(new FileInputStream(file), key, file);
        Map map = LocalizationKt.access$getLocalization$p();
        Locale locale = Locale.forLanguageTag(key);
        Intrinsics.checkNotNullExpressionValue((Object)locale, (String)"forLanguageTag(...)");
        map.put(locale, config);
        return true;
    }
}

