/*
 * Decompiled with CFR 0.152.
 */
package de.miraculixx.timer.commandapi;

import com.mojang.brigadier.Message;
import com.mojang.brigadier.exceptions.SimpleCommandExceptionType;
import de.miraculixx.timer.commandapi.CommandAPIConfig;
import de.miraculixx.timer.commandapi.CommandAPIHandler;
import de.miraculixx.timer.commandapi.CommandAPILogger;
import de.miraculixx.timer.commandapi.CommandAPIPlatform;
import de.miraculixx.timer.commandapi.CommandAPIVersionHandler;
import de.miraculixx.timer.commandapi.InternalConfig;
import de.miraculixx.timer.commandapi.LoadContext;
import de.miraculixx.timer.commandapi.RegisteredCommand;
import de.miraculixx.timer.commandapi.Tooltip;
import de.miraculixx.timer.commandapi.commandsenders.AbstractPlayer;
import de.miraculixx.timer.commandapi.exceptions.WrapperCommandSyntaxException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class CommandAPI {
    private static boolean canRegister;
    private static boolean loaded;
    private static InternalConfig config;
    private static CommandAPILogger logger;
    private static String loadedStack;

    private CommandAPI() {
    }

    public static boolean isLoaded() {
        return loaded;
    }

    public static void stopCommandRegistration() {
        canRegister = false;
    }

    public static boolean canRegister() {
        return canRegister;
    }

    public static InternalConfig getConfiguration() {
        if (config != null) {
            return config;
        }
        throw new IllegalStateException("Tried to access InternalConfig, but it was null! Are you using CommandAPI features before calling CommandAPI#onLoad?");
    }

    public static void setLogger(CommandAPILogger logger) {
        CommandAPI.logger = logger;
    }

    public static CommandAPILogger getLogger() {
        if (logger == null) {
            logger = CommandAPIHandler.getInstance().getPlatform().getLogger();
        }
        return logger;
    }

    public static void onLoad(CommandAPIConfig<?> config) {
        if (!loaded) {
            StringBuilder currentStack = new StringBuilder();
            for (StackTraceElement e : Thread.currentThread().getStackTrace()) {
                currentStack.append(e.toString());
                currentStack.append("\n");
            }
            loadedStack = currentStack.toString();
            CommandAPI.config = new InternalConfig(config);
            LoadContext loadContext = CommandAPIVersionHandler.getPlatform();
            CommandAPIPlatform<?, ?, ?> platform = loadContext.platform();
            new CommandAPIHandler(platform);
            loadContext.context().run();
            ArrayList<String> platformClassHierarchyList = new ArrayList<String>();
            for (Class<?> platformClass = platform.getClass(); platformClass != null && platformClass != Object.class; platformClass = platformClass.getSuperclass()) {
                platformClassHierarchyList.add(platformClass.getSimpleName());
            }
            String platformClassHierarchy = String.join((CharSequence)" > ", platformClassHierarchyList);
            CommandAPI.logNormal("Loaded platform " + platformClassHierarchy);
            CommandAPIHandler.getInstance().onLoad(config);
            loaded = true;
        } else {
            CommandAPI.getLogger().severe("You've tried to call the CommandAPI's onLoad() method more than once!");
            StringBuilder currentStack = new StringBuilder();
            for (StackTraceElement e : Thread.currentThread().getStackTrace()) {
                currentStack.append(e.toString());
                currentStack.append("\n");
            }
            CommandAPI.getLogger().severe("The CommandAPI was first loaded here:\n\n" + loadedStack + "\n\nBut it is now being loaded here:\n\n" + currentStack.toString());
        }
    }

    public static void onEnable() {
        CommandAPIHandler.getInstance().onEnable();
    }

    public static void onDisable() {
        canRegister = true;
        config = null;
        logger = null;
        loaded = false;
        CommandAPIHandler<?, ?, ?> handler = null;
        try {
            handler = CommandAPIHandler.getInstance();
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
        if (handler != null) {
            handler.onDisable();
        }
    }

    public static void logInfo(String message2) {
        if (config.hasVerboseOutput() && !config.hasSilentLogs()) {
            CommandAPI.getLogger().info(message2);
        }
    }

    public static void logNormal(String message2) {
        if (!config.hasSilentLogs()) {
            CommandAPI.getLogger().info(message2);
        }
    }

    public static void logWarning(String message2) {
        if (!config.hasSilentLogs()) {
            CommandAPI.getLogger().warning(message2);
        }
    }

    public static void logError(String message2) {
        CommandAPI.getLogger().severe(message2);
    }

    public static void logException(String message2, Throwable throwable) {
        CommandAPI.getLogger().severe(message2, throwable);
    }

    public static void reloadDatapacks() {
        CommandAPIHandler.getInstance().getPlatform().reloadDataPacks();
    }

    public static <CommandSender, Player extends CommandSender> void updateRequirements(Player player) {
        CommandAPIPlatform<?, ?, ?> platform = CommandAPIHandler.getInstance().getPlatform();
        platform.updateRequirements((AbstractPlayer)platform.wrapCommandSender(player));
    }

    public static WrapperCommandSyntaxException failWithString(String message2) {
        return CommandAPI.failWithMessage(Tooltip.messageFromString(message2));
    }

    public static WrapperCommandSyntaxException failWithMessage(Message message2) {
        return new WrapperCommandSyntaxException(new SimpleCommandExceptionType(message2).create());
    }

    public static void unregister(String command) {
        CommandAPIHandler.getInstance().getPlatform().unregister(command, false);
    }

    public static void unregister(String command, boolean unregisterNamespaces) {
        CommandAPIHandler.getInstance().getPlatform().unregister(command, unregisterNamespaces);
    }

    public static void registerCommand(Class<?> commandClass) {
        try {
            Class.forName(commandClass.getName() + "$Command").getDeclaredMethod("register", new Class[0]).invoke(null, new Object[0]);
        }
        catch (ReflectiveOperationException e) {
            e.printStackTrace();
        }
    }

    public static List<RegisteredCommand> getRegisteredCommands() {
        return Collections.unmodifiableList(CommandAPIHandler.getInstance().registeredCommands);
    }

    static {
        CommandAPI.onDisable();
    }
}

