/*
 * Decompiled with CFR 0.152.
 */
package de.miraculixx.timer.commandapi.network;

import de.miraculixx.timer.commandapi.exceptions.ProtocolVersionTooOldException;
import de.miraculixx.timer.commandapi.network.CommandAPIPacket;
import de.miraculixx.timer.commandapi.network.CommandAPIPacketHandler;
import de.miraculixx.timer.commandapi.network.packets.ProtocolVersionTooOldPacket;
import de.miraculixx.timer.commandapi.network.packets.SetVersionPacket;

public interface HandshakePacketHandler<InputChannel>
extends CommandAPIPacketHandler<InputChannel> {
    @Override
    default public void handlePacket(InputChannel sender, CommandAPIPacket packet) {
        if (packet instanceof SetVersionPacket) {
            SetVersionPacket p = (SetVersionPacket)packet;
            this.handleSetVersionPacket(sender, p);
        } else if (packet instanceof ProtocolVersionTooOldPacket) {
            ProtocolVersionTooOldPacket p = (ProtocolVersionTooOldPacket)packet;
            this.handleProtocolVersionTooOldPacket(sender, p);
        } else {
            throw new IllegalStateException("Tried to handle " + String.valueOf(packet) + " with HandshakePacketHandler. HandshakePacketHandler can't handle this packet.");
        }
    }

    public void handleSetVersionPacket(InputChannel var1, SetVersionPacket var2);

    default public void handleProtocolVersionTooOldPacket(InputChannel sender, ProtocolVersionTooOldPacket packet) {
        throw ProtocolVersionTooOldException.received(sender, packet.protocolVersion(), packet.reason());
    }
}

