/*
 * Decompiled with CFR 0.152.
 */
package com.mrh0.createaddition.blocks.connector.base;

import com.mrh0.createaddition.blocks.connector.base.AbstractConnectorBlock;
import com.mrh0.createaddition.blocks.connector.base.ConnectorMode;
import com.mrh0.createaddition.config.Config;
import com.mrh0.createaddition.debug.IDebugDrawer;
import com.mrh0.createaddition.energy.IWireNode;
import com.mrh0.createaddition.energy.LocalNode;
import com.mrh0.createaddition.energy.NodeRotation;
import com.mrh0.createaddition.energy.WireType;
import com.mrh0.createaddition.energy.network.EnergyNetwork;
import com.mrh0.createaddition.network.EnergyNetworkPacket;
import com.mrh0.createaddition.network.IObserveTileEntity;
import com.mrh0.createaddition.network.ObservePacket;
import com.mrh0.createaddition.transfer.EnergyTransferable;
import com.mrh0.createaddition.util.Util;
import com.simibubi.create.api.equipment.goggles.IHaveGoggleInformation;
import com.simibubi.create.foundation.blockEntity.SmartBlockEntity;
import io.github.fabricators_of_create.porting_lib.transfer.TransferUtil;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import net.createmod.catnip.outliner.Outliner;
import net.fabricmc.fabric.api.transfer.v1.transaction.Transaction;
import net.fabricmc.fabric.api.transfer.v1.transaction.TransactionContext;
import net.minecraft.class_124;
import net.minecraft.class_1922;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2487;
import net.minecraft.class_2499;
import net.minecraft.class_2520;
import net.minecraft.class_2561;
import net.minecraft.class_2586;
import net.minecraft.class_259;
import net.minecraft.class_2591;
import net.minecraft.class_265;
import net.minecraft.class_2680;
import net.minecraft.class_2769;
import net.minecraft.class_3222;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import team.reborn.energy.api.EnergyStorage;

public abstract class AbstractConnectorBlockEntity
extends SmartBlockEntity
implements EnergyTransferable,
IWireNode,
IObserveTileEntity,
IHaveGoggleInformation,
IDebugDrawer {
    private final Set<LocalNode> wireCache = new HashSet<LocalNode>();
    private final LocalNode[] localNodes;
    private final IWireNode[] nodeCache;
    private EnergyNetwork network;
    private long demand = 0L;
    private boolean wasContraption = false;
    private boolean firstTick = true;
    @NotNull
    protected EnergyStorage networkStorage = new NetworkEnergyStorage();
    @NotNull
    protected EnergyStorage externalStorage = EnergyStorage.EMPTY;
    boolean externalStorageInvalid = false;

    public AbstractConnectorBlockEntity(class_2591<?> blockEntityTypeIn, class_2338 pos, class_2680 state) {
        super(blockEntityTypeIn, pos, state);
        this.localNodes = new LocalNode[this.getNodeCount()];
        this.nodeCache = new IWireNode[this.getNodeCount()];
    }

    @Override
    public EnergyStorage getEnergyStorage(class_2350 side) {
        if (this.isEnergyInput(side) || this.isEnergyOutput(side)) {
            return this.networkStorage;
        }
        return null;
    }

    public abstract long getMaxIn();

    public abstract long getMaxOut();

    public long getCapacityOutside() {
        return Math.min(this.getMaxIn(), this.getMaxOut());
    }

    @Override
    @Nullable
    public IWireNode getWireNode(int index) {
        return IWireNode.getWireNodeFrom(index, this, this.localNodes, this.nodeCache, this.field_11863);
    }

    @Override
    @Nullable
    public LocalNode getLocalNode(int index) {
        return this.localNodes[index];
    }

    @Override
    public void setNode(int index, int other, class_2338 pos, WireType type) {
        this.localNodes[index] = new LocalNode((class_2586)this, index, other, type, pos);
        this.notifyUpdate();
        if (this.network != null) {
            this.network.invalidate();
        }
    }

    @Override
    public void removeNode(int index, boolean dropWire) {
        LocalNode old = this.localNodes[index];
        this.localNodes[index] = null;
        this.nodeCache[index] = null;
        this.invalidateNodeCache();
        this.notifyUpdate();
        if (this.network != null) {
            this.network.invalidate();
        }
        if (dropWire && old != null) {
            this.wireCache.add(old);
        }
    }

    @Override
    public class_2338 getPos() {
        return this.method_11016();
    }

    @Override
    public void setNetwork(int node, EnergyNetwork network) {
        this.network = network;
    }

    @Override
    public EnergyNetwork getNetwork(int node) {
        return this.network;
    }

    public boolean isEnergyInput(class_2350 side) {
        return this.method_11010().method_11654((class_2769)AbstractConnectorBlock.FACING) == side;
    }

    public boolean isEnergyOutput(class_2350 side) {
        return this.method_11010().method_11654((class_2769)AbstractConnectorBlock.FACING) == side;
    }

    public void read(class_2487 nbt, boolean clientPacket) {
        super.read(nbt, clientPacket);
        if (!clientPacket && nbt.method_10545("node0")) {
            this.convertOldNbt(nbt);
            this.method_5431();
        }
        this.invalidateLocalNodes();
        this.invalidateNodeCache();
        class_2499 nodes = nbt.method_10554("nodes", 10);
        nodes.forEach(tag -> {
            LocalNode localNode;
            this.localNodes[localNode.getIndex()] = localNode = new LocalNode((class_2586)this, (class_2487)tag);
        });
        if (nbt.method_10545("contraption") && !clientPacket) {
            this.wasContraption = nbt.method_10577("contraption");
            NodeRotation rotation = (NodeRotation)((Object)this.method_11010().method_11654(NodeRotation.ROTATION));
            if (this.field_11863 == null) {
                return;
            }
            if (rotation != NodeRotation.NONE) {
                this.field_11863.method_8652(this.method_11016(), (class_2680)this.method_11010().method_11657(NodeRotation.ROTATION, (Comparable)((Object)NodeRotation.NONE)), 0);
            }
            for (LocalNode localNode : this.localNodes) {
                if (localNode == null) continue;
                localNode.updateRelative(rotation);
            }
        }
        if (!nodes.isEmpty() && this.network != null) {
            this.network.invalidate();
        }
    }

    public void write(class_2487 nbt, boolean clientPacket) {
        super.write(nbt, clientPacket);
        class_2499 nodes = new class_2499();
        for (int i = 0; i < this.getNodeCount(); ++i) {
            LocalNode localNode = this.localNodes[i];
            if (localNode == null) continue;
            class_2487 tag = new class_2487();
            localNode.write(tag);
            nodes.add((Object)tag);
        }
        nbt.method_10566("nodes", (class_2520)nodes);
    }

    private void validateNodes() {
        boolean changed = this.validateLocalNodes(this.localNodes);
        this.notifyUpdate();
        if (changed) {
            this.invalidateNodeCache();
            if (this.network != null) {
                this.network.invalidate();
            }
        }
    }

    public void firstTick() {
        this.firstTick = false;
        if (this.field_11863 == null) {
            return;
        }
        if (this.wasContraption && !this.field_11863.method_8608()) {
            this.wasContraption = false;
            this.validateNodes();
        }
        this.updateExternalEnergyStorage();
    }

    protected void specialTick() {
    }

    public void tick() {
        if (this.firstTick) {
            this.firstTick();
        }
        if (this.field_11863 == null) {
            return;
        }
        if (!this.field_11863.method_8477(this.method_11016())) {
            return;
        }
        if (!this.wireCache.isEmpty() && !this.method_11015()) {
            this.handleWireCache(this.field_11863, this.wireCache);
        }
        this.specialTick();
        if (this.getMode() == ConnectorMode.None) {
            return;
        }
        super.tick();
        if (this.field_11863 == null) {
            return;
        }
        if (this.field_11863.method_8608()) {
            return;
        }
        if (this.awakeNetwork(this.field_11863)) {
            this.notifyUpdate();
        }
        this.networkTick(this.network);
        if (this.externalStorageInvalid) {
            this.updateExternalEnergyStorage();
        }
    }

    private void networkTick(EnergyNetwork network) {
        Transaction t;
        ConnectorMode mode = this.getMode();
        if (this.field_11863 == null) {
            return;
        }
        if (this.field_11863.method_8608()) {
            return;
        }
        if (mode == ConnectorMode.Push) {
            long pulled;
            t = TransferUtil.getTransaction();
            try {
                pulled = network.pull(network.demand(this.externalStorage.insert(this.getMaxOut(), (TransactionContext)t)));
            }
            finally {
                if (t != null) {
                    t.close();
                }
            }
            t = TransferUtil.getTransaction();
            try {
                this.externalStorage.insert(pulled, (TransactionContext)t);
                t.commit();
            }
            finally {
                if (t != null) {
                    t.close();
                }
            }
        }
        if (mode == ConnectorMode.Pull) {
            long toPush;
            t = TransferUtil.getTransaction();
            try {
                toPush = this.externalStorage.extract(network.push(this.getMaxIn(), true), (TransactionContext)t);
                t.commit();
            }
            finally {
                if (t != null) {
                    t.close();
                }
            }
            network.push(toPush);
        }
    }

    public void remove() {
        if (this.field_11863 == null) {
            return;
        }
        if (this.field_11863.method_8608()) {
            return;
        }
        for (int i = 0; i < this.getNodeCount(); ++i) {
            IWireNode otherNode;
            LocalNode localNode = this.getLocalNode(i);
            if (localNode == null || (otherNode = this.getWireNode(i)) == null) continue;
            int ourNode = localNode.getOtherIndex();
            if (localNode.isInvalid()) {
                otherNode.removeNode(ourNode);
                continue;
            }
            otherNode.removeNode(ourNode, true);
        }
        this.invalidateNodeCache();
        this.invalidateCaps();
        if (this.network != null) {
            this.network.invalidate();
        }
    }

    public void invalidateLocalNodes() {
        for (int i = 0; i < this.getNodeCount(); ++i) {
            this.localNodes[i] = null;
        }
    }

    @Override
    public void invalidateNodeCache() {
        for (int i = 0; i < this.getNodeCount(); ++i) {
            this.nodeCache[i] = null;
        }
    }

    public ConnectorMode getMode() {
        return (ConnectorMode)((Object)this.method_11010().method_11654(AbstractConnectorBlock.MODE));
    }

    @Override
    public void onObserved(class_3222 player, ObservePacket pack) {
        if (this.isNetworkValid(0)) {
            EnergyNetworkPacket.send(this.field_11867, this.getNetwork(0).getPulled(), this.getNetwork(0).getPushed(), player);
        } else {
            EnergyNetworkPacket.send(this.field_11867, 0L, 0L, player);
        }
    }

    public boolean addToGoggleTooltip(List<class_2561> tooltip, boolean isPlayerSneaking) {
        ObservePacket.send(this.field_11867, 0);
        String spacing = " ";
        tooltip.add((class_2561)class_2561.method_43470((String)spacing).method_10852((class_2561)class_2561.method_43471((String)"createaddition.tooltip.connector.info").method_27692(class_124.field_1068)));
        tooltip.add((class_2561)class_2561.method_43470((String)spacing).method_10852((class_2561)class_2561.method_43471((String)"createaddition.tooltip.energy.mode").method_27692(class_124.field_1080)));
        tooltip.add((class_2561)class_2561.method_43470((String)spacing).method_10852((class_2561)class_2561.method_43470((String)" ")).method_10852((class_2561)((ConnectorMode)((Object)this.method_11010().method_11654(AbstractConnectorBlock.MODE))).getTooltip().method_27692(class_124.field_1075)));
        tooltip.add((class_2561)class_2561.method_43470((String)spacing).method_10852((class_2561)class_2561.method_43471((String)"createaddition.tooltip.energy.usage").method_27692(class_124.field_1080)));
        tooltip.add((class_2561)class_2561.method_43470((String)spacing).method_27693(" ").method_27693(Util.format((int)EnergyNetworkPacket.clientBuff)).method_27693("fe/t").method_27692(class_124.field_1075));
        return true;
    }

    public boolean ignoreCapSide() {
        return ((ConnectorMode)((Object)this.method_11010().method_11654(AbstractConnectorBlock.MODE))).isActive();
    }

    public void updateExternalEnergyStorage() {
        if (this.field_11863 == null) {
            return;
        }
        if (!this.field_11863.method_8477(this.method_11016())) {
            return;
        }
        this.externalStorageInvalid = false;
        class_2350 side = (class_2350)this.method_11010().method_11654((class_2769)AbstractConnectorBlock.FACING);
        class_2338 externalPos = this.field_11867.method_10093(side);
        if (!this.field_11863.method_8477(externalPos)) {
            this.externalStorage = EnergyStorage.EMPTY;
            return;
        }
        EnergyStorage es = (EnergyStorage)EnergyStorage.SIDED.find(this.field_11863, externalPos, (Object)side.method_10153());
        if (this.ignoreCapSide() && es == null) {
            es = (EnergyStorage)EnergyStorage.SIDED.find(this.field_11863, externalPos, null);
        }
        this.externalStorage = es == null ? EnergyStorage.EMPTY : es;
    }

    @Override
    public void drawDebug() {
        if (this.field_11863 == null) {
            return;
        }
        for (int i = 0; i < this.getNodeCount(); ++i) {
            LocalNode localNode = this.localNodes[i];
            if (localNode == null) continue;
            class_2338 pos = localNode.getPos();
            class_2680 state = this.field_11863.method_8320(pos);
            class_265 shape = state.method_26222((class_1922)this.field_11863, pos);
            int color = i == 0 ? 0xFF0000 : (i == 1 ? 65280 : (i == 2 ? 255 : 0xFFFFFF));
            if (!(this.field_11863.method_8321(pos) instanceof IWireNode)) {
                shape = class_259.method_1077();
                color = 0xFF00FF;
            }
            Outliner.getInstance().chaseAABB((Object)("ca_nodes_" + i), shape.method_1107().method_996(pos)).lineWidth(0.0625f).colored(color);
        }
        class_2338 pos = this.field_11867.method_10093((class_2350)this.method_11010().method_11654((class_2769)AbstractConnectorBlock.FACING));
        EnergyStorage cap = (EnergyStorage)EnergyStorage.SIDED.find(this.field_11863, pos, (Object)((class_2350)this.method_11010().method_11654((class_2769)AbstractConnectorBlock.FACING)).method_10153());
        if (cap == null) {
            return;
        }
        class_265 shape = this.field_11863.method_8320(pos).method_26222((class_1922)this.field_11863, pos);
        Outliner.getInstance().chaseAABB((Object)"ca_output", shape.method_1107().method_996(pos)).lineWidth(0.0625f).colored(0x5B5BFF);
    }

    private class NetworkEnergyStorage
    implements EnergyStorage {
        private NetworkEnergyStorage() {
        }

        public long insert(long maxAmount, TransactionContext transaction) {
            if (!((Boolean)Config.CONNECTOR_ALLOW_PASSIVE_IO.get()).booleanValue()) {
                return 0L;
            }
            if (AbstractConnectorBlockEntity.this.getMode() != ConnectorMode.Pull) {
                return 0L;
            }
            if (AbstractConnectorBlockEntity.this.network == null) {
                return 0L;
            }
            maxAmount = Math.min(maxAmount, AbstractConnectorBlockEntity.this.getMaxIn());
            return AbstractConnectorBlockEntity.this.network.push(maxAmount);
        }

        public long extract(long maxAmount, TransactionContext transaction) {
            if (!((Boolean)Config.CONNECTOR_ALLOW_PASSIVE_IO.get()).booleanValue()) {
                return 0L;
            }
            if (AbstractConnectorBlockEntity.this.getMode() != ConnectorMode.Push) {
                return 0L;
            }
            if (AbstractConnectorBlockEntity.this.network == null) {
                return 0L;
            }
            maxAmount = Math.min(maxAmount, AbstractConnectorBlockEntity.this.getMaxOut());
            return AbstractConnectorBlockEntity.this.network.pull(maxAmount);
        }

        public long getAmount() {
            if (AbstractConnectorBlockEntity.this.network == null) {
                return 0L;
            }
            return Math.min(this.getCapacity(), AbstractConnectorBlockEntity.this.network.getBuff());
        }

        public long getCapacity() {
            return AbstractConnectorBlockEntity.this.getCapacityOutside();
        }
    }
}

