/*
 * Decompiled with CFR 0.152.
 */
package com.mrh0.createaddition.blocks.connector;

import com.mrh0.createaddition.blocks.connector.ConnectorType;
import com.mrh0.createaddition.blocks.connector.SmallLightConnectorBlock;
import com.mrh0.createaddition.blocks.connector.base.AbstractConnectorBlock;
import com.mrh0.createaddition.blocks.connector.base.AbstractConnectorBlockEntity;
import com.mrh0.createaddition.config.CommonConfig;
import com.mrh0.createaddition.energy.network.EnergyNetwork;
import com.mrh0.createaddition.index.CABlockEntities;
import com.simibubi.create.foundation.blockEntity.behaviour.BlockEntityBehaviour;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.Vec3;
import net.neoforged.neoforge.capabilities.Capabilities;
import net.neoforged.neoforge.capabilities.RegisterCapabilitiesEvent;

public class SmallLightConnectorBlockEntity
extends AbstractConnectorBlockEntity {
    private static final float OFFSET_HEIGHT = 5.5f;
    public static final Vec3 OFFSET_DOWN = new Vec3(0.0, -0.34375, 0.0);
    public static final Vec3 OFFSET_UP = new Vec3(0.0, 0.34375, 0.0);
    public static final Vec3 OFFSET_NORTH = new Vec3(0.0, 0.0, -0.34375);
    public static final Vec3 OFFSET_WEST = new Vec3(-0.34375, 0.0, 0.0);
    public static final Vec3 OFFSET_SOUTH = new Vec3(0.0, 0.0, 0.34375);
    public static final Vec3 OFFSET_EAST = new Vec3(0.34375, 0.0, 0.0);
    private int posTimeOffset = 0;
    private int tickToggleTimer = 0;

    public SmallLightConnectorBlockEntity(BlockEntityType<?> blockEntityTypeIn, BlockPos pos, BlockState state) {
        super(blockEntityTypeIn, pos, state);
        this.posTimeOffset = 10 + Math.abs(pos.getX() * 31 + pos.getY() * 45 + pos.getZ() * 33) % 7 * 3;
    }

    public static void registerCapabilities(RegisterCapabilitiesEvent event) {
        event.registerBlockEntity(Capabilities.EnergyStorage.BLOCK, (BlockEntityType)CABlockEntities.SMALL_LIGHT_CONNECTOR.get(), (be, context) -> be.internal);
    }

    @Override
    public void read(CompoundTag nbt, HolderLookup.Provider registries, boolean clientPacket) {
        this.tickToggleTimer = nbt.getInt("tick_toggle_timer");
        super.read(nbt, registries, clientPacket);
    }

    public void writeSafe(CompoundTag nbt, HolderLookup.Provider registries) {
        nbt.putInt("tick_toggle_timer", this.tickToggleTimer);
        super.writeSafe(nbt, registries);
    }

    public void addBehaviours(List<BlockEntityBehaviour> list) {
    }

    @Override
    public int getMaxIn() {
        return (Integer)CommonConfig.SMALL_CONNECTOR_MAX_INPUT.get();
    }

    @Override
    public int getMaxOut() {
        return (Integer)CommonConfig.SMALL_CONNECTOR_MAX_OUTPUT.get();
    }

    @Override
    public int getNodeCount() {
        return 4;
    }

    @Override
    public Vec3 getNodeOffset(int node) {
        return switch ((Direction)this.getBlockState().getValue((Property)AbstractConnectorBlock.FACING)) {
            default -> throw new MatchException(null, null);
            case Direction.DOWN -> OFFSET_DOWN;
            case Direction.UP -> OFFSET_UP;
            case Direction.NORTH -> OFFSET_NORTH;
            case Direction.WEST -> OFFSET_WEST;
            case Direction.SOUTH -> OFFSET_SOUTH;
            case Direction.EAST -> OFFSET_EAST;
        };
    }

    @Override
    public ConnectorType getConnectorType() {
        return ConnectorType.Small;
    }

    @Override
    public int getMaxWireLength() {
        return (Integer)CommonConfig.SMALL_CONNECTOR_MAX_LENGTH.get();
    }

    @Override
    protected void specialTick() {
        if (this.getLevel() == null) {
            return;
        }
        if (this.level.isClientSide()) {
            return;
        }
        EnergyNetwork network = this.getNetwork(0);
        if (network != null) {
            network.demand(1);
        }
        boolean hasEnergy = network != null && network.pull((Integer)CommonConfig.SMALL_LIGHT_CONNECTOR_CONSUMPTION.get(), false) > 0;
        this.tickToggleTimer += hasEnergy ? 1 : -1;
        if (this.tickToggleTimer >= this.posTimeOffset) {
            this.tickToggleTimer = this.posTimeOffset;
            if (!((Boolean)this.getBlockState().getValue((Property)SmallLightConnectorBlock.POWERED)).booleanValue()) {
                this.getLevel().setBlockAndUpdate(this.getBlockPos(), (BlockState)this.getBlockState().setValue((Property)SmallLightConnectorBlock.POWERED, (Comparable)Boolean.valueOf(true)));
            }
        }
        if (this.tickToggleTimer <= -this.posTimeOffset) {
            this.tickToggleTimer = -this.posTimeOffset;
            if (((Boolean)this.getBlockState().getValue((Property)SmallLightConnectorBlock.POWERED)).booleanValue()) {
                this.getLevel().setBlockAndUpdate(this.getBlockPos(), (BlockState)this.getBlockState().setValue((Property)SmallLightConnectorBlock.POWERED, (Comparable)Boolean.valueOf(false)));
            }
        }
    }
}

