/*
 * Decompiled with CFR 0.152.
 */
package com.mrh0.createaddition.blocks.creative_energy;

import com.mrh0.createaddition.energy.CreativeEnergyStorage;
import com.mrh0.createaddition.index.CABlockEntities;
import com.simibubi.create.content.logistics.crate.CrateBlockEntity;
import java.util.EnumMap;
import java.util.EnumSet;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.neoforged.neoforge.capabilities.BlockCapability;
import net.neoforged.neoforge.capabilities.BlockCapabilityCache;
import net.neoforged.neoforge.capabilities.Capabilities;
import net.neoforged.neoforge.capabilities.RegisterCapabilitiesEvent;
import net.neoforged.neoforge.energy.IEnergyStorage;

public class CreativeEnergyBlockEntity
extends CrateBlockEntity {
    protected final CreativeEnergyStorage capability;
    private final EnumSet<Direction> invalidSides = EnumSet.allOf(Direction.class);
    private final EnumMap<Direction, BlockCapabilityCache<IEnergyStorage, Direction>> cache = new EnumMap(Direction.class);
    private boolean firstTickState = true;

    public CreativeEnergyBlockEntity(BlockEntityType<?> tileEntityTypeIn, BlockPos pos, BlockState state) {
        super(tileEntityTypeIn, pos, state);
        this.capability = new CreativeEnergyStorage();
    }

    public static void registerCapabilities(RegisterCapabilitiesEvent event) {
        event.registerBlockEntity(Capabilities.EnergyStorage.BLOCK, (BlockEntityType)CABlockEntities.CREATIVE_ENERGY.get(), (be, context) -> be.capability);
    }

    public void tick() {
        super.tick();
        if (this.level == null) {
            return;
        }
        if (this.level.isClientSide()) {
            return;
        }
        if (this.firstTickState) {
            this.firstTick();
        }
        this.firstTickState = false;
        for (Direction d : Direction.values()) {
            IEnergyStorage ies = (IEnergyStorage)this.cache.get(d).getCapability();
            if (ies == null) continue;
            ies.receiveEnergy(Integer.MAX_VALUE, false);
        }
    }

    public void firstTick() {
        this.updateCache();
    }

    public void updateCache() {
        if (this.level == null) {
            return;
        }
        if (this.level.isClientSide()) {
            return;
        }
        for (Direction side : Direction.values()) {
            this.cache.put(side, (BlockCapabilityCache<IEnergyStorage, Direction>)BlockCapabilityCache.create((BlockCapability)Capabilities.EnergyStorage.BLOCK, (ServerLevel)((ServerLevel)this.level), (BlockPos)this.getBlockPos().relative(side), (Object)side.getOpposite(), () -> !this.isRemoved(), () -> this.invalidSides.add(side)));
        }
    }
}

