/*
 * Decompiled with CFR 0.152.
 */
package com.mrh0.createaddition.blocks.electric_motor;

import com.mrh0.createaddition.blocks.electric_motor.ElectricMotorBlockEntity;
import com.mrh0.createaddition.index.CABlockEntities;
import com.mrh0.createaddition.shapes.CAShapes;
import com.simibubi.create.content.kinetics.base.DirectionalKineticBlock;
import com.simibubi.create.foundation.block.IBE;
import net.createmod.catnip.math.VoxelShaper;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.RandomSource;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.Nullable;

public class ElectricMotorBlock
extends DirectionalKineticBlock
implements IBE<ElectricMotorBlockEntity> {
    public static final VoxelShaper ELECTRIC_MOTOR_SHAPE = CAShapes.shape(0.0, 5.0, 0.0, 16.0, 11.0, 16.0).add(3.0, 0.0, 3.0, 13.0, 14.0, 13.0).forDirectional();
    public static final BooleanProperty POWERED = BlockStateProperties.POWERED;

    public ElectricMotorBlock(BlockBehaviour.Properties properties) {
        super(properties);
        this.registerDefaultState((BlockState)this.defaultBlockState().setValue((Property)POWERED, (Comparable)Boolean.valueOf(false)));
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        super.createBlockStateDefinition(builder);
        builder.add(new Property[]{POWERED});
    }

    public VoxelShape getShape(BlockState state, BlockGetter worldIn, BlockPos pos, CollisionContext context) {
        return ELECTRIC_MOTOR_SHAPE.get((Direction)state.getValue((Property)FACING));
    }

    @Nullable
    public BlockState getStateForPlacement(BlockPlaceContext context) {
        Direction preferred = this.getPreferredFacing(context);
        if (context.getPlayer() != null && context.getPlayer().isShiftKeyDown() || preferred == null) {
            return super.getStateForPlacement(context);
        }
        return (BlockState)this.defaultBlockState().setValue((Property)FACING, (Comparable)preferred);
    }

    public Class<ElectricMotorBlockEntity> getBlockEntityClass() {
        return ElectricMotorBlockEntity.class;
    }

    public BlockEntityType<? extends ElectricMotorBlockEntity> getBlockEntityType() {
        return (BlockEntityType)CABlockEntities.ELECTRIC_MOTOR.get();
    }

    public boolean hasShaftTowards(LevelReader world, BlockPos pos, BlockState state, Direction face) {
        return face == state.getValue((Property)FACING);
    }

    public Direction.Axis getRotationAxis(BlockState state) {
        return ((Direction)state.getValue((Property)FACING)).getAxis();
    }

    public boolean hideStressImpact() {
        return true;
    }

    public void setPowered(Level world, BlockPos pos, boolean powered) {
        world.setBlock(pos, (BlockState)world.getBlockState(pos).setValue((Property)POWERED, (Comparable)Boolean.valueOf(powered)), 3);
    }

    public boolean canConnectRedstone(BlockState state, BlockGetter world, BlockPos pos, @Nullable Direction side) {
        return true;
    }

    public void neighborChanged(BlockState state, Level world, BlockPos pos, Block block, BlockPos from, boolean b) {
        boolean flag;
        if (!world.isClientSide && (flag = ((Boolean)state.getValue((Property)POWERED)).booleanValue()) != world.hasNeighborSignal(pos)) {
            if (flag) {
                this.setPowered(world, pos, false);
                world.scheduleTick(pos, (Block)this, 4);
            } else {
                this.setPowered(world, pos, true);
                world.setBlock(pos, (BlockState)state.cycle((Property)POWERED), 2);
            }
        }
    }

    public void tick(BlockState state, ServerLevel world, BlockPos pos, RandomSource pRandom) {
        if (((Boolean)state.getValue((Property)POWERED)).booleanValue() && !world.hasNeighborSignal(pos)) {
            world.setBlock(pos, (BlockState)state.cycle((Property)POWERED), 2);
        }
    }

    public BlockEntity newBlockEntity(BlockPos pos, BlockState state) {
        return CABlockEntities.ELECTRIC_MOTOR.create(pos, state);
    }
}

