/*
 * Decompiled with CFR 0.152.
 */
package io.gitlab.jfronny.resclone;

import io.gitlab.jfronny.commons.io.JFiles;
import io.gitlab.jfronny.commons.logger.SystemLoggerPlus;
import io.gitlab.jfronny.resclone.RescloneConfig;
import io.gitlab.jfronny.resclone.data.PackMetaLoaded;
import io.gitlab.jfronny.resclone.data.PackMetaUnloaded;
import io.gitlab.jfronny.resclone.fetchers.BasicFileFetcher;
import io.gitlab.jfronny.resclone.fetchers.CurseforgeFetcher;
import io.gitlab.jfronny.resclone.fetchers.GitHubFetcher;
import io.gitlab.jfronny.resclone.fetchers.ModrinthFetcher;
import io.gitlab.jfronny.resclone.fetchers.PackFetcher;
import io.gitlab.jfronny.resclone.processors.PackProcessor;
import io.gitlab.jfronny.resclone.processors.PruneClutterProcessor;
import io.gitlab.jfronny.resclone.processors.PruneVanillaProcessor;
import io.gitlab.jfronny.resclone.processors.RemoveEmptyProcessor;
import io.gitlab.jfronny.resclone.processors.RootPathProcessor;
import io.gitlab.jfronny.resclone.util.PackUrlCache;
import java.io.IOException;
import java.net.URI;
import java.nio.file.FileSystem;
import java.nio.file.FileSystems;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.ModInitializer;
import net.fabricmc.loader.api.FabricLoader;
import net.fabricmc.loader.api.ModContainer;

public class Resclone
implements ModInitializer {
    public static final Map<String, PackFetcher> FETCHER_INSTANCES = new LinkedHashMap<String, PackFetcher>();
    public static final Set<PackProcessor> PROCESSORS = new LinkedHashSet<PackProcessor>();
    public static final Set<PackMetaLoaded> DOWNLOADED_PACKS = new LinkedHashSet<PackMetaLoaded>();
    public static final Set<PackMetaLoaded> NEW_PACKS = new LinkedHashSet<PackMetaLoaded>();
    public static final String MOD_ID = "resclone";
    public static final SystemLoggerPlus LOGGER = SystemLoggerPlus.forName((String)"resclone");
    public static final String USER_AGENT = "jfmods/resclone/" + ((ModContainer)FabricLoader.getInstance().getModContainer("resclone").orElseThrow()).getMetadata().getVersion().getFriendlyString();
    public static PackUrlCache urlCache;
    public static int packCount;

    public void onInitialize() {
        LOGGER.info("Initialising Resclone.", new Object[0]);
        urlCache = new PackUrlCache(Resclone.getConfigPath().resolve("urlCache.properties"));
        FETCHER_INSTANCES.clear();
        PROCESSORS.clear();
        DOWNLOADED_PACKS.clear();
        this.addProcessor(new RootPathProcessor());
        this.addFetcher(new BasicFileFetcher());
        this.addFetcher(new GitHubFetcher());
        this.addFetcher(new CurseforgeFetcher());
        this.addFetcher(new ModrinthFetcher());
        if (RescloneConfig.filterPacks) {
            this.addProcessor(new PruneVanillaProcessor());
            this.addProcessor(new PruneClutterProcessor());
            this.addProcessor(new RemoveEmptyProcessor());
        }
        this.reload();
        LOGGER.info("Installed {0} resource pack{1}.", new Object[]{packCount, packCount == 1 ? "" : "s"});
    }

    public void addFetcher(PackFetcher fetcher) {
        FETCHER_INSTANCES.put(fetcher.getSourceTypeName(), fetcher);
    }

    public void addProcessor(PackProcessor processor) {
        PROCESSORS.add(processor);
    }

    public void addPack(String fetcher, String pack, String name) {
        this.addPack(fetcher, pack, name, false);
    }

    public void addPack(String fetcher, String pack, String name, boolean forceRedownload) {
        this.addPack(fetcher, pack, name, forceRedownload, false);
    }

    public void addPack(String fetcher, String pack, String name, boolean forceRedownload, boolean forceEnable) {
        RescloneConfig.packs.add(new PackMetaUnloaded(fetcher, pack, name, forceRedownload, forceEnable));
    }

    public void reload() {
        LinkedHashSet<PackMetaLoaded> metas = new LinkedHashSet<PackMetaLoaded>();
        if (RescloneConfig.packs.isEmpty()) {
            LOGGER.info("No resclone pack was specified, add one", new Object[0]);
        } else {
            try (ExecutorService pool = Executors.newFixedThreadPool(RescloneConfig.packs.size());){
                for (PackMetaUnloaded s : RescloneConfig.packs) {
                    pool.submit(this.generateTask(s, metas));
                }
                pool.shutdown();
                if (!pool.awaitTermination(Long.MAX_VALUE, TimeUnit.MILLISECONDS)) {
                    LOGGER.error("Download timed out. This shouldn't be possible", new Object[0]);
                }
            }
            catch (InterruptedException e) {
                LOGGER.error("Could not execute pack download task", (Throwable)e);
            }
        }
        urlCache.save();
        DOWNLOADED_PACKS.clear();
        DOWNLOADED_PACKS.addAll(metas);
        if (RescloneConfig.pruneUnused) {
            this.pruneCache();
        }
    }

    private Runnable generateTask(PackMetaUnloaded meta, Set<PackMetaLoaded> metas) {
        return () -> {
            block15: {
                try {
                    if (!FETCHER_INSTANCES.containsKey(meta.fetcher())) {
                        throw new Exception("Invalid fetcher: " + meta.fetcher());
                    }
                    Path cacheDir = Resclone.getConfigPath().resolve("cache");
                    try {
                        boolean isNew = !urlCache.containsKey(meta.source());
                        PackFetcher.Result fr = FETCHER_INSTANCES.get(meta.fetcher()).get(meta.source(), cacheDir, meta.forceDownload());
                        PackMetaLoaded p = new PackMetaLoaded(fr.downloadPath(), meta.name(), meta.forceEnable());
                        metas.add(p);
                        if (isNew && FabricLoader.getInstance().getEnvironmentType() == EnvType.CLIENT) {
                            NEW_PACKS.add(p);
                        }
                        if (!fr.freshDownload()) break block15;
                        HashMap<String, String> props = new HashMap<String, String>();
                        props.put("create", "false");
                        URI zipfile = URI.create("jar:" + String.valueOf(p.zipPath().toUri()));
                        try (FileSystem zipfs = FileSystems.newFileSystem(zipfile, props);){
                            for (PackProcessor processor : PROCESSORS) {
                                processor.process(zipfs);
                            }
                        }
                        catch (Throwable e) {
                            LOGGER.error("Could not run pack processors on " + String.valueOf(p.zipPath()), e);
                        }
                    }
                    catch (Throwable e) {
                        throw new Exception("Failed to download pack", e);
                    }
                }
                catch (Throwable e) {
                    LOGGER.error("Encountered issue while preparing " + meta.name(), e);
                }
            }
        };
    }

    private void pruneCache() {
        Set loadedPacks = DOWNLOADED_PACKS.stream().map(PackMetaLoaded::zipPath).collect(Collectors.toUnmodifiableSet());
        HashSet toDelete = new HashSet();
        try (Stream<Path> cacheEntries = Files.list(Resclone.getConfigPath().resolve("cache"));){
            cacheEntries.filter(s -> !Files.isRegularFile(s, new LinkOption[0]) || !loadedPacks.contains(s)).forEach(toDelete::add);
        }
        catch (IOException e) {
            LOGGER.error("Could find cache entries to prune", (Throwable)e);
        }
        if (!toDelete.isEmpty()) {
            LOGGER.info("Pruning " + toDelete.size() + " unused cache entries", new Object[0]);
            for (Path path : toDelete) {
                try {
                    JFiles.deleteRecursive((Path)path);
                }
                catch (IOException e) {
                    LOGGER.error("Could not delete unused cache entry: " + String.valueOf(path), (Throwable)e);
                }
            }
        }
    }

    public static Path getConfigPath() {
        Path configPath = FabricLoader.getInstance().getConfigDir().resolve(MOD_ID);
        if (!Files.isDirectory(configPath.resolve("cache"), new LinkOption[0])) {
            try {
                Files.createDirectories(configPath.resolve("cache"), new FileAttribute[0]);
            }
            catch (IOException e) {
                LOGGER.error("Could not create cache directory", (Throwable)e);
            }
        }
        return configPath;
    }

    static {
        packCount = 0;
    }
}

