/*
 * Decompiled with CFR 0.152.
 */
package io.gitlab.jfronny.resclone;

import com.google.gson.reflect.TypeToken;
import io.gitlab.jfronny.commons.serialize.MalformedDataException;
import io.gitlab.jfronny.commons.serialize.Token;
import io.gitlab.jfronny.commons.serialize.json.JsonReader;
import io.gitlab.jfronny.commons.serialize.json.JsonWriter;
import io.gitlab.jfronny.libjf.LibJf;
import io.gitlab.jfronny.libjf.config.api.v2.JfCustomConfig;
import io.gitlab.jfronny.libjf.config.api.v2.dsl.ConfigBuilder;
import io.gitlab.jfronny.libjf.config.api.v2.dsl.DSL;
import io.gitlab.jfronny.resclone.Resclone;
import io.gitlab.jfronny.resclone.data.GC_PackMetaUnloaded;
import io.gitlab.jfronny.resclone.data.PackMetaUnloaded;
import io.gitlab.jfronny.resclone.util.ListAdaptation;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.Reader;
import java.io.Writer;
import java.lang.reflect.Type;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.HashSet;
import java.util.Set;

public class RescloneConfig
implements JfCustomConfig {
    public static Set<PackMetaUnloaded> packs;
    public static boolean pruneUnused;
    public static boolean filterPacks;
    public static boolean logProcessing;
    private static final String ERR_DUPLICATE = "Unexpected duplicate \"%s\" in Resclone config";
    private static final String PACKS = "packs";
    private static final String PRUNE_UNUSED = "pruneUnused";
    private static final String FILTER_PACKS = "filterPacks";
    private static final String LOG_PROCESSING = "logProcessing";

    private static void load(Path path) throws IOException {
        boolean updateRequired;
        block38: {
            if (!Files.exists(path, new LinkOption[0])) {
                packs = new HashSet<PackMetaUnloaded>();
                pruneUnused = true;
                filterPacks = true;
                logProcessing = false;
                RescloneConfig.write(path);
                return;
            }
            updateRequired = false;
            try (BufferedReader br = Files.newBufferedReader(path);
                 JsonReader reader = LibJf.LENIENT_TRANSPORT.createReader((Reader)br);){
                if (reader.peek() == Token.BEGIN_ARRAY) {
                    packs = ListAdaptation.deserializeSet(reader, GC_PackMetaUnloaded::deserialize);
                    updateRequired = true;
                    break block38;
                }
                if (reader.peek() == Token.BEGIN_OBJECT) {
                    reader.beginObject();
                    Set<Object> packs = null;
                    Boolean pruneUnused = null;
                    Boolean filterPacks = null;
                    Boolean logProcessing = null;
                    block22: while (reader.peek() != Token.END_OBJECT) {
                        String name;
                        switch (name = reader.nextName()) {
                            case "packs": {
                                if (packs != null) {
                                    throw new MalformedDataException(ERR_DUPLICATE.formatted(PACKS));
                                }
                                if (reader.peek() == Token.BEGIN_ARRAY) {
                                    packs = ListAdaptation.deserializeSet(reader, GC_PackMetaUnloaded::deserialize);
                                    continue block22;
                                }
                                packs = Set.of(GC_PackMetaUnloaded.deserialize(reader));
                                continue block22;
                            }
                            case "pruneUnused": {
                                if (pruneUnused != null) {
                                    throw new MalformedDataException(ERR_DUPLICATE.formatted(PRUNE_UNUSED));
                                }
                                pruneUnused = reader.nextBoolean();
                                continue block22;
                            }
                            case "filterPacks": {
                                if (filterPacks != null) {
                                    throw new MalformedDataException(ERR_DUPLICATE.formatted(FILTER_PACKS));
                                }
                                filterPacks = reader.nextBoolean();
                                continue block22;
                            }
                            case "logProcessing": {
                                if (logProcessing != null) {
                                    throw new MalformedDataException(ERR_DUPLICATE.formatted(LOG_PROCESSING));
                                }
                                logProcessing = reader.nextBoolean();
                                continue block22;
                            }
                        }
                        throw new MalformedDataException("Unexpected element: \"" + name + "\" in Resclone config");
                    }
                    reader.endObject();
                    if (packs == null) {
                        throw new MalformedDataException("Expected Resclone config object to contain packs");
                    }
                    if (pruneUnused == null) {
                        pruneUnused = true;
                        updateRequired = true;
                    }
                    if (filterPacks == null) {
                        filterPacks = true;
                        updateRequired = true;
                    }
                    if (logProcessing == null) {
                        logProcessing = false;
                        updateRequired = true;
                    }
                    RescloneConfig.packs = packs;
                    RescloneConfig.pruneUnused = pruneUnused;
                    RescloneConfig.filterPacks = filterPacks;
                    RescloneConfig.logProcessing = logProcessing;
                    break block38;
                }
                throw new MalformedDataException("Expected Resclone config to be an object or array");
            }
        }
        if (updateRequired) {
            RescloneConfig.write(path);
        }
    }

    private static void write(Path path) throws IOException {
        try (BufferedWriter bw = Files.newBufferedWriter(path, new OpenOption[0]);
             JsonWriter writer = LibJf.LENIENT_TRANSPORT.createWriter((Writer)bw);){
            writer.beginObject().comment("The packs to be loaded by resclone").name(PACKS).beginArray();
            for (PackMetaUnloaded pack : packs) {
                GC_PackMetaUnloaded.serialize(pack, writer);
            }
            ((JsonWriter)((JsonWriter)((JsonWriter)writer.endArray().comment("Automatically remove all downloaded packs that are not in the config to free up unneeded space").name(PRUNE_UNUSED).value(pruneUnused)).comment("Whether to filter packs to remove files unchanged from vanilla and empty directories").name(FILTER_PACKS).value(filterPacks)).comment("Log automatic processing steps applied to downloaded packs").name(LOG_PROCESSING).value(logProcessing)).endObject();
        }
    }

    public void register(DSL.Defaulted dsl) {
    }

    static {
        Path path = Resclone.getConfigPath().resolve("config.json");
        DSL.create((String)"resclone").register(builder -> (ConfigBuilder)((ConfigBuilder)((ConfigBuilder)((ConfigBuilder)builder.setLoadMethod(configInstance -> {
            try {
                RescloneConfig.load(path);
            }
            catch (IOException e) {
                Resclone.LOGGER.error("Could not load config", (Throwable)e);
            }
        }).setWriteMethod(configInstance -> {
            try {
                RescloneConfig.write(path);
            }
            catch (IOException e) {
                Resclone.LOGGER.error("Could not write config", (Throwable)e);
            }
        }).setPath(path).value(PACKS, new HashSet(), Double.NEGATIVE_INFINITY, Double.POSITIVE_INFINITY, io.gitlab.jfronny.libjf.config.api.v2.type.Type.ofClass((Type)new TypeToken<Set<PackMetaUnloaded>>(){}.getType()), 100, () -> packs, p -> {
            packs = p;
        })).value(PRUNE_UNUSED, pruneUnused, () -> pruneUnused, p -> {
            pruneUnused = p;
        })).value(FILTER_PACKS, filterPacks, () -> filterPacks, p -> {
            filterPacks = p;
        })).value(LOG_PROCESSING, logProcessing, () -> logProcessing, p -> {
            logProcessing = p;
        })).load();
    }
}

