/*
 * Decompiled with CFR 0.152.
 */
package io.gitlab.jfronny.resclone.data.modrinth;

import io.gitlab.jfronny.commons.serialize.ISO8601Utils;
import io.gitlab.jfronny.commons.serialize.MalformedDataException;
import io.gitlab.jfronny.commons.serialize.SerializeReader;
import io.gitlab.jfronny.commons.serialize.SerializeWriter;
import io.gitlab.jfronny.commons.serialize.Token;
import io.gitlab.jfronny.commons.serialize.Transport;
import io.gitlab.jfronny.commons.serialize.emulated.DataElement;
import io.gitlab.jfronny.commons.serialize.emulated.EmulatedReader;
import io.gitlab.jfronny.commons.serialize.emulated.EmulatedWriter;
import io.gitlab.jfronny.resclone.data.modrinth.Version;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.io.Writer;
import java.lang.runtime.SwitchBootstraps;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.StandardCopyOption;
import java.nio.file.StandardOpenOption;
import java.nio.file.attribute.FileAttribute;
import java.text.ParseException;
import java.text.ParsePosition;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Objects;

public class GC_Version {
    public static <TEx extends Exception, Writer extends SerializeWriter<TEx, ?>> void serialize(Version value, Writer writer) throws TEx, MalformedDataException {
        if (value == null) {
            writer.nullValue();
            return;
        }
        writer.beginObject();
        if (value.name != null || writer.isSerializeNulls()) {
            writer.name("name");
            if (value.name == null) {
                writer.nullValue();
            } else {
                writer.value(value.name);
            }
        }
        if (value.version_number != null || writer.isSerializeNulls()) {
            writer.name("version_number");
            if (value.version_number == null) {
                writer.nullValue();
            } else {
                writer.value(value.version_number);
            }
        }
        if (value.changelog != null || writer.isSerializeNulls()) {
            writer.name("changelog");
            if (value.changelog == null) {
                writer.nullValue();
            } else {
                writer.value(value.changelog);
            }
        }
        if (value.dependencies != null || writer.isSerializeNulls()) {
            writer.name("dependencies");
            if (value.dependencies == null) {
                writer.nullValue();
            } else {
                writer.beginArray();
                for (Version.Dependency _dependencies : value.dependencies) {
                    if (_dependencies == null) {
                        if (!writer.isSerializeNulls()) continue;
                        writer.nullValue();
                        continue;
                    }
                    Dependency.serialize(_dependencies, writer);
                }
                writer.endArray();
            }
        }
        if (value.game_versions != null || writer.isSerializeNulls()) {
            writer.name("game_versions");
            if (value.game_versions == null) {
                writer.nullValue();
            } else {
                writer.beginArray();
                for (String _game_versions : value.game_versions) {
                    if (_game_versions == null) {
                        if (!writer.isSerializeNulls()) continue;
                        writer.nullValue();
                        continue;
                    }
                    writer.value(_game_versions);
                }
                writer.endArray();
            }
        }
        if (value.version_type != null || writer.isSerializeNulls()) {
            writer.name("version_type");
            if (value.version_type == null) {
                writer.nullValue();
            } else {
                writer.value(value.version_type.name());
            }
        }
        if (value.loaders != null || writer.isSerializeNulls()) {
            writer.name("loaders");
            if (value.loaders == null) {
                writer.nullValue();
            } else {
                writer.beginArray();
                for (String _loaders : value.loaders) {
                    if (_loaders == null) {
                        if (!writer.isSerializeNulls()) continue;
                        writer.nullValue();
                        continue;
                    }
                    writer.value(_loaders);
                }
                writer.endArray();
            }
        }
        if (value.featured != null || writer.isSerializeNulls()) {
            writer.name("featured");
            if (value.featured == null) {
                writer.nullValue();
            } else {
                writer.value(value.featured);
            }
        }
        if (value.status != null || writer.isSerializeNulls()) {
            writer.name("status");
            if (value.status == null) {
                writer.nullValue();
            } else {
                writer.value(value.status.name());
            }
        }
        if (value.requested_status != null || writer.isSerializeNulls()) {
            writer.name("requested_status");
            if (value.requested_status == null) {
                writer.nullValue();
            } else {
                writer.value(value.requested_status.name());
            }
        }
        if (value.id != null || writer.isSerializeNulls()) {
            writer.name("id");
            if (value.id == null) {
                writer.nullValue();
            } else {
                writer.value(value.id);
            }
        }
        if (value.project_id != null || writer.isSerializeNulls()) {
            writer.name("project_id");
            if (value.project_id == null) {
                writer.nullValue();
            } else {
                writer.value(value.project_id);
            }
        }
        if (value.author_id != null || writer.isSerializeNulls()) {
            writer.name("author_id");
            if (value.author_id == null) {
                writer.nullValue();
            } else {
                writer.value(value.author_id);
            }
        }
        if (value.date_published != null || writer.isSerializeNulls()) {
            writer.name("date_published");
            if (value.date_published == null) {
                writer.nullValue();
            } else {
                writer.value(ISO8601Utils.format((Date)value.date_published));
            }
        }
        if (value.downloads != null || writer.isSerializeNulls()) {
            writer.name("downloads");
            if (value.downloads == null) {
                writer.nullValue();
            } else {
                writer.value((Number)value.downloads);
            }
        }
        if (value.files != null || writer.isSerializeNulls()) {
            writer.name("files");
            if (value.files == null) {
                writer.nullValue();
            } else {
                writer.beginArray();
                for (Version.File _files : value.files) {
                    if (_files == null) {
                        if (!writer.isSerializeNulls()) continue;
                        writer.nullValue();
                        continue;
                    }
                    File.serialize(_files, writer);
                }
                writer.endArray();
            }
        }
        writer.endObject();
    }

    private static <TEx extends Exception, Reader extends SerializeReader<TEx, ?>> List<Version.Dependency> read$dependencies(Reader reader) throws TEx, MalformedDataException {
        ArrayList<Version.Dependency> list = new ArrayList<Version.Dependency>();
        if (reader.isLenient() && reader.peek() != Token.BEGIN_ARRAY) {
            list.add(Dependency.deserialize(reader));
            return list;
        }
        reader.beginArray();
        while (reader.hasNext()) {
            if (reader.peek() == Token.NULL) {
                reader.nextNull();
                list.add(null);
                continue;
            }
            list.add(Dependency.deserialize(reader));
        }
        reader.endArray();
        return list;
    }

    private static <TEx extends Exception, Reader extends SerializeReader<TEx, ?>> List<String> read$game_versions(Reader reader) throws TEx, MalformedDataException {
        ArrayList<String> list = new ArrayList<String>();
        if (reader.isLenient() && reader.peek() != Token.BEGIN_ARRAY) {
            list.add(reader.nextString());
            return list;
        }
        reader.beginArray();
        while (reader.hasNext()) {
            if (reader.peek() == Token.NULL) {
                reader.nextNull();
                list.add(null);
                continue;
            }
            list.add(reader.nextString());
        }
        reader.endArray();
        return list;
    }

    private static <TEx extends Exception, Reader extends SerializeReader<TEx, ?>> Version.VersionType read$version_type(Reader reader) throws TEx, MalformedDataException {
        String value = reader.nextString();
        for (Version.VersionType t : Version.VersionType.values()) {
            if (!t.name().equals(value)) continue;
            return t;
        }
        return null;
    }

    private static <TEx extends Exception, Reader extends SerializeReader<TEx, ?>> List<String> read$loaders(Reader reader) throws TEx, MalformedDataException {
        ArrayList<String> list = new ArrayList<String>();
        if (reader.isLenient() && reader.peek() != Token.BEGIN_ARRAY) {
            list.add(reader.nextString());
            return list;
        }
        reader.beginArray();
        while (reader.hasNext()) {
            if (reader.peek() == Token.NULL) {
                reader.nextNull();
                list.add(null);
                continue;
            }
            list.add(reader.nextString());
        }
        reader.endArray();
        return list;
    }

    private static <TEx extends Exception, Reader extends SerializeReader<TEx, ?>> Version.Status read$status(Reader reader) throws TEx, MalformedDataException {
        String value = reader.nextString();
        for (Version.Status t : Version.Status.values()) {
            if (!t.name().equals(value)) continue;
            return t;
        }
        return null;
    }

    private static <TEx extends Exception, Reader extends SerializeReader<TEx, ?>> Version.Status read$requested_status(Reader reader) throws TEx, MalformedDataException {
        String value = reader.nextString();
        for (Version.Status t : Version.Status.values()) {
            if (!t.name().equals(value)) continue;
            return t;
        }
        return null;
    }

    private static <TEx extends Exception, Reader extends SerializeReader<TEx, ?>> Date deserializeDate(Reader reader) throws TEx, MalformedDataException {
        String date = reader.nextString();
        try {
            return ISO8601Utils.parse((String)date, (ParsePosition)new ParsePosition(0));
        }
        catch (ParseException e) {
            throw new MalformedDataException("Failed Parsing '" + date + "' as Date", (Throwable)e);
        }
    }

    private static <TEx extends Exception, Reader extends SerializeReader<TEx, ?>> List<Version.File> read$files(Reader reader) throws TEx, MalformedDataException {
        ArrayList<Version.File> list = new ArrayList<Version.File>();
        if (reader.isLenient() && reader.peek() != Token.BEGIN_ARRAY) {
            list.add(File.deserialize(reader));
            return list;
        }
        reader.beginArray();
        while (reader.hasNext()) {
            if (reader.peek() == Token.NULL) {
                reader.nextNull();
                list.add(null);
                continue;
            }
            list.add(File.deserialize(reader));
        }
        reader.endArray();
        return list;
    }

    public static <TEx extends Exception, Reader extends SerializeReader<TEx, ?>> Version deserialize(Reader reader) throws TEx, MalformedDataException {
        if (reader.peek() == Token.NULL) {
            reader.nextNull();
            return null;
        }
        String _name = null;
        boolean has_name = false;
        String _version_number = null;
        boolean has_version_number = false;
        String _changelog = null;
        boolean has_changelog = false;
        List<Version.Dependency> _dependencies = null;
        boolean has_dependencies = false;
        List<String> _game_versions = null;
        boolean has_game_versions = false;
        Version.VersionType _version_type = null;
        boolean has_version_type = false;
        List<String> _loaders = null;
        boolean has_loaders = false;
        Boolean _featured = null;
        boolean has_featured = false;
        Version.Status _status = null;
        boolean has_status = false;
        Version.Status _requested_status = null;
        boolean has_requested_status = false;
        String _id = null;
        boolean has_id = false;
        String _project_id = null;
        boolean has_project_id = false;
        String _author_id = null;
        boolean has_author_id = false;
        Date _date_published = null;
        boolean has_date_published = false;
        Integer _downloads = null;
        boolean has_downloads = false;
        List<Version.File> _files = null;
        boolean has_files = false;
        reader.beginObject();
        block18: while (reader.hasNext()) {
            String string;
            Objects.requireNonNull(reader.nextName());
            int n = 0;
            switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{"name", "version_number", "changelog", "dependencies", "game_versions", "version_type", "loaders", "featured", "status", "requested_status", "id", "project_id", "author_id", "date_published", "downloads", "files", String.class}, (Object)string, n)) {
                case 0: {
                    if (has_name && !reader.isLenient()) {
                        throw new MalformedDataException("Duplicate entry for: name");
                    }
                    if (reader.peek() == Token.NULL) {
                        reader.nextNull();
                        _name = null;
                    } else {
                        _name = reader.nextString();
                    }
                    has_name = true;
                    continue block18;
                }
                case 1: {
                    if (has_version_number && !reader.isLenient()) {
                        throw new MalformedDataException("Duplicate entry for: version_number");
                    }
                    if (reader.peek() == Token.NULL) {
                        reader.nextNull();
                        _version_number = null;
                    } else {
                        _version_number = reader.nextString();
                    }
                    has_version_number = true;
                    continue block18;
                }
                case 2: {
                    if (has_changelog && !reader.isLenient()) {
                        throw new MalformedDataException("Duplicate entry for: changelog");
                    }
                    if (reader.peek() == Token.NULL) {
                        reader.nextNull();
                        _changelog = null;
                    } else {
                        _changelog = reader.nextString();
                    }
                    has_changelog = true;
                    continue block18;
                }
                case 3: {
                    if (has_dependencies && !reader.isLenient()) {
                        throw new MalformedDataException("Duplicate entry for: dependencies");
                    }
                    if (reader.peek() == Token.NULL) {
                        reader.nextNull();
                        _dependencies = null;
                    } else {
                        _dependencies = GC_Version.read$dependencies(reader);
                    }
                    has_dependencies = true;
                    continue block18;
                }
                case 4: {
                    if (has_game_versions && !reader.isLenient()) {
                        throw new MalformedDataException("Duplicate entry for: game_versions");
                    }
                    if (reader.peek() == Token.NULL) {
                        reader.nextNull();
                        _game_versions = null;
                    } else {
                        _game_versions = GC_Version.read$game_versions(reader);
                    }
                    has_game_versions = true;
                    continue block18;
                }
                case 5: {
                    if (has_version_type && !reader.isLenient()) {
                        throw new MalformedDataException("Duplicate entry for: version_type");
                    }
                    if (reader.peek() == Token.NULL) {
                        reader.nextNull();
                        _version_type = null;
                    } else {
                        _version_type = GC_Version.read$version_type(reader);
                    }
                    has_version_type = true;
                    continue block18;
                }
                case 6: {
                    if (has_loaders && !reader.isLenient()) {
                        throw new MalformedDataException("Duplicate entry for: loaders");
                    }
                    if (reader.peek() == Token.NULL) {
                        reader.nextNull();
                        _loaders = null;
                    } else {
                        _loaders = GC_Version.read$loaders(reader);
                    }
                    has_loaders = true;
                    continue block18;
                }
                case 7: {
                    if (has_featured && !reader.isLenient()) {
                        throw new MalformedDataException("Duplicate entry for: featured");
                    }
                    if (reader.peek() == Token.NULL) {
                        reader.nextNull();
                        _featured = null;
                    } else {
                        _featured = reader.nextBoolean();
                    }
                    has_featured = true;
                    continue block18;
                }
                case 8: {
                    if (has_status && !reader.isLenient()) {
                        throw new MalformedDataException("Duplicate entry for: status");
                    }
                    if (reader.peek() == Token.NULL) {
                        reader.nextNull();
                        _status = null;
                    } else {
                        _status = GC_Version.read$status(reader);
                    }
                    has_status = true;
                    continue block18;
                }
                case 9: {
                    if (has_requested_status && !reader.isLenient()) {
                        throw new MalformedDataException("Duplicate entry for: requested_status");
                    }
                    if (reader.peek() == Token.NULL) {
                        reader.nextNull();
                        _requested_status = null;
                    } else {
                        _requested_status = GC_Version.read$requested_status(reader);
                    }
                    has_requested_status = true;
                    continue block18;
                }
                case 10: {
                    if (has_id && !reader.isLenient()) {
                        throw new MalformedDataException("Duplicate entry for: id");
                    }
                    if (reader.peek() == Token.NULL) {
                        reader.nextNull();
                        _id = null;
                    } else {
                        _id = reader.nextString();
                    }
                    has_id = true;
                    continue block18;
                }
                case 11: {
                    if (has_project_id && !reader.isLenient()) {
                        throw new MalformedDataException("Duplicate entry for: project_id");
                    }
                    if (reader.peek() == Token.NULL) {
                        reader.nextNull();
                        _project_id = null;
                    } else {
                        _project_id = reader.nextString();
                    }
                    has_project_id = true;
                    continue block18;
                }
                case 12: {
                    if (has_author_id && !reader.isLenient()) {
                        throw new MalformedDataException("Duplicate entry for: author_id");
                    }
                    if (reader.peek() == Token.NULL) {
                        reader.nextNull();
                        _author_id = null;
                    } else {
                        _author_id = reader.nextString();
                    }
                    has_author_id = true;
                    continue block18;
                }
                case 13: {
                    if (has_date_published && !reader.isLenient()) {
                        throw new MalformedDataException("Duplicate entry for: date_published");
                    }
                    if (reader.peek() == Token.NULL) {
                        reader.nextNull();
                        _date_published = null;
                    } else {
                        _date_published = GC_Version.deserializeDate(reader);
                    }
                    has_date_published = true;
                    continue block18;
                }
                case 14: {
                    if (has_downloads && !reader.isLenient()) {
                        throw new MalformedDataException("Duplicate entry for: downloads");
                    }
                    if (reader.peek() == Token.NULL) {
                        reader.nextNull();
                        _downloads = null;
                    } else {
                        _downloads = reader.nextInt();
                    }
                    has_downloads = true;
                    continue block18;
                }
                case 15: {
                    if (has_files && !reader.isLenient()) {
                        throw new MalformedDataException("Duplicate entry for: files");
                    }
                    if (reader.peek() == Token.NULL) {
                        reader.nextNull();
                        _files = null;
                    } else {
                        _files = GC_Version.read$files(reader);
                    }
                    has_files = true;
                    continue block18;
                }
            }
            String s = string;
            if (reader.isLenient()) {
                reader.skipValue();
                continue;
            }
            throw new MalformedDataException("Unexpected name: " + s);
        }
        reader.endObject();
        Version result = new Version();
        if (has_name) {
            result.name = _name;
        }
        if (has_version_number) {
            result.version_number = _version_number;
        }
        if (has_changelog) {
            result.changelog = _changelog;
        }
        if (has_dependencies) {
            result.dependencies = _dependencies;
        }
        if (has_game_versions) {
            result.game_versions = _game_versions;
        }
        if (has_version_type) {
            result.version_type = _version_type;
        }
        if (has_loaders) {
            result.loaders = _loaders;
        }
        if (has_featured) {
            result.featured = _featured;
        }
        if (has_status) {
            result.status = _status;
        }
        if (has_requested_status) {
            result.requested_status = _requested_status;
        }
        if (has_id) {
            result.id = _id;
        }
        if (has_project_id) {
            result.project_id = _project_id;
        }
        if (has_author_id) {
            result.author_id = _author_id;
        }
        if (has_date_published) {
            result.date_published = _date_published;
        }
        if (has_downloads) {
            result.downloads = _downloads;
        }
        if (has_files) {
            result.files = _files;
        }
        return result;
    }

    public static <TEx extends Exception, Reader extends SerializeReader<TEx, Reader>, Writer extends SerializeWriter<TEx, Writer>> Version deserialize(Reader in, Transport<TEx, Reader, Writer> transport) throws TEx, MalformedDataException {
        return (Version)transport.read(in, reader -> GC_Version.deserialize(reader));
    }

    public static <TEx extends Exception, Reader extends SerializeReader<TEx, Reader>, Writer extends SerializeWriter<TEx, Writer>> Version deserialize(String serialized, Transport<TEx, Reader, Writer> transport) throws TEx, MalformedDataException {
        try (StringReader reader = new StringReader(serialized);){
            Version version = GC_Version.deserialize(reader, transport);
            return version;
        }
    }

    public static Version deserialize(DataElement tree) throws MalformedDataException {
        try (EmulatedReader reader = new EmulatedReader(tree);){
            Version version = GC_Version.deserialize(reader);
            return version;
        }
    }

    public static <TEx extends Exception, Reader extends SerializeReader<TEx, Reader>, Writer extends SerializeWriter<TEx, Writer>> Version deserialize(Path path, Transport<TEx, Reader, Writer> transport) throws TEx, MalformedDataException, IOException {
        try (BufferedReader reader = Files.newBufferedReader(path);){
            Version version = GC_Version.deserialize(reader, transport);
            return version;
        }
    }

    public static <TEx extends Exception, Reader extends SerializeReader<TEx, Reader>, Writer extends SerializeWriter<TEx, Writer>> void serialize(Version value, Writer out, Transport<TEx, Reader, Writer> transport) throws TEx, MalformedDataException {
        transport.write(out, writer -> GC_Version.serialize(value, writer));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static <TEx extends Exception, Reader extends SerializeReader<TEx, Reader>, Writer extends SerializeWriter<TEx, Writer>> void serialize(Version value, Path path, Transport<TEx, Reader, Writer> transport) throws TEx, MalformedDataException, IOException {
        Path temp = Files.createTempFile("serializegenerator-", ".json", new FileAttribute[0]);
        try (BufferedWriter writer = Files.newBufferedWriter(temp, StandardOpenOption.CREATE, StandardOpenOption.WRITE, StandardOpenOption.TRUNCATE_EXISTING);){
            GC_Version.serialize(value, writer, transport);
            Files.move(temp, path, StandardCopyOption.REPLACE_EXISTING);
        }
        finally {
            Files.deleteIfExists(temp);
        }
    }

    public static <TEx extends Exception, Reader extends SerializeReader<TEx, Reader>, Writer extends SerializeWriter<TEx, Writer>> String serializeToString(Version value, Transport<TEx, Reader, Writer> transport) throws TEx, MalformedDataException, IOException {
        return transport.write(writer -> GC_Version.serialize(value, writer));
    }

    public static DataElement toDataTree(Version value) throws MalformedDataException {
        try (EmulatedWriter writer = new EmulatedWriter();){
            GC_Version.serialize(value, writer);
            DataElement dataElement = writer.get();
            return dataElement;
        }
    }

    public static class Dependency {
        public static <TEx extends Exception, Writer extends SerializeWriter<TEx, ?>> void serialize(Version.Dependency value, Writer writer) throws TEx, MalformedDataException {
            if (value == null) {
                writer.nullValue();
                return;
            }
            writer.beginObject();
            if (value.version_id != null || writer.isSerializeNulls()) {
                writer.name("version_id");
                if (value.version_id == null) {
                    writer.nullValue();
                } else {
                    writer.value(value.version_id);
                }
            }
            if (value.project_id != null || writer.isSerializeNulls()) {
                writer.name("project_id");
                if (value.project_id == null) {
                    writer.nullValue();
                } else {
                    writer.value(value.project_id);
                }
            }
            if (value.file_name != null || writer.isSerializeNulls()) {
                writer.name("file_name");
                if (value.file_name == null) {
                    writer.nullValue();
                } else {
                    writer.value(value.file_name);
                }
            }
            if (value.dependency_type != null || writer.isSerializeNulls()) {
                writer.name("dependency_type");
                if (value.dependency_type == null) {
                    writer.nullValue();
                } else {
                    writer.value(value.dependency_type.name());
                }
            }
            writer.endObject();
        }

        private static <TEx extends Exception, Reader extends SerializeReader<TEx, ?>> Version.Dependency.Type read$dependency_type(Reader reader) throws TEx, MalformedDataException {
            String value = reader.nextString();
            for (Version.Dependency.Type t : Version.Dependency.Type.values()) {
                if (!t.name().equals(value)) continue;
                return t;
            }
            return null;
        }

        public static <TEx extends Exception, Reader extends SerializeReader<TEx, ?>> Version.Dependency deserialize(Reader reader) throws TEx, MalformedDataException {
            if (reader.peek() == Token.NULL) {
                reader.nextNull();
                return null;
            }
            String _version_id = null;
            boolean has_version_id = false;
            String _project_id = null;
            boolean has_project_id = false;
            String _file_name = null;
            boolean has_file_name = false;
            Version.Dependency.Type _dependency_type = null;
            boolean has_dependency_type = false;
            reader.beginObject();
            block6: while (reader.hasNext()) {
                String string;
                Objects.requireNonNull(reader.nextName());
                int n = 0;
                switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{"version_id", "project_id", "file_name", "dependency_type", String.class}, (Object)string, n)) {
                    case 0: {
                        if (has_version_id && !reader.isLenient()) {
                            throw new MalformedDataException("Duplicate entry for: version_id");
                        }
                        if (reader.peek() == Token.NULL) {
                            reader.nextNull();
                            _version_id = null;
                        } else {
                            _version_id = reader.nextString();
                        }
                        has_version_id = true;
                        continue block6;
                    }
                    case 1: {
                        if (has_project_id && !reader.isLenient()) {
                            throw new MalformedDataException("Duplicate entry for: project_id");
                        }
                        if (reader.peek() == Token.NULL) {
                            reader.nextNull();
                            _project_id = null;
                        } else {
                            _project_id = reader.nextString();
                        }
                        has_project_id = true;
                        continue block6;
                    }
                    case 2: {
                        if (has_file_name && !reader.isLenient()) {
                            throw new MalformedDataException("Duplicate entry for: file_name");
                        }
                        if (reader.peek() == Token.NULL) {
                            reader.nextNull();
                            _file_name = null;
                        } else {
                            _file_name = reader.nextString();
                        }
                        has_file_name = true;
                        continue block6;
                    }
                    case 3: {
                        if (has_dependency_type && !reader.isLenient()) {
                            throw new MalformedDataException("Duplicate entry for: dependency_type");
                        }
                        if (reader.peek() == Token.NULL) {
                            reader.nextNull();
                            _dependency_type = null;
                        } else {
                            _dependency_type = Dependency.read$dependency_type(reader);
                        }
                        has_dependency_type = true;
                        continue block6;
                    }
                }
                String s = string;
                if (reader.isLenient()) {
                    reader.skipValue();
                    continue;
                }
                throw new MalformedDataException("Unexpected name: " + s);
            }
            reader.endObject();
            Version.Dependency result = new Version.Dependency();
            if (has_version_id) {
                result.version_id = _version_id;
            }
            if (has_project_id) {
                result.project_id = _project_id;
            }
            if (has_file_name) {
                result.file_name = _file_name;
            }
            if (has_dependency_type) {
                result.dependency_type = _dependency_type;
            }
            return result;
        }

        public static <TEx extends Exception, Reader extends SerializeReader<TEx, Reader>, Writer extends SerializeWriter<TEx, Writer>> Version.Dependency deserialize(Reader in, Transport<TEx, Reader, Writer> transport) throws TEx, MalformedDataException {
            return (Version.Dependency)transport.read(in, reader -> Dependency.deserialize(reader));
        }

        public static <TEx extends Exception, Reader extends SerializeReader<TEx, Reader>, Writer extends SerializeWriter<TEx, Writer>> Version.Dependency deserialize(String serialized, Transport<TEx, Reader, Writer> transport) throws TEx, MalformedDataException {
            try (StringReader reader = new StringReader(serialized);){
                Version.Dependency dependency = Dependency.deserialize(reader, transport);
                return dependency;
            }
        }

        public static Version.Dependency deserialize(DataElement tree) throws MalformedDataException {
            try (EmulatedReader reader = new EmulatedReader(tree);){
                Version.Dependency dependency = Dependency.deserialize(reader);
                return dependency;
            }
        }

        public static <TEx extends Exception, Reader extends SerializeReader<TEx, Reader>, Writer extends SerializeWriter<TEx, Writer>> Version.Dependency deserialize(Path path, Transport<TEx, Reader, Writer> transport) throws TEx, MalformedDataException, IOException {
            try (BufferedReader reader = Files.newBufferedReader(path);){
                Version.Dependency dependency = Dependency.deserialize(reader, transport);
                return dependency;
            }
        }

        public static <TEx extends Exception, Reader extends SerializeReader<TEx, Reader>, Writer extends SerializeWriter<TEx, Writer>> void serialize(Version.Dependency value, Writer out, Transport<TEx, Reader, Writer> transport) throws TEx, MalformedDataException {
            transport.write(out, writer -> Dependency.serialize(value, writer));
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public static <TEx extends Exception, Reader extends SerializeReader<TEx, Reader>, Writer extends SerializeWriter<TEx, Writer>> void serialize(Version.Dependency value, Path path, Transport<TEx, Reader, Writer> transport) throws TEx, MalformedDataException, IOException {
            Path temp = Files.createTempFile("serializegenerator-", ".json", new FileAttribute[0]);
            try (BufferedWriter writer = Files.newBufferedWriter(temp, StandardOpenOption.CREATE, StandardOpenOption.WRITE, StandardOpenOption.TRUNCATE_EXISTING);){
                Dependency.serialize(value, writer, transport);
                Files.move(temp, path, StandardCopyOption.REPLACE_EXISTING);
            }
            finally {
                Files.deleteIfExists(temp);
            }
        }

        public static <TEx extends Exception, Reader extends SerializeReader<TEx, Reader>, Writer extends SerializeWriter<TEx, Writer>> String serializeToString(Version.Dependency value, Transport<TEx, Reader, Writer> transport) throws TEx, MalformedDataException, IOException {
            return transport.write(writer -> Dependency.serialize(value, writer));
        }

        public static DataElement toDataTree(Version.Dependency value) throws MalformedDataException {
            try (EmulatedWriter writer = new EmulatedWriter();){
                Dependency.serialize(value, writer);
                DataElement dataElement = writer.get();
                return dataElement;
            }
        }
    }

    public static class File {
        public static <TEx extends Exception, Writer extends SerializeWriter<TEx, ?>> void serialize(Version.File value, Writer writer) throws TEx, MalformedDataException {
            if (value == null) {
                writer.nullValue();
                return;
            }
            writer.beginObject();
            if (value.hashes != null || writer.isSerializeNulls()) {
                writer.name("hashes");
                if (value.hashes == null) {
                    writer.nullValue();
                } else {
                    Hashes.serialize(value.hashes, writer);
                }
            }
            if (value.url != null || writer.isSerializeNulls()) {
                writer.name("url");
                if (value.url == null) {
                    writer.nullValue();
                } else {
                    writer.value(value.url);
                }
            }
            if (value.filename != null || writer.isSerializeNulls()) {
                writer.name("filename");
                if (value.filename == null) {
                    writer.nullValue();
                } else {
                    writer.value(value.filename);
                }
            }
            if (value.primary != null || writer.isSerializeNulls()) {
                writer.name("primary");
                if (value.primary == null) {
                    writer.nullValue();
                } else {
                    writer.value(value.primary);
                }
            }
            if (value.size != null || writer.isSerializeNulls()) {
                writer.name("size");
                if (value.size == null) {
                    writer.nullValue();
                } else {
                    writer.value((Number)value.size);
                }
            }
            if (value.file_type != null || writer.isSerializeNulls()) {
                writer.name("file_type");
                if (value.file_type == null) {
                    writer.nullValue();
                } else {
                    writer.value(value.file_type.name());
                }
            }
            writer.endObject();
        }

        private static <TEx extends Exception, Reader extends SerializeReader<TEx, ?>> Version.File.Type read$file_type(Reader reader) throws TEx, MalformedDataException {
            String value = reader.nextString();
            for (Version.File.Type t : Version.File.Type.values()) {
                if (!t.name().equals(value)) continue;
                return t;
            }
            return null;
        }

        public static <TEx extends Exception, Reader extends SerializeReader<TEx, ?>> Version.File deserialize(Reader reader) throws TEx, MalformedDataException {
            if (reader.peek() == Token.NULL) {
                reader.nextNull();
                return null;
            }
            Version.File.Hashes _hashes = null;
            boolean has_hashes = false;
            String _url = null;
            boolean has_url = false;
            String _filename = null;
            boolean has_filename = false;
            Boolean _primary = null;
            boolean has_primary = false;
            Integer _size = null;
            boolean has_size = false;
            Version.File.Type _file_type = null;
            boolean has_file_type = false;
            reader.beginObject();
            block8: while (reader.hasNext()) {
                String string;
                Objects.requireNonNull(reader.nextName());
                int n = 0;
                switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{"hashes", "url", "filename", "primary", "size", "file_type", String.class}, (Object)string, n)) {
                    case 0: {
                        if (has_hashes && !reader.isLenient()) {
                            throw new MalformedDataException("Duplicate entry for: hashes");
                        }
                        if (reader.peek() == Token.NULL) {
                            reader.nextNull();
                            _hashes = null;
                        } else {
                            _hashes = Hashes.deserialize(reader);
                        }
                        has_hashes = true;
                        continue block8;
                    }
                    case 1: {
                        if (has_url && !reader.isLenient()) {
                            throw new MalformedDataException("Duplicate entry for: url");
                        }
                        if (reader.peek() == Token.NULL) {
                            reader.nextNull();
                            _url = null;
                        } else {
                            _url = reader.nextString();
                        }
                        has_url = true;
                        continue block8;
                    }
                    case 2: {
                        if (has_filename && !reader.isLenient()) {
                            throw new MalformedDataException("Duplicate entry for: filename");
                        }
                        if (reader.peek() == Token.NULL) {
                            reader.nextNull();
                            _filename = null;
                        } else {
                            _filename = reader.nextString();
                        }
                        has_filename = true;
                        continue block8;
                    }
                    case 3: {
                        if (has_primary && !reader.isLenient()) {
                            throw new MalformedDataException("Duplicate entry for: primary");
                        }
                        if (reader.peek() == Token.NULL) {
                            reader.nextNull();
                            _primary = null;
                        } else {
                            _primary = reader.nextBoolean();
                        }
                        has_primary = true;
                        continue block8;
                    }
                    case 4: {
                        if (has_size && !reader.isLenient()) {
                            throw new MalformedDataException("Duplicate entry for: size");
                        }
                        if (reader.peek() == Token.NULL) {
                            reader.nextNull();
                            _size = null;
                        } else {
                            _size = reader.nextInt();
                        }
                        has_size = true;
                        continue block8;
                    }
                    case 5: {
                        if (has_file_type && !reader.isLenient()) {
                            throw new MalformedDataException("Duplicate entry for: file_type");
                        }
                        if (reader.peek() == Token.NULL) {
                            reader.nextNull();
                            _file_type = null;
                        } else {
                            _file_type = File.read$file_type(reader);
                        }
                        has_file_type = true;
                        continue block8;
                    }
                }
                String s = string;
                if (reader.isLenient()) {
                    reader.skipValue();
                    continue;
                }
                throw new MalformedDataException("Unexpected name: " + s);
            }
            reader.endObject();
            Version.File result = new Version.File();
            if (has_hashes) {
                result.hashes = _hashes;
            }
            if (has_url) {
                result.url = _url;
            }
            if (has_filename) {
                result.filename = _filename;
            }
            if (has_primary) {
                result.primary = _primary;
            }
            if (has_size) {
                result.size = _size;
            }
            if (has_file_type) {
                result.file_type = _file_type;
            }
            return result;
        }

        public static <TEx extends Exception, Reader extends SerializeReader<TEx, Reader>, Writer extends SerializeWriter<TEx, Writer>> Version.File deserialize(Reader in, Transport<TEx, Reader, Writer> transport) throws TEx, MalformedDataException {
            return (Version.File)transport.read(in, reader -> File.deserialize(reader));
        }

        public static <TEx extends Exception, Reader extends SerializeReader<TEx, Reader>, Writer extends SerializeWriter<TEx, Writer>> Version.File deserialize(String serialized, Transport<TEx, Reader, Writer> transport) throws TEx, MalformedDataException {
            try (StringReader reader = new StringReader(serialized);){
                Version.File file = File.deserialize(reader, transport);
                return file;
            }
        }

        public static Version.File deserialize(DataElement tree) throws MalformedDataException {
            try (EmulatedReader reader = new EmulatedReader(tree);){
                Version.File file = File.deserialize(reader);
                return file;
            }
        }

        public static <TEx extends Exception, Reader extends SerializeReader<TEx, Reader>, Writer extends SerializeWriter<TEx, Writer>> Version.File deserialize(Path path, Transport<TEx, Reader, Writer> transport) throws TEx, MalformedDataException, IOException {
            try (BufferedReader reader = Files.newBufferedReader(path);){
                Version.File file = File.deserialize(reader, transport);
                return file;
            }
        }

        public static <TEx extends Exception, Reader extends SerializeReader<TEx, Reader>, Writer extends SerializeWriter<TEx, Writer>> void serialize(Version.File value, Writer out, Transport<TEx, Reader, Writer> transport) throws TEx, MalformedDataException {
            transport.write(out, writer -> File.serialize(value, writer));
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public static <TEx extends Exception, Reader extends SerializeReader<TEx, Reader>, Writer extends SerializeWriter<TEx, Writer>> void serialize(Version.File value, Path path, Transport<TEx, Reader, Writer> transport) throws TEx, MalformedDataException, IOException {
            Path temp = Files.createTempFile("serializegenerator-", ".json", new FileAttribute[0]);
            try (BufferedWriter writer = Files.newBufferedWriter(temp, StandardOpenOption.CREATE, StandardOpenOption.WRITE, StandardOpenOption.TRUNCATE_EXISTING);){
                File.serialize(value, writer, transport);
                Files.move(temp, path, StandardCopyOption.REPLACE_EXISTING);
            }
            finally {
                Files.deleteIfExists(temp);
            }
        }

        public static <TEx extends Exception, Reader extends SerializeReader<TEx, Reader>, Writer extends SerializeWriter<TEx, Writer>> String serializeToString(Version.File value, Transport<TEx, Reader, Writer> transport) throws TEx, MalformedDataException, IOException {
            return transport.write(writer -> File.serialize(value, writer));
        }

        public static DataElement toDataTree(Version.File value) throws MalformedDataException {
            try (EmulatedWriter writer = new EmulatedWriter();){
                File.serialize(value, writer);
                DataElement dataElement = writer.get();
                return dataElement;
            }
        }

        public static class Hashes {
            public static <TEx extends Exception, Writer extends SerializeWriter<TEx, ?>> void serialize(Version.File.Hashes value, Writer writer) throws TEx, MalformedDataException {
                if (value == null) {
                    writer.nullValue();
                    return;
                }
                writer.beginObject();
                if (value.sha512 != null || writer.isSerializeNulls()) {
                    writer.name("sha512");
                    if (value.sha512 == null) {
                        writer.nullValue();
                    } else {
                        writer.value(value.sha512);
                    }
                }
                if (value.sha1 != null || writer.isSerializeNulls()) {
                    writer.name("sha1");
                    if (value.sha1 == null) {
                        writer.nullValue();
                    } else {
                        writer.value(value.sha1);
                    }
                }
                writer.endObject();
            }

            public static <TEx extends Exception, Reader extends SerializeReader<TEx, ?>> Version.File.Hashes deserialize(Reader reader) throws TEx, MalformedDataException {
                if (reader.peek() == Token.NULL) {
                    reader.nextNull();
                    return null;
                }
                String _sha512 = null;
                boolean has_sha512 = false;
                String _sha1 = null;
                boolean has_sha1 = false;
                reader.beginObject();
                block4: while (reader.hasNext()) {
                    String string;
                    Objects.requireNonNull(reader.nextName());
                    int n = 0;
                    switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{"sha512", "sha1", String.class}, (Object)string, n)) {
                        case 0: {
                            if (has_sha512 && !reader.isLenient()) {
                                throw new MalformedDataException("Duplicate entry for: sha512");
                            }
                            if (reader.peek() == Token.NULL) {
                                reader.nextNull();
                                _sha512 = null;
                            } else {
                                _sha512 = reader.nextString();
                            }
                            has_sha512 = true;
                            continue block4;
                        }
                        case 1: {
                            if (has_sha1 && !reader.isLenient()) {
                                throw new MalformedDataException("Duplicate entry for: sha1");
                            }
                            if (reader.peek() == Token.NULL) {
                                reader.nextNull();
                                _sha1 = null;
                            } else {
                                _sha1 = reader.nextString();
                            }
                            has_sha1 = true;
                            continue block4;
                        }
                    }
                    String s = string;
                    if (reader.isLenient()) {
                        reader.skipValue();
                        continue;
                    }
                    throw new MalformedDataException("Unexpected name: " + s);
                }
                reader.endObject();
                Version.File.Hashes result = new Version.File.Hashes();
                if (has_sha512) {
                    result.sha512 = _sha512;
                }
                if (has_sha1) {
                    result.sha1 = _sha1;
                }
                return result;
            }

            public static <TEx extends Exception, Reader extends SerializeReader<TEx, Reader>, Writer extends SerializeWriter<TEx, Writer>> Version.File.Hashes deserialize(Reader in, Transport<TEx, Reader, Writer> transport) throws TEx, MalformedDataException {
                return (Version.File.Hashes)transport.read(in, reader -> Hashes.deserialize(reader));
            }

            public static <TEx extends Exception, Reader extends SerializeReader<TEx, Reader>, Writer extends SerializeWriter<TEx, Writer>> Version.File.Hashes deserialize(String serialized, Transport<TEx, Reader, Writer> transport) throws TEx, MalformedDataException {
                try (StringReader reader = new StringReader(serialized);){
                    Version.File.Hashes hashes = Hashes.deserialize(reader, transport);
                    return hashes;
                }
            }

            public static Version.File.Hashes deserialize(DataElement tree) throws MalformedDataException {
                try (EmulatedReader reader = new EmulatedReader(tree);){
                    Version.File.Hashes hashes = Hashes.deserialize(reader);
                    return hashes;
                }
            }

            public static <TEx extends Exception, Reader extends SerializeReader<TEx, Reader>, Writer extends SerializeWriter<TEx, Writer>> Version.File.Hashes deserialize(Path path, Transport<TEx, Reader, Writer> transport) throws TEx, MalformedDataException, IOException {
                try (BufferedReader reader = Files.newBufferedReader(path);){
                    Version.File.Hashes hashes = Hashes.deserialize(reader, transport);
                    return hashes;
                }
            }

            public static <TEx extends Exception, Reader extends SerializeReader<TEx, Reader>, Writer extends SerializeWriter<TEx, Writer>> void serialize(Version.File.Hashes value, Writer out, Transport<TEx, Reader, Writer> transport) throws TEx, MalformedDataException {
                transport.write(out, writer -> Hashes.serialize(value, writer));
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public static <TEx extends Exception, Reader extends SerializeReader<TEx, Reader>, Writer extends SerializeWriter<TEx, Writer>> void serialize(Version.File.Hashes value, Path path, Transport<TEx, Reader, Writer> transport) throws TEx, MalformedDataException, IOException {
                Path temp = Files.createTempFile("serializegenerator-", ".json", new FileAttribute[0]);
                try (BufferedWriter writer = Files.newBufferedWriter(temp, StandardOpenOption.CREATE, StandardOpenOption.WRITE, StandardOpenOption.TRUNCATE_EXISTING);){
                    Hashes.serialize(value, writer, transport);
                    Files.move(temp, path, StandardCopyOption.REPLACE_EXISTING);
                }
                finally {
                    Files.deleteIfExists(temp);
                }
            }

            public static <TEx extends Exception, Reader extends SerializeReader<TEx, Reader>, Writer extends SerializeWriter<TEx, Writer>> String serializeToString(Version.File.Hashes value, Transport<TEx, Reader, Writer> transport) throws TEx, MalformedDataException, IOException {
                return transport.write(writer -> Hashes.serialize(value, writer));
            }

            public static DataElement toDataTree(Version.File.Hashes value) throws MalformedDataException {
                try (EmulatedWriter writer = new EmulatedWriter();){
                    Hashes.serialize(value, writer);
                    DataElement dataElement = writer.get();
                    return dataElement;
                }
            }
        }
    }
}

