/*
 * Decompiled with CFR 0.152.
 */
package io.gitlab.jfronny.resclone.fetchers;

import io.gitlab.jfronny.commons.http.client.HttpClient;
import io.gitlab.jfronny.resclone.Resclone;
import io.gitlab.jfronny.resclone.fetchers.PackFetcher;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;

public abstract class BasePackFetcher
implements PackFetcher {
    abstract String getDownloadUrl(String var1) throws Exception;

    @Override
    public PackFetcher.Result get(String baseUrl, Path targetDir, boolean forceDownload) throws Exception {
        String url;
        try {
            url = this.getDownloadUrl(baseUrl);
            Resclone.urlCache.set(baseUrl, url);
        }
        catch (Exception e) {
            if (Resclone.urlCache.containsKey(baseUrl)) {
                Resclone.LOGGER.error("Could not get download URL for " + baseUrl + ", using cached", (Throwable)e);
                url = Resclone.urlCache.get(baseUrl);
            }
            throw e;
        }
        Path p = targetDir.resolve(Integer.toHexString(url.hashCode()));
        if (!forceDownload && Files.exists(p, new LinkOption[0])) {
            ++Resclone.packCount;
            return new PackFetcher.Result(p, false);
        }
        Resclone.LOGGER.info("Downloading pack: " + url, new Object[0]);
        try (InputStream is = HttpClient.get((String)url).userAgent(Resclone.USER_AGENT).sendInputStream();
             OutputStream os = Files.newOutputStream(p, new OpenOption[0]);){
            int bytesRead;
            byte[] dataBuffer = new byte[1024];
            while ((bytesRead = is.read(dataBuffer, 0, 1024)) != -1) {
                os.write(dataBuffer, 0, bytesRead);
            }
            Resclone.LOGGER.info("Finished downloading.", new Object[0]);
        }
        catch (Throwable e) {
            throw new IOException("Could not download pack", e);
        }
        ++Resclone.packCount;
        return new PackFetcher.Result(p, true);
    }
}

