/*
 * Decompiled with CFR 0.152.
 */
package io.gitlab.jfronny.resclone.fetchers;

import io.gitlab.jfronny.commons.http.client.HttpClient;
import io.gitlab.jfronny.commons.serialize.json.JsonReader;
import io.gitlab.jfronny.libjf.LibJf;
import io.gitlab.jfronny.resclone.Resclone;
import io.gitlab.jfronny.resclone.data.github.GC_Release;
import io.gitlab.jfronny.resclone.data.github.GC_Repository;
import io.gitlab.jfronny.resclone.data.github.Release;
import io.gitlab.jfronny.resclone.fetchers.BasePackFetcher;
import java.io.IOException;
import java.io.Reader;
import java.net.URISyntaxException;
import org.jetbrains.annotations.Nullable;

public class GitHubFetcher
extends BasePackFetcher {
    @Override
    public String getSourceTypeName() {
        return "github";
    }

    /*
     * Enabled aggressive exception aggregation
     */
    @Override
    String getDownloadUrl(String baseUrl) throws Exception {
        String[] parts = baseUrl.split("/");
        if (parts.length < 2) {
            throw new Exception("Minimum source must contain \"user/repo\".");
        }
        if (parts.length == 2) {
            return this.getFromBranch(baseUrl, null);
        }
        if (parts[2].equalsIgnoreCase("branch")) {
            if (parts.length < 4) {
                throw new Exception("Missing branch name in source definition.");
            }
            Resclone.LOGGER.info("Getting from " + parts[3] + " branch.", new Object[0]);
            return this.getFromBranch(parts[0] + "/" + parts[1], parts[3]);
        }
        if (parts[2].equalsIgnoreCase("release")) {
            try (Reader r = HttpClient.get((String)("https://api.github.com/repos/" + parts[0] + "/" + parts[1] + "/releases/latest")).sendReader();){
                Object object;
                block26: {
                    String res;
                    JsonReader jr;
                    block24: {
                        block25: {
                            jr = LibJf.LENIENT_TRANSPORT.createReader(r);
                            try {
                                Release latestRelease = GC_Release.deserialize(jr);
                                res = null;
                                for (Release.Asset asset : latestRelease.assets) {
                                    if (!"application/x-zip-compressed".equals(asset.content_type) && !asset.name.endsWith(".zip")) continue;
                                    res = asset.browser_download_url;
                                    break;
                                }
                                Resclone.LOGGER.info("Getting from latest release.", new Object[0]);
                                if (res != null) break block24;
                                object = latestRelease.zipball_url;
                                if (jr == null) break block25;
                            }
                            catch (Throwable throwable) {
                                if (jr != null) {
                                    try {
                                        jr.close();
                                    }
                                    catch (Throwable throwable2) {
                                        throwable.addSuppressed(throwable2);
                                    }
                                }
                                throw throwable;
                            }
                            jr.close();
                        }
                        return object;
                    }
                    object = res;
                    if (jr == null) break block26;
                    jr.close();
                }
                return object;
            }
            catch (Throwable e) {
                throw new Exception("Failed to get github release asset", e);
            }
        }
        if (parts[2].equalsIgnoreCase("tag")) {
            if (parts.length < 4) {
                throw new Exception("Missing tag number in source definition.");
            }
            return this.getFromTag(parts[0] + "/" + parts[1], parts[3]);
        }
        return null;
    }

    private String getFromBranch(String repo, @Nullable String branch) {
        if (branch == null) {
            try (Reader r = HttpClient.get((String)("https://api.github.com/repos/" + repo)).sendReader();
                 JsonReader jr = LibJf.LENIENT_TRANSPORT.createReader(r);){
                branch = GC_Repository.deserialize(jr).default_branch;
            }
            catch (IOException | URISyntaxException e) {
                Resclone.LOGGER.error("Failed to fetch branch for " + repo + ". Choosing \"main\"", (Throwable)e);
                branch = "main";
            }
        }
        Resclone.LOGGER.info("Getting " + repo + " from " + branch + " branch.", new Object[0]);
        return "https://codeload.github.com/" + repo + "/legacy.zip/refs/heads/" + branch;
    }

    private String getFromTag(String repo, String tag) {
        Resclone.LOGGER.info("Getting from tag " + tag + ".", new Object[0]);
        return "https://codeload.github.com/" + repo + "/legacy.zip/refs/tags/" + tag;
    }
}

