/*
 * Decompiled with CFR 0.152.
 */
package io.gitlab.jfronny.resclone.fetchers;

import io.gitlab.jfronny.commons.http.client.HttpClient;
import io.gitlab.jfronny.commons.serialize.json.JsonReader;
import io.gitlab.jfronny.libjf.LibJf;
import io.gitlab.jfronny.resclone.Resclone;
import io.gitlab.jfronny.resclone.data.modrinth.GC_Version;
import io.gitlab.jfronny.resclone.data.modrinth.Version;
import io.gitlab.jfronny.resclone.fetchers.BasePackFetcher;
import io.gitlab.jfronny.resclone.util.ListAdaptation;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.Reader;
import java.util.Date;
import java.util.List;
import net.minecraft.class_155;

public class ModrinthFetcher
extends BasePackFetcher {
    @Override
    public String getSourceTypeName() {
        return "modrinth";
    }

    @Override
    public String getDownloadUrl(String baseUrl) throws Exception {
        try {
            List<Version> versions;
            String version = class_155.method_16673().comp_4025();
            Version latest = null;
            Date latestDate = null;
            boolean foundMatchingVersion = false;
            try (Reader r = HttpClient.get((String)("https://api.modrinth.com/v2/project/" + baseUrl + "/version")).userAgent(Resclone.USER_AGENT).sendReader();
                 JsonReader jr = LibJf.LENIENT_TRANSPORT.createReader(r);){
                versions = ListAdaptation.deserializeList(jr, GC_Version::deserialize);
            }
            for (Version ver : versions) {
                if (foundMatchingVersion && !ver.game_versions.contains(version) || ver.files.isEmpty()) continue;
                if (!foundMatchingVersion && ver.game_versions.contains(version)) {
                    foundMatchingVersion = true;
                    latest = null;
                }
                if (latest != null && !ver.date_published.after(latestDate)) continue;
                latest = ver;
                latestDate = ver.date_published;
            }
            if (latest == null) {
                throw new FileNotFoundException("Could not identify valid version");
            }
            if (!foundMatchingVersion) {
                Resclone.LOGGER.error("Could not find matching version of " + baseUrl + ", using latest", new Object[0]);
            }
            for (Version.File file : latest.files) {
                if (!file.primary.booleanValue()) continue;
                return file.url;
            }
            Resclone.LOGGER.error("Could not identify primary file of " + baseUrl + ", attempting identification by file_type", new Object[0]);
            for (Version.File file : latest.files) {
                if (file.file_type != Version.File.Type.REQUIRED_RESOURCE_PACK) continue;
                return file.url;
            }
            Resclone.LOGGER.error("Identification failed, using first file of " + baseUrl, new Object[0]);
            return latest.files.getFirst().url;
        }
        catch (Throwable e) {
            throw new IOException("Could not get Modrinth download for " + baseUrl, e);
        }
    }
}

