/*
 * Decompiled with CFR 0.152.
 */
package io.gitlab.jfronny.resclone.processors;

import io.gitlab.jfronny.resclone.Resclone;
import io.gitlab.jfronny.resclone.RescloneConfig;
import io.gitlab.jfronny.resclone.processors.PackProcessor;
import io.gitlab.jfronny.resclone.util.io.PathPruneVisitor;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.FileSystem;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.StandardOpenOption;
import java.util.stream.Stream;
import net.fabricmc.api.EnvType;
import net.fabricmc.loader.api.FabricLoader;
import net.minecraft.class_3268;
import net.minecraft.class_3286;
import net.minecraft.class_4239;
import net.minecraft.class_7367;
import org.apache.commons.io.IOUtils;

public class PruneVanillaProcessor
implements PackProcessor {
    public static class_3268 referencePack = null;
    private static class_3268 vanillaDataPackProvider = null;

    @Override
    public void process(FileSystem p) throws Exception {
        try {
            if (referencePack == null && FabricLoader.getInstance().getEnvironmentType() == EnvType.CLIENT) {
                throw new Exception("Reference pack not set");
            }
            if (vanillaDataPackProvider == null) {
                vanillaDataPackProvider = class_3286.method_45287();
            }
            if (Files.isDirectory(p.getPath("/assets/minecraft", new String[0]), new LinkOption[0])) {
                Files.walkFileTree(p.getPath("/assets/minecraft", new String[0]), new PathPruneVisitor(s -> {
                    if (Files.isDirectory(s, new LinkOption[0])) {
                        return false;
                    }
                    try {
                        class_7367 vn;
                        String[] parts = p.getPath("/", new String[0]).relativize((Path)s).toString().split("/");
                        if (!Stream.of(parts).allMatch(class_4239::method_46347)) {
                            return false;
                        }
                        class_7367 class_73672 = vn = referencePack == null ? null : referencePack.method_14410(parts);
                        if (vn == null) {
                            vn = vanillaDataPackProvider.method_14410(parts);
                        }
                        if (vn == null) return false;
                        try (InputStream vns = (InputStream)vn.get();
                             InputStream pk = Files.newInputStream(s, StandardOpenOption.READ);){
                            if (!IOUtils.contentEquals((InputStream)vns, (InputStream)pk)) return false;
                            if (RescloneConfig.logProcessing) {
                                Resclone.LOGGER.info("Pruning file unchanged from vanilla: {0}", new Object[]{s});
                            }
                            boolean bl = true;
                            return bl;
                        }
                    }
                    catch (Throwable e) {
                        Resclone.LOGGER.error("Could not prune unchanged assets", e);
                    }
                    return false;
                }));
            }
        }
        catch (IOException e) {
            throw new Exception("Could not prune vanilla files", e);
        }
    }
}

