/*
 * Decompiled with CFR 0.152.
 */
package io.gitlab.jfronny.resclone.processors;

import io.gitlab.jfronny.resclone.Resclone;
import io.gitlab.jfronny.resclone.RescloneConfig;
import io.gitlab.jfronny.resclone.processors.PackProcessor;
import io.gitlab.jfronny.resclone.util.io.PathPruneVisitor;
import java.io.IOException;
import java.nio.file.DirectoryStream;
import java.nio.file.FileSystem;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;

public class RemoveEmptyProcessor
implements PackProcessor {
    @Override
    public void process(FileSystem p) throws Exception {
        if (Files.exists(p.getPath("/assets", new String[0]), new LinkOption[0])) {
            try {
                Files.walkFileTree(p.getPath("/assets", new String[0]), new PathPruneVisitor(s -> {
                    if (!Files.isDirectory(s, new LinkOption[0])) return false;
                    try (DirectoryStream<Path> paths = Files.newDirectoryStream(s);){
                        if (paths.iterator().hasNext()) return false;
                        if (RescloneConfig.logProcessing) {
                            Resclone.LOGGER.info("Pruning empty directory: {0}", new Object[]{s});
                        }
                        boolean bl = true;
                        return bl;
                    }
                    catch (IOException e) {
                        Resclone.LOGGER.error("Could not check whether directory has entries", (Throwable)e);
                    }
                    return false;
                }));
            }
            catch (Throwable e) {
                throw new Exception("Failed to prune empty directories", e);
            }
        }
    }
}

