/*
 * Decompiled with CFR 0.152.
 */
package io.gitlab.jfronny.resclone.processors;

import io.gitlab.jfronny.resclone.Resclone;
import io.gitlab.jfronny.resclone.RescloneConfig;
import io.gitlab.jfronny.resclone.processors.PackProcessor;
import io.gitlab.jfronny.resclone.util.io.MoveDirVisitor;
import java.io.IOException;
import java.nio.file.DirectoryStream;
import java.nio.file.FileSystem;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.StandardCopyOption;

public class RootPathProcessor
implements PackProcessor {
    @Override
    public void process(FileSystem p) throws Exception {
        if (!Files.exists(p.getPath("/pack.mcmeta", new String[0]), new LinkOption[0])) {
            try {
                Path root = p.getPath("/", new String[0]);
                try (DirectoryStream<Path> paths = Files.newDirectoryStream(root);){
                    for (Path path : paths) {
                        if (!Files.isDirectory(path, new LinkOption[0]) || !Files.exists(path.resolve("pack.mcmeta"), new LinkOption[0])) continue;
                        if (RescloneConfig.logProcessing) {
                            Resclone.LOGGER.info("Moving discovered root out of: {0}", new Object[]{path});
                        }
                        Files.walkFileTree(path, new MoveDirVisitor(path, root, StandardCopyOption.REPLACE_EXISTING));
                    }
                }
            }
            catch (IOException e) {
                throw new Exception("Could not fix root path", e);
            }
        }
    }
}

