/*
 * Decompiled with CFR 0.152.
 */
package io.gitlab.jfronny.resclone.util;

import io.gitlab.jfronny.resclone.Resclone;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.Properties;

public class PackUrlCache {
    private final Path file;
    Properties properties = new Properties();

    public PackUrlCache(Path file) {
        this.file = file;
        if (Files.exists(file, new LinkOption[0])) {
            try (BufferedReader r = Files.newBufferedReader(file);){
                this.properties.load(r);
            }
            catch (IOException e) {
                Resclone.LOGGER.error("Could not load pack URL cache", new Object[0]);
            }
        }
    }

    public void save() {
        try (BufferedWriter w = Files.newBufferedWriter(this.file, new OpenOption[0]);){
            this.properties.store(w, "This is an internal file used for offline pack loading, do not edit");
        }
        catch (IOException e) {
            Resclone.LOGGER.error("Could not write pack URL cache", new Object[0]);
        }
    }

    public boolean containsKey(String key) {
        return this.properties.containsKey(key);
    }

    public String get(String key) {
        return this.properties.getProperty(key);
    }

    public void set(String key, String value) {
        this.properties.setProperty(key, value);
    }
}

