/*
 * Decompiled with CFR 0.152.
 */
package net.adeptstack.Core.UI.Screens;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import java.util.function.Consumer;
import java.util.function.Function;
import net.adeptstack.Core.UI.Controls.BlockButton;
import net.adeptstack.Core.Utils.ScreenUtils.ToolTipUtils;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.CommonComponents;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.block.state.properties.IntegerProperty;

public class PlatformBlockScreenBase
extends Screen {
    public static final int NO_VARIANT_SELECTED = -1;
    private static final ResourceLocation texture = new ResourceLocation("trainutilities", "textures/gui/selection_screen.png");
    private static final int TEXTURE_WIDTH = 256;
    private static final int TEXTURE_HEIGHT = 256;
    private static final int WINDOW_WIDTH = 218;
    private static final int WINDOW_HEIGHT = 66;
    private static final int WINDOW_TOP_PART_HEIGHT = 21;
    private static final int WINDOW_BUTTON_AREA_Y = 21;
    private static final int WINDOW_BOTTOM_PART_Y = 41;
    private static final int WINDOW_BOTTOM_PART_HEIGHT = 45;
    private static final int MARGIN_LEFT = 8;
    private static final int MARGIN_RIGHT = 8;
    private static final int PREVIEW_ICON_SIZE = 32;
    private static final int DEFAULT_BUTTON_WIDTH = 70;
    private static final int MAX_BUTTONS_PER_ROW = 10;
    private final int maxValues;
    private final int maxRows;
    private final int startValue;
    private final Function<Integer, TextureResult> textureGetter;
    private final Consumer<Integer> onDone;
    private int guiLeft;
    private int guiTop;
    private TextureResult preview;
    private int selectedVariant = -1;
    private int typeID = 0;

    public <T extends IntegerProperty> PlatformBlockScreenBase(int variant, T property, Function<Integer, TextureResult> textureGetter, Consumer<Integer> onDone, String id, int typeId) {
        super((Component)new TranslatableComponent(id));
        this.maxValues = property.m_6908_().size();
        this.startValue = property.m_61702_().mapToInt(x -> (Integer)x.f_61713_()).min().orElse(0);
        this.maxRows = (int)Math.ceil((double)this.maxValues / 10.0);
        this.textureGetter = textureGetter;
        this.onDone = onDone;
        this.selectedVariant = variant;
        this.typeID = typeId;
        if (variant != -1) {
            this.preview = textureGetter.apply(variant);
        }
    }

    protected void onDone() {
        this.onDone.accept(this.selectedVariant);
    }

    public void m_7379_() {
        super.m_7379_();
    }

    public int getSelectedVariantId() {
        return this.selectedVariant;
    }

    protected void m_7856_() {
        super.m_7856_();
        this.guiLeft = this.f_96543_ / 2 - 109;
        this.guiTop = this.f_96544_ / 2 - (66 + this.maxRows * 20) / 2;
        int i = 0;
        int count = 0;
        while (count < this.maxValues) {
            for (int k = 0; k < 10 && count < this.maxValues; ++k, ++count) {
                int n = count;
                TextureResult result = this.textureGetter.apply(this.startValue + n);
                String msg = this.typeID == 1 ? ToolTipUtils.GetDEPlatformBlockToolTipName(n) : (this.typeID == 2 ? ToolTipUtils.GetNLPlatformBlockToolTipName(n) : (this.typeID == 3 ? ToolTipUtils.GetCHPlatformBlockToolTipName(n) : ""));
                this.m_142416_((GuiEventListener)new BlockButton(this.guiLeft + 8 + 1 + k * 20, this.guiTop + 21 + i * 20, b -> {
                    this.selectedVariant = this.startValue + n;
                    this.preview = result;
                }, result.location(), result.textureWidth(), result.textureHeight(), (button, poseStack, mouseX, mouseY) -> this.m_96602_(poseStack, (Component)new TranslatableComponent(msg), mouseX, mouseY)));
            }
            ++i;
        }
        this.m_142416_((GuiEventListener)new Button(this.guiLeft + 218 - 8 - 70, this.guiTop + 21 + this.maxRows * 20 + 45 - 28, 70, 20, CommonComponents.f_130656_, btn -> this.m_7379_()));
        this.m_142416_((GuiEventListener)new Button(this.guiLeft + 218 - 8 - 140 - 4, this.guiTop + 21 + this.maxRows * 20 + 45 - 28, 70, 20, CommonComponents.f_130655_, btn -> {
            this.onDone();
            this.m_7379_();
        }));
    }

    public void m_6305_(PoseStack poseStack, int mouseX, int mouseY, float partialTick) {
        this.m_7333_(poseStack);
        RenderSystem.m_157456_((int)0, (ResourceLocation)texture);
        PlatformBlockScreenBase.m_93160_((PoseStack)poseStack, (int)this.guiLeft, (int)this.guiTop, (int)218, (int)21, (float)0.0f, (float)0.0f, (int)218, (int)21, (int)256, (int)256);
        for (int i = 0; i < this.maxRows; ++i) {
            PlatformBlockScreenBase.m_93160_((PoseStack)poseStack, (int)this.guiLeft, (int)(this.guiTop + 21 + i * 20), (int)218, (int)20, (float)0.0f, (float)21.0f, (int)218, (int)20, (int)256, (int)256);
        }
        PlatformBlockScreenBase.m_93160_((PoseStack)poseStack, (int)this.guiLeft, (int)(this.guiTop + 21 + this.maxRows * 20), (int)218, (int)45, (float)0.0f, (float)41.0f, (int)218, (int)45, (int)256, (int)256);
        if (this.preview != null) {
            RenderSystem.m_157456_((int)0, (ResourceLocation)this.preview.location());
            PlatformBlockScreenBase.m_93160_((PoseStack)poseStack, (int)(this.guiLeft + 8), (int)(this.guiTop + 21 + this.maxRows * 20 + 4), (int)32, (int)32, (float)0.0f, (float)0.0f, (int)this.preview.textureWidth(), (int)this.preview.textureHeight(), (int)this.preview.textureWidth(), (int)this.preview.textureHeight());
        }
        super.m_6305_(poseStack, mouseX, mouseY, partialTick);
        this.f_96547_.m_92889_(poseStack, this.f_96539_, (float)(this.f_96543_ / 2 - this.f_96547_.m_92852_((FormattedText)this.f_96539_) / 2), (float)(this.guiTop + 6), -12566464);
    }

    public record TextureResult(ResourceLocation location, int textureWidth, int textureHeight) {
    }
}

