/*
 * Decompiled with CFR 0.152.
 */
package net.adeptstack.registry;

import com.simibubi.create.AllBlocks;
import com.simibubi.create.AllInteractionBehaviours;
import com.simibubi.create.AllMovementBehaviours;
import com.simibubi.create.AllTags;
import com.simibubi.create.content.contraptions.behaviour.MovementBehaviour;
import com.simibubi.create.content.contraptions.behaviour.MovingInteractionBehaviour;
import com.simibubi.create.content.decoration.palettes.GlassPaneBlock;
import com.simibubi.create.foundation.data.TagGen;
import com.tterrag.registrate.builders.BlockBuilder;
import com.tterrag.registrate.util.entry.BlockEntry;
import com.tterrag.registrate.util.nullness.NonNullSupplier;
import com.tterrag.registrate.util.nullness.NonNullUnaryOperator;
import net.adeptstack.Blocks.Behaviour.DoorBlock.DoorBlockMovementBehaviour;
import net.adeptstack.Blocks.Behaviour.DoorBlock.DoorBlockMovingInteraction;
import net.adeptstack.Blocks.Behaviour.SlidingDoor.TrainSlidingDoorMovementBehaviour;
import net.adeptstack.Blocks.Behaviour.SlidingDoor.TrainSlidingDoorMovingInteraction;
import net.adeptstack.Blocks.Doors.SlidingDoor.TrainSlidingDoorBlock;
import net.adeptstack.Blocks.LineBlock;
import net.adeptstack.Blocks.PanelBlocks.IsoWallBlock;
import net.adeptstack.Blocks.PanelBlocks.PlatformBlocks.PlatformBlockCH;
import net.adeptstack.Blocks.PanelBlocks.PlatformBlocks.PlatformBlockDE;
import net.adeptstack.Blocks.PanelBlocks.PlatformBlocks.PlatformBlockNL;
import net.adeptstack.Core.Utils.TrainSlidingDoorProperties;
import net.adeptstack.Main;
import net.adeptstack.registry.ModSounds;
import net.adeptstack.registry.ModTabs;
import net.adeptstack.registry.ModTags;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.tags.BlockTags;
import net.minecraft.tags.ItemTags;
import net.minecraft.tags.TagKey;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.DoorBlock;
import net.minecraft.world.level.block.GlassBlock;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.material.MaterialColor;

public class TrainUtilitiesBuilderTransformers {
    public static BlockEntry<PlatformBlockDE> DEPlatformBlock(String id, MaterialColor color) {
        return ((BlockBuilder)((BlockBuilder)Main.REGISTRATE.block(id, PlatformBlockDE::new).initialProperties(() -> Blocks.f_50183_).properties(p -> p.m_155949_(color).m_60918_(SoundType.f_56743_)).transform(TagGen.pickaxeOnly())).tag(new TagKey[]{ModTags.AllBlockTags.PLATFORM_BLOCKS.tag}).item().tag(new TagKey[]{ModTags.AllItemTags.PLATFORM_BLOCKS.tag}).tab(() -> ModTabs.TRAINUTILS_TAB).build()).register();
    }

    public static BlockEntry<PlatformBlockNL> NLPlatformBlock(String id, MaterialColor color) {
        return ((BlockBuilder)((BlockBuilder)Main.REGISTRATE.block(id, PlatformBlockNL::new).initialProperties(() -> Blocks.f_50183_).properties(p -> p.m_155949_(color).m_60918_(SoundType.f_56743_)).transform(TagGen.pickaxeOnly())).tag(new TagKey[]{ModTags.AllBlockTags.PLATFORM_BLOCKS.tag}).item().tag(new TagKey[]{ModTags.AllItemTags.PLATFORM_BLOCKS.tag}).tab(() -> ModTabs.TRAINUTILS_TAB).build()).register();
    }

    public static BlockEntry<PlatformBlockCH> CHPlatformBlock(String id, MaterialColor color) {
        return ((BlockBuilder)((BlockBuilder)Main.REGISTRATE.block(id, PlatformBlockCH::new).initialProperties(() -> Blocks.f_50183_).properties(p -> p.m_155949_(color).m_60918_(SoundType.f_56743_)).transform(TagGen.pickaxeOnly())).tag(new TagKey[]{ModTags.AllBlockTags.PLATFORM_BLOCKS.tag}).item().tag(new TagKey[]{ModTags.AllItemTags.PLATFORM_BLOCKS.tag}).tab(() -> ModTabs.TRAINUTILS_TAB).build()).register();
    }

    public static BlockEntry<GlassBlock> GlassBlock(String id, MaterialColor color) {
        return ((BlockBuilder)((BlockBuilder)Main.REGISTRATE.block(id, GlassBlock::new).initialProperties(() -> Blocks.f_50058_).properties(p -> p.m_60918_(SoundType.f_56744_).m_155949_(color)).addLayer(() -> RenderType::m_110466_).transform(TagGen.pickaxeOnly())).tag(new TagKey[]{ModTags.AllBlockTags.FRAMEABLE.tag}).item().tab(() -> ModTabs.TRAINUTILS_TAB).build()).register();
    }

    public static BlockEntry<GlassPaneBlock> GlassPaneBlock(String id, MaterialColor color) {
        return ((BlockBuilder)((BlockBuilder)Main.REGISTRATE.block(id, GlassPaneBlock::new).initialProperties(() -> Blocks.f_50185_).properties(p -> p.m_60918_(SoundType.f_56744_).m_155949_(color)).addLayer(() -> RenderType::m_110466_).transform(TagGen.pickaxeOnly())).tag(new TagKey[]{ModTags.AllBlockTags.FRAMEABLE.tag}).item().tab(() -> ModTabs.TRAINUTILS_TAB).build()).register();
    }

    public static BlockEntry<Block> DefaultBlock(String id, MaterialColor color) {
        return ((BlockBuilder)((BlockBuilder)Main.REGISTRATE.block(id, Block::new).initialProperties(() -> Blocks.f_50058_).properties(p -> p.m_60918_(SoundType.f_56742_).m_155949_(color)).transform(TagGen.pickaxeOnly())).tag(new TagKey[]{ModTags.AllBlockTags.FRAMEABLE.tag}).item().tab(() -> ModTabs.TRAINUTILS_TAB).build()).register();
    }

    public static BlockEntry<IsoWallBlock> IsoWallBlock(String id, MaterialColor color) {
        return ((BlockBuilder)((BlockBuilder)Main.REGISTRATE.block(id, IsoWallBlock::new).initialProperties(() -> Blocks.f_50183_).properties(p -> p.m_155949_(MaterialColor.f_76401_).m_60918_(SoundType.f_56743_)).transform(TagGen.pickaxeOnly())).item().tab(() -> ModTabs.TRAINUTILS_TAB).build()).register();
    }

    public static BlockEntry<LineBlock> LineBlock(String id, MaterialColor color) {
        return ((BlockBuilder)((BlockBuilder)Main.REGISTRATE.block(id, LineBlock::new).initialProperties(() -> Blocks.f_50542_).properties(p -> p.m_155949_(color)).transform(TagGen.pickaxeOnly())).tag(new TagKey[]{ModTags.AllBlockTags.FRAMEABLE.tag}).tag(new TagKey[]{ModTags.AllBlockTags.LINE_BLOCKS.tag}).item().tag(new TagKey[]{ModTags.AllItemTags.LINE_BLOCKS.tag}).tab(() -> ModTabs.TRAINUTILS_TAB).build()).register();
    }

    public static <B extends DoorBlock, P> NonNullUnaryOperator<BlockBuilder<B, P>> defaultDoor(String type) {
        return b -> (BlockBuilder)((BlockBuilder)((BlockBuilder)((BlockBuilder)b.initialProperties(() -> Blocks.f_50154_).properties(p -> p.m_60913_(3.0f, 6.0f)).addLayer(() -> RenderType::m_110463_).transform(TagGen.pickaxeOnly())).onRegister(AllInteractionBehaviours.interactionBehaviour((MovingInteractionBehaviour)new DoorBlockMovingInteraction()))).onRegister(AllMovementBehaviours.movementBehaviour((MovementBehaviour)new DoorBlockMovementBehaviour()))).tag(new TagKey[]{BlockTags.f_13103_}).tag(new TagKey[]{ModTags.AllBlockTags.DOORS.tag}).tag(new TagKey[]{AllTags.AllBlockTags.NON_DOUBLE_DOOR.tag}).item().tag(new TagKey[]{ItemTags.f_13179_}).tag(new TagKey[]{ModTags.AllItemTags.DOORS.tag}).tag(new TagKey[]{AllTags.AllItemTags.CONTRAPTION_CONTROLLED.tag}).tab(() -> ModTabs.DOORS_TAB).build();
    }

    public static BlockEntry<DoorBlock> DefaultMinecraftDoor(String type, MaterialColor colour) {
        return ((BlockBuilder)Main.REGISTRATE.block("door_" + type, DoorBlock::new).initialProperties((NonNullSupplier)AllBlocks.FRAMED_GLASS_DOOR).properties(p -> p.m_60918_(SoundType.f_56743_).m_155949_(colour)).transform(TrainUtilitiesBuilderTransformers.defaultDoor(type))).properties(BlockBehaviour.Properties::m_60955_).register();
    }

    public static <B extends TrainSlidingDoorBlock, P> NonNullUnaryOperator<BlockBuilder<B, P>> slidingDoor(String type) {
        return b -> (BlockBuilder)((BlockBuilder)((BlockBuilder)((BlockBuilder)b.initialProperties(() -> Blocks.f_50154_).properties(p -> p.m_60913_(3.0f, 6.0f)).transform(TagGen.pickaxeOnly())).onRegister(AllInteractionBehaviours.interactionBehaviour((MovingInteractionBehaviour)new TrainSlidingDoorMovingInteraction()))).onRegister(AllMovementBehaviours.movementBehaviour((MovementBehaviour)new TrainSlidingDoorMovementBehaviour(type)))).tag(new TagKey[]{BlockTags.f_13103_}).tag(new TagKey[]{ModTags.AllBlockTags.DOORS.tag}).tag(new TagKey[]{AllTags.AllBlockTags.NON_DOUBLE_DOOR.tag}).item().tag(new TagKey[]{ItemTags.f_13179_}).tag(new TagKey[]{ModTags.AllItemTags.DOORS.tag}).tag(new TagKey[]{AllTags.AllItemTags.CONTRAPTION_CONTROLLED.tag}).tab(() -> ModTabs.DOORS_TAB).build();
    }

    public static BlockEntry<TrainSlidingDoorBlock> TrainSlidingDoor(String type, boolean folds, MaterialColor colour) {
        return ((BlockBuilder)Main.REGISTRATE.block("door_" + type, p -> new TrainSlidingDoorBlock((BlockBehaviour.Properties)p, folds, TrainUtilitiesBuilderTransformers.GetSlidingDoorDefaultSound(type))).initialProperties((NonNullSupplier)AllBlocks.FRAMED_GLASS_DOOR).properties(p -> p.m_60918_(SoundType.f_56743_).m_155949_(colour)).addLayer(() -> RenderType::m_110463_).transform(TrainUtilitiesBuilderTransformers.slidingDoor(type))).properties(BlockBehaviour.Properties::m_60955_).register();
    }

    public static BlockEntry<TrainSlidingDoorBlock> TintedTrainSlidingDoor(String type, boolean folds, MaterialColor colour) {
        return ((BlockBuilder)Main.REGISTRATE.block("door_" + type, p -> new TrainSlidingDoorBlock((BlockBehaviour.Properties)p, folds, TrainUtilitiesBuilderTransformers.GetSlidingDoorDefaultSound(type))).initialProperties((NonNullSupplier)AllBlocks.FRAMED_GLASS_DOOR).properties(p -> p.m_60918_(SoundType.f_56743_).m_155949_(colour)).addLayer(() -> RenderType::m_110466_).transform(TrainUtilitiesBuilderTransformers.slidingDoor(type))).properties(BlockBehaviour.Properties::m_60955_).register();
    }

    public static TrainSlidingDoorProperties GetSlidingDoorProperties(int variant) {
        if (variant == 1) {
            return new TrainSlidingDoorProperties((SoundEvent)ModSounds.DOOR_ICE_OPEN.get(), (SoundEvent)ModSounds.DOOR_ICE_CLOSE.get(), 0.025f);
        }
        if (variant == 2) {
            return new TrainSlidingDoorProperties((SoundEvent)ModSounds.DOOR_IC2_OPEN.get(), (SoundEvent)ModSounds.DOOR_IC2_CLOSE.get(), 0.025f);
        }
        if (variant == 3) {
            return new TrainSlidingDoorProperties((SoundEvent)ModSounds.DOOR_RRX_OPEN.get(), (SoundEvent)ModSounds.DOOR_RRX_CLOSE.get(), 0.025f);
        }
        if (variant == 4) {
            return new TrainSlidingDoorProperties((SoundEvent)ModSounds.DOOR_FLIRT_OPEN.get(), (SoundEvent)ModSounds.DOOR_FLIRT_CLOSE.get(), 0.025f);
        }
        if (variant == 5) {
            return new TrainSlidingDoorProperties((SoundEvent)ModSounds.DOOR_SW_NYC_OPEN.get(), (SoundEvent)ModSounds.DOOR_SW_NYC_CLOSE.get(), 0.035f);
        }
        if (variant == 6) {
            return new TrainSlidingDoorProperties((SoundEvent)ModSounds.DOOR_PKP_IC_OPEN.get(), (SoundEvent)ModSounds.DOOR_PKP_IC_CLOSE.get(), 0.025f);
        }
        if (variant == 7) {
            return new TrainSlidingDoorProperties((SoundEvent)ModSounds.DOOR_IC_OPEN.get(), (SoundEvent)ModSounds.DOOR_IC_CLOSE.get(), 0.025f);
        }
        if (variant == 8) {
            return new TrainSlidingDoorProperties((SoundEvent)ModSounds.DOOR_ELEV_OPEN.get(), (SoundEvent)ModSounds.DOOR_ELEV_CLOSE.get(), 0.025f);
        }
        if (variant == 9) {
            return new TrainSlidingDoorProperties((SoundEvent)ModSounds.DOOR_LONDON_1973_STOCK_OPEN.get(), (SoundEvent)ModSounds.DOOR_LONDON_1973_STOCK_CLOSE.get(), 0.025f);
        }
        if (variant == 10) {
            return new TrainSlidingDoorProperties((SoundEvent)ModSounds.DOOR_LONDON_S7_STOCK_OPEN.get(), (SoundEvent)ModSounds.DOOR_LONDON_S7_STOCK_CLOSE.get(), 0.025f);
        }
        if (variant == 11) {
            return new TrainSlidingDoorProperties((SoundEvent)ModSounds.DOOR_LONDON_OVERGROUND_OPEN.get(), (SoundEvent)ModSounds.DOOR_LONDON_OVERGROUND_CLOSE.get(), 0.025f);
        }
        if (variant == 12) {
            return new TrainSlidingDoorProperties((SoundEvent)ModSounds.DOOR_RAILJET_OPEN.get(), (SoundEvent)ModSounds.DOOR_RAILJET_CLOSE.get(), 0.025f);
        }
        if (variant == 13) {
            return new TrainSlidingDoorProperties((SoundEvent)ModSounds.DOOR_SBAHN_OPEN.get(), (SoundEvent)ModSounds.DOOR_SBAHN_CLOSE.get(), 0.025f);
        }
        if (variant == 14) {
            return new TrainSlidingDoorProperties((SoundEvent)ModSounds.DOOR_TALENT_OPEN.get(), (SoundEvent)ModSounds.DOOR_TALENT_CLOSE.get(), 0.025f);
        }
        if (variant == 15) {
            return new TrainSlidingDoorProperties((SoundEvent)ModSounds.DOOR_CAF_URBOS_3_OPEN.get(), (SoundEvent)ModSounds.DOOR_CAF_URBOS_3_CLOSE.get(), 0.025f);
        }
        return new TrainSlidingDoorProperties(SoundEvents.f_12056_, SoundEvents.f_12055_, 0.15f);
    }

    public static int GetSlidingDoorDefaultSound(String type) {
        if (type == "ice" || type == "ice_top" || type == "ice_modern_top" || type == "ice_modern") {
            return 1;
        }
        if (type == "ic2") {
            return 2;
        }
        if (type == "rrx" || type == "goahead_desiro") {
            return 3;
        }
        if (type == "flirt" || type == "flirt_vias" || type == "ungarian_flirt") {
            return 4;
        }
        if (type == "sw_nyc" || type == "warsaw_tram") {
            return 5;
        }
        if (type == "pkp_ic_white" || type == "pkp_ic_blue") {
            return 6;
        }
        if (type == "ic") {
            return 7;
        }
        if (type == "elev_glass" || type == "elev_metal") {
            return 8;
        }
        if (type == "london_1973_stock") {
            return 9;
        }
        if (type == "london_s7_stock") {
            return 10;
        }
        if (type == "london_overground" || type == "london_el") {
            return 11;
        }
        if (type == "railjet") {
            return 12;
        }
        if (type == "sbahn_cologne" || type == "sbahn_vrr") {
            return 13;
        }
        if (type == "talent1" || type == "talent2" || type == "talent3") {
            return 14;
        }
        if (type == "caf_urbos_3") {
            return 15;
        }
        return 0;
    }
}

