/*
 * Decompiled with CFR 0.152.
 */
package tn.nightbeam.robotica.client.renderer;

import com.mojang.math.Vector3f;
import net.minecraft.client.animation.AnimationDefinition;
import net.minecraft.client.animation.KeyframeAnimations;
import net.minecraft.client.model.EntityModel;
import net.minecraft.client.model.HierarchicalModel;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.entity.MobRenderer;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import tn.nightbeam.robotica.client.model.Modelsentinel;
import tn.nightbeam.robotica.client.model.animations.sentinelAnimation;
import tn.nightbeam.robotica.entity.SentinelEntity;

public class SentinelRenderer
extends MobRenderer<SentinelEntity, Modelsentinel<SentinelEntity>> {
    public SentinelRenderer(EntityRendererProvider.Context context) {
        super(context, (EntityModel)new AnimatedModel(context.m_174023_(Modelsentinel.LAYER_LOCATION)), 0.5f);
    }

    public ResourceLocation getTextureLocation(SentinelEntity entity) {
        return new ResourceLocation("robotica:textures/entities/robot_1.png");
    }

    private static final class AnimatedModel
    extends Modelsentinel<SentinelEntity> {
        private final ModelPart root;
        private final HierarchicalModel animator = new HierarchicalModel<SentinelEntity>(){
            private static final Vector3f ANIMATION_VECTOR_CACHE = new Vector3f();

            public ModelPart m_142109_() {
                return root;
            }

            private void animateWalk(AnimationDefinition animationDefinition, float limbSwing, float limbSwingAmount, float ageInTicks, float netHeadYaw) {
                long accumulatedTime = (long)(limbSwing * 50.0f * ageInTicks);
                float scale = Math.min(limbSwingAmount * netHeadYaw, 1.0f);
                KeyframeAnimations.m_232319_((HierarchicalModel)this, (AnimationDefinition)animationDefinition, (long)accumulatedTime, (float)scale, (Vector3f)ANIMATION_VECTOR_CACHE);
            }

            public void setupAnim(SentinelEntity entity, float limbSwing, float limbSwingAmount, float ageInTicks, float netHeadYaw, float headPitch) {
                this.m_142109_().m_171331_().forEach(ModelPart::m_233569_);
                this.m_233385_(entity.animationState0, sentinelAnimation.idle, ageInTicks, 1.0f);
                this.animateWalk(sentinelAnimation.walk, limbSwing, limbSwingAmount, 1.0f, 1.0f);
                this.m_233385_(entity.animationState2, sentinelAnimation.attack, ageInTicks, 1.0f);
            }
        };

        public AnimatedModel(ModelPart root) {
            super(root);
            this.root = root;
        }

        public void setupAnim(SentinelEntity entity, float limbSwing, float limbSwingAmount, float ageInTicks, float netHeadYaw, float headPitch) {
            this.animator.m_6973_((Entity)entity, limbSwing, limbSwingAmount, ageInTicks, netHeadYaw, headPitch);
            super.m_6973_(entity, limbSwing, limbSwingAmount, ageInTicks, netHeadYaw, headPitch);
        }
    }
}

