/*
 * Decompiled with CFR 0.152.
 */
package tn.nightbeam.robotica.init;

import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.MobCategory;
import net.minecraftforge.event.entity.EntityAttributeCreationEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.registries.DeferredRegister;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistry;
import net.minecraftforge.registries.RegistryObject;
import tn.nightbeam.robotica.entity.BoggieEntity;
import tn.nightbeam.robotica.entity.MechEntity;
import tn.nightbeam.robotica.entity.SentinelEntity;
import tn.nightbeam.robotica.entity.SpaceShipEntity;

@Mod.EventBusSubscriber(bus=Mod.EventBusSubscriber.Bus.MOD)
public class RoboticaModEntities {
    public static final DeferredRegister<EntityType<?>> REGISTRY = DeferredRegister.create((IForgeRegistry)ForgeRegistries.ENTITIES, (String)"robotica");
    public static final RegistryObject<EntityType<BoggieEntity>> BOGGIE = RoboticaModEntities.register("boggie", EntityType.Builder.m_20704_(BoggieEntity::new, (MobCategory)MobCategory.MONSTER).setShouldReceiveVelocityUpdates(true).setTrackingRange(64).setUpdateInterval(3).setCustomClientFactory(BoggieEntity::new).m_20699_(0.6f, 1.0f));
    public static final RegistryObject<EntityType<SentinelEntity>> SENTINEL = RoboticaModEntities.register("sentinel", EntityType.Builder.m_20704_(SentinelEntity::new, (MobCategory)MobCategory.MONSTER).setShouldReceiveVelocityUpdates(true).setTrackingRange(128).setUpdateInterval(3).setCustomClientFactory(SentinelEntity::new).m_20699_(0.6f, 3.5f));
    public static final RegistryObject<EntityType<MechEntity>> MECH = RoboticaModEntities.register("mech", EntityType.Builder.m_20704_(MechEntity::new, (MobCategory)MobCategory.MONSTER).setShouldReceiveVelocityUpdates(true).setTrackingRange(64).setUpdateInterval(3).setCustomClientFactory(MechEntity::new).m_20699_(2.0f, 3.7f));
    public static final RegistryObject<EntityType<SpaceShipEntity>> SPACE_SHIP = RoboticaModEntities.register("space_ship", EntityType.Builder.m_20704_(SpaceShipEntity::new, (MobCategory)MobCategory.MONSTER).setShouldReceiveVelocityUpdates(true).setTrackingRange(64).setUpdateInterval(3).setCustomClientFactory(SpaceShipEntity::new).m_20699_(4.0f, 2.0f));

    private static <T extends Entity> RegistryObject<EntityType<T>> register(String registryname, EntityType.Builder<T> entityTypeBuilder) {
        return REGISTRY.register(registryname, () -> entityTypeBuilder.m_20712_(registryname));
    }

    @SubscribeEvent
    public static void init(FMLCommonSetupEvent event) {
        event.enqueueWork(() -> {
            BoggieEntity.init();
            SentinelEntity.init();
            MechEntity.init();
            SpaceShipEntity.init();
        });
    }

    @SubscribeEvent
    public static void registerAttributes(EntityAttributeCreationEvent event) {
        event.put((EntityType)BOGGIE.get(), BoggieEntity.createAttributes().m_22265_());
        event.put((EntityType)SENTINEL.get(), SentinelEntity.createAttributes().m_22265_());
        event.put((EntityType)MECH.get(), MechEntity.createAttributes().m_22265_());
        event.put((EntityType)SPACE_SHIP.get(), SpaceShipEntity.createAttributes().m_22265_());
    }
}

