/*
 * Decompiled with CFR 0.152.
 */
package tn.nightbeam.robotica.init;

import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import java.util.function.Supplier;
import net.minecraft.core.Holder;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.levelgen.GenerationStep;
import net.minecraft.world.level.levelgen.feature.Feature;
import net.minecraft.world.level.levelgen.placement.PlacedFeature;
import net.minecraftforge.event.world.BiomeLoadingEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.registries.DeferredRegister;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistry;
import net.minecraftforge.registries.RegistryObject;
import tn.nightbeam.robotica.world.features.ores.CobaltOreFeature;
import tn.nightbeam.robotica.world.features.ores.OrichalcumOreFeature;
import tn.nightbeam.robotica.world.features.ores.ScrapDebrisFeature;
import tn.nightbeam.robotica.world.features.ores.TitaniumOreFeature;

@Mod.EventBusSubscriber
public class RoboticaModFeatures {
    public static final DeferredRegister<Feature<?>> REGISTRY = DeferredRegister.create((IForgeRegistry)ForgeRegistries.FEATURES, (String)"robotica");
    private static final List<FeatureRegistration> FEATURE_REGISTRATIONS = new ArrayList<FeatureRegistration>();
    public static final RegistryObject<Feature<?>> SCRAP_DEBRIS = RoboticaModFeatures.register("scrap_debris", ScrapDebrisFeature::feature, new FeatureRegistration(GenerationStep.Decoration.UNDERGROUND_ORES, ScrapDebrisFeature.GENERATE_BIOMES, ScrapDebrisFeature::placedFeature));
    public static final RegistryObject<Feature<?>> TITANIUM_ORE = RoboticaModFeatures.register("titanium_ore", TitaniumOreFeature::feature, new FeatureRegistration(GenerationStep.Decoration.UNDERGROUND_ORES, TitaniumOreFeature.GENERATE_BIOMES, TitaniumOreFeature::placedFeature));
    public static final RegistryObject<Feature<?>> COBALT_ORE = RoboticaModFeatures.register("cobalt_ore", CobaltOreFeature::feature, new FeatureRegistration(GenerationStep.Decoration.UNDERGROUND_ORES, CobaltOreFeature.GENERATE_BIOMES, CobaltOreFeature::placedFeature));
    public static final RegistryObject<Feature<?>> ORICHALCUM_ORE = RoboticaModFeatures.register("orichalcum_ore", OrichalcumOreFeature::feature, new FeatureRegistration(GenerationStep.Decoration.UNDERGROUND_ORES, OrichalcumOreFeature.GENERATE_BIOMES, OrichalcumOreFeature::placedFeature));

    private static RegistryObject<Feature<?>> register(String registryname, Supplier<Feature<?>> feature, FeatureRegistration featureRegistration) {
        FEATURE_REGISTRATIONS.add(featureRegistration);
        return REGISTRY.register(registryname, feature);
    }

    @SubscribeEvent
    public static void addFeaturesToBiomes(BiomeLoadingEvent event) {
        for (FeatureRegistration registration : FEATURE_REGISTRATIONS) {
            if (registration.biomes() != null && !registration.biomes().contains(event.getName())) continue;
            event.getGeneration().getFeatures(registration.stage()).add(registration.placedFeature().get());
        }
    }

    private record FeatureRegistration(GenerationStep.Decoration stage, Set<ResourceLocation> biomes, Supplier<Holder<PlacedFeature>> placedFeature) {
    }
}

