/*
 * Decompiled with CFR 0.152.
 */
package tn.nightbeam.robotica.init;

import java.util.Map;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.inventory.Slot;
import net.minecraftforge.common.extensions.IForgeMenuType;
import net.minecraftforge.network.PacketDistributor;
import net.minecraftforge.registries.DeferredRegister;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistry;
import net.minecraftforge.registries.RegistryObject;
import tn.nightbeam.robotica.RoboticaMod;
import tn.nightbeam.robotica.init.RoboticaModScreens;
import tn.nightbeam.robotica.network.MenuStateUpdateMessage;
import tn.nightbeam.robotica.world.inventory.CraftingWorkStationGUIMenu;

public class RoboticaModMenus {
    public static final DeferredRegister<MenuType<?>> REGISTRY = DeferredRegister.create((IForgeRegistry)ForgeRegistries.CONTAINERS, (String)"robotica");
    public static final RegistryObject<MenuType<CraftingWorkStationGUIMenu>> CRAFTING_WORK_STATION_GUI = REGISTRY.register("crafting_work_station_gui", () -> IForgeMenuType.create(CraftingWorkStationGUIMenu::new));

    public static interface MenuAccessor {
        public Map<String, Object> getMenuState();

        public Map<Integer, Slot> getSlots();

        default public void sendMenuStateUpdate(Player player, int elementType, String name, Object elementState, boolean needClientUpdate) {
            this.getMenuState().put(elementType + ":" + name, elementState);
            if (player instanceof ServerPlayer) {
                ServerPlayer serverPlayer = (ServerPlayer)player;
                RoboticaMod.PACKET_HANDLER.send(PacketDistributor.PLAYER.with(() -> serverPlayer), (Object)new MenuStateUpdateMessage(elementType, name, elementState));
            } else if (player.f_19853_.f_46443_) {
                Screen screen = Minecraft.m_91087_().f_91080_;
                if (screen instanceof RoboticaModScreens.ScreenAccessor) {
                    RoboticaModScreens.ScreenAccessor accessor = (RoboticaModScreens.ScreenAccessor)screen;
                    if (needClientUpdate) {
                        accessor.updateMenuState(elementType, name, elementState);
                    }
                }
                RoboticaMod.PACKET_HANDLER.sendToServer((Object)new MenuStateUpdateMessage(elementType, name, elementState));
            }
        }

        default public <T> T getMenuState(int elementType, String name, T defaultValue) {
            try {
                return (T)this.getMenuState().getOrDefault(elementType + ":" + name, defaultValue);
            }
            catch (ClassCastException e) {
                return defaultValue;
            }
        }
    }
}

