/*
 * Decompiled with CFR 0.152.
 */
package tn.nightbeam.robotica.client.renderer;

import net.minecraft.client.model.EntityModel;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.entity.MobRenderer;
import net.minecraft.client.renderer.entity.state.LivingEntityRenderState;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.LivingEntity;
import tn.nightbeam.robotica.client.model.Modelship;
import tn.nightbeam.robotica.client.model.animations.shipAnimation;
import tn.nightbeam.robotica.entity.SpaceShipEntity;

public class SpaceShipRenderer
extends MobRenderer<SpaceShipEntity, LivingEntityRenderState, Modelship> {
    private SpaceShipEntity entity = null;

    public SpaceShipRenderer(EntityRendererProvider.Context context) {
        super(context, (EntityModel)new AnimatedModel(context.bakeLayer(Modelship.LAYER_LOCATION)), 0.5f);
    }

    public LivingEntityRenderState createRenderState() {
        return new LivingEntityRenderState();
    }

    public void extractRenderState(SpaceShipEntity entity, LivingEntityRenderState state, float partialTicks) {
        super.extractRenderState((LivingEntity)entity, state, partialTicks);
        this.entity = entity;
        if (this.model instanceof AnimatedModel) {
            ((AnimatedModel)this.model).setEntity(entity);
        }
    }

    public ResourceLocation getTextureLocation(LivingEntityRenderState state) {
        return ResourceLocation.parse((String)"robotica:textures/entities/ship.png");
    }

    private static final class AnimatedModel
    extends Modelship {
        private SpaceShipEntity entity = null;

        public AnimatedModel(ModelPart root) {
            super(root);
        }

        public void setEntity(SpaceShipEntity entity) {
            this.entity = entity;
        }

        @Override
        public void setupAnim(LivingEntityRenderState state) {
            this.root().getAllParts().forEach(ModelPart::resetPose);
            this.animate(this.entity.animationState0, shipAnimation.idle, state.ageInTicks, 1.0f);
            this.animateWalk(shipAnimation.movement, state.walkAnimationPos, state.walkAnimationSpeed, 1.0f, 1.0f);
            super.setupAnim(state);
        }
    }
}

