/*
 * Decompiled with CFR 0.152.
 */
package tn.nightbeam.robotica.network;

import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.PacketFlow;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.fml.event.lifecycle.FMLCommonSetupEvent;
import net.neoforged.neoforge.network.handling.IPayloadContext;
import tn.nightbeam.robotica.RoboticaMod;
import tn.nightbeam.robotica.procedures.FlyCapsuleGoUpOnKeyPressedProcedure;
import tn.nightbeam.robotica.procedures.FlyCapsuleGoUpOnKeyReleasedProcedure;

@EventBusSubscriber(bus=EventBusSubscriber.Bus.MOD)
public record FlyCapsuleGoUpMessage(int eventType, int pressedms) implements CustomPacketPayload
{
    public static final CustomPacketPayload.Type<FlyCapsuleGoUpMessage> TYPE = new CustomPacketPayload.Type(ResourceLocation.fromNamespaceAndPath((String)"robotica", (String)"key_fly_capsule_go_up"));
    public static final StreamCodec<RegistryFriendlyByteBuf, FlyCapsuleGoUpMessage> STREAM_CODEC = StreamCodec.of((buffer, message) -> {
        buffer.writeInt(message.eventType);
        buffer.writeInt(message.pressedms);
    }, buffer -> new FlyCapsuleGoUpMessage(buffer.readInt(), buffer.readInt()));

    public CustomPacketPayload.Type<FlyCapsuleGoUpMessage> type() {
        return TYPE;
    }

    public static void handleData(FlyCapsuleGoUpMessage message, IPayloadContext context) {
        if (context.flow() == PacketFlow.SERVERBOUND) {
            context.enqueueWork(() -> FlyCapsuleGoUpMessage.pressAction(context.player(), message.eventType, message.pressedms)).exceptionally(e -> {
                context.connection().disconnect((Component)Component.literal((String)e.getMessage()));
                return null;
            });
        }
    }

    public static void pressAction(Player entity, int type, int pressedms) {
        Level world = entity.level();
        double x = entity.getX();
        double y = entity.getY();
        double z = entity.getZ();
        if (!world.hasChunkAt(entity.blockPosition())) {
            return;
        }
        if (type == 0) {
            FlyCapsuleGoUpOnKeyPressedProcedure.execute((Entity)entity);
        }
        if (type == 1) {
            FlyCapsuleGoUpOnKeyReleasedProcedure.execute((Entity)entity);
        }
    }

    @SubscribeEvent
    public static void registerMessage(FMLCommonSetupEvent event) {
        RoboticaMod.addNetworkMessage(TYPE, STREAM_CODEC, FlyCapsuleGoUpMessage::handleData);
    }
}

