/*
 * Decompiled with CFR 0.152.
 */
package tn.nightbeam.robotica.init;

import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityClassification;
import net.minecraft.entity.EntityType;
import net.minecraftforge.event.entity.EntityAttributeCreationEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.RegistryObject;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.registries.DeferredRegister;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistry;
import tn.nightbeam.robotica.entity.BoggieEntity;
import tn.nightbeam.robotica.entity.MechEntity;
import tn.nightbeam.robotica.entity.SentinelEntity;
import tn.nightbeam.robotica.entity.SpaceShipEntity;

@Mod.EventBusSubscriber(bus=Mod.EventBusSubscriber.Bus.MOD)
public class RoboticaModEntities {
    public static final DeferredRegister<EntityType<?>> REGISTRY = DeferredRegister.create((IForgeRegistry)ForgeRegistries.ENTITIES, (String)"robotica");
    public static final RegistryObject<EntityType<BoggieEntity>> BOGGIE = RoboticaModEntities.register("boggie", EntityType.Builder.func_220322_a(BoggieEntity::new, (EntityClassification)EntityClassification.MONSTER).setShouldReceiveVelocityUpdates(true).setTrackingRange(64).setUpdateInterval(3).setCustomClientFactory(BoggieEntity::new).func_220321_a(0.6f, 1.0f));
    public static final RegistryObject<EntityType<SentinelEntity>> SENTINEL = RoboticaModEntities.register("sentinel", EntityType.Builder.func_220322_a(SentinelEntity::new, (EntityClassification)EntityClassification.MONSTER).setShouldReceiveVelocityUpdates(true).setTrackingRange(128).setUpdateInterval(3).setCustomClientFactory(SentinelEntity::new).func_220321_a(0.6f, 3.5f));
    public static final RegistryObject<EntityType<MechEntity>> MECH = RoboticaModEntities.register("mech", EntityType.Builder.func_220322_a(MechEntity::new, (EntityClassification)EntityClassification.MONSTER).setShouldReceiveVelocityUpdates(true).setTrackingRange(64).setUpdateInterval(3).setCustomClientFactory(MechEntity::new).func_220321_a(2.0f, 3.7f));
    public static final RegistryObject<EntityType<SpaceShipEntity>> SPACE_SHIP = RoboticaModEntities.register("space_ship", EntityType.Builder.func_220322_a(SpaceShipEntity::new, (EntityClassification)EntityClassification.MONSTER).setShouldReceiveVelocityUpdates(true).setTrackingRange(64).setUpdateInterval(3).setCustomClientFactory(SpaceShipEntity::new).func_220321_a(4.0f, 2.0f));

    private static <T extends Entity> RegistryObject<EntityType<T>> register(String registryname, EntityType.Builder<T> entityTypeBuilder) {
        return REGISTRY.register(registryname, () -> entityTypeBuilder.func_206830_a(registryname));
    }

    @SubscribeEvent
    public static void init(FMLCommonSetupEvent event) {
        event.enqueueWork(() -> {
            BoggieEntity.init();
            SentinelEntity.init();
            MechEntity.init();
            SpaceShipEntity.init();
        });
    }

    @SubscribeEvent
    public static void registerAttributes(EntityAttributeCreationEvent event) {
        event.put((EntityType)BOGGIE.get(), BoggieEntity.createAttributes().func_233813_a_());
        event.put((EntityType)SENTINEL.get(), SentinelEntity.createAttributes().func_233813_a_());
        event.put((EntityType)MECH.get(), MechEntity.createAttributes().func_233813_a_());
        event.put((EntityType)SPACE_SHIP.get(), SpaceShipEntity.createAttributes().func_233813_a_());
    }
}

