/*
 * Decompiled with CFR 0.152.
 */
package tn.nightbeam.robotica.init;

import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import java.util.function.Supplier;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.gen.GenerationStage;
import net.minecraft.world.gen.feature.ConfiguredFeature;
import net.minecraft.world.gen.feature.Feature;
import net.minecraftforge.event.world.BiomeLoadingEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.RegistryObject;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.registries.DeferredRegister;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistry;
import tn.nightbeam.robotica.world.features.ores.CobaltOreFeature;
import tn.nightbeam.robotica.world.features.ores.OrichalcumOreFeature;
import tn.nightbeam.robotica.world.features.ores.ScrapDebrisFeature;
import tn.nightbeam.robotica.world.features.ores.TitaniumOreFeature;

@Mod.EventBusSubscriber
public class RoboticaModFeatures {
    public static final DeferredRegister<Feature<?>> REGISTRY = DeferredRegister.create((IForgeRegistry)ForgeRegistries.FEATURES, (String)"robotica");
    private static final List<FeatureRegistration> FEATURE_REGISTRATIONS = new ArrayList<FeatureRegistration>();
    public static final RegistryObject<Feature<?>> SCRAP_DEBRIS = RoboticaModFeatures.register("scrap_debris", ScrapDebrisFeature::feature, new FeatureRegistration(GenerationStage.Decoration.UNDERGROUND_ORES, ScrapDebrisFeature.GENERATE_BIOMES, ScrapDebrisFeature::configuredFeature));
    public static final RegistryObject<Feature<?>> TITANIUM_ORE = RoboticaModFeatures.register("titanium_ore", TitaniumOreFeature::feature, new FeatureRegistration(GenerationStage.Decoration.UNDERGROUND_ORES, TitaniumOreFeature.GENERATE_BIOMES, TitaniumOreFeature::configuredFeature));
    public static final RegistryObject<Feature<?>> COBALT_ORE = RoboticaModFeatures.register("cobalt_ore", CobaltOreFeature::feature, new FeatureRegistration(GenerationStage.Decoration.UNDERGROUND_ORES, CobaltOreFeature.GENERATE_BIOMES, CobaltOreFeature::configuredFeature));
    public static final RegistryObject<Feature<?>> ORICHALCUM_ORE = RoboticaModFeatures.register("orichalcum_ore", OrichalcumOreFeature::feature, new FeatureRegistration(GenerationStage.Decoration.UNDERGROUND_ORES, OrichalcumOreFeature.GENERATE_BIOMES, OrichalcumOreFeature::configuredFeature));

    private static RegistryObject<Feature<?>> register(String registryname, Supplier<Feature<?>> feature, FeatureRegistration featureRegistration) {
        FEATURE_REGISTRATIONS.add(featureRegistration);
        return REGISTRY.register(registryname, feature);
    }

    @SubscribeEvent
    public static void addFeaturesToBiomes(BiomeLoadingEvent event) {
        for (FeatureRegistration registration : FEATURE_REGISTRATIONS) {
            if (registration.biomes() != null && !registration.biomes().contains(event.getName())) continue;
            event.getGeneration().getFeatures(registration.stage()).add(registration.configuredFeature());
        }
    }

    private static class FeatureRegistration {
        private final GenerationStage.Decoration stage;
        private final Set<ResourceLocation> biomes;
        private final Supplier<ConfiguredFeature<?, ?>> configuredFeature;

        public FeatureRegistration(GenerationStage.Decoration stage, Set<ResourceLocation> biomes, Supplier<ConfiguredFeature<?, ?>> configuredFeature) {
            this.stage = stage;
            this.biomes = biomes;
            this.configuredFeature = configuredFeature;
        }

        public GenerationStage.Decoration stage() {
            return this.stage;
        }

        public Set<ResourceLocation> biomes() {
            return this.biomes;
        }

        public Supplier<ConfiguredFeature<?, ?>> configuredFeature() {
            return this.configuredFeature;
        }
    }
}

