/*
 * Decompiled with CFR 0.152.
 */
package tn.nightbeam.robotica.network;

import java.util.function.Supplier;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.network.PacketBuffer;
import net.minecraft.world.World;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.fml.network.NetworkEvent;
import tn.nightbeam.robotica.RoboticaMod;
import tn.nightbeam.robotica.procedures.FlyCapsuleGoForwardOnKeyPressedProcedure;
import tn.nightbeam.robotica.procedures.FlyCapsuleGoForwardOnKeyReleasedProcedure;

@Mod.EventBusSubscriber(bus=Mod.EventBusSubscriber.Bus.MOD)
public class FlyCapsuleGoForwardMessage {
    int type;
    int pressedms;

    public FlyCapsuleGoForwardMessage(int type, int pressedms) {
        this.type = type;
        this.pressedms = pressedms;
    }

    public FlyCapsuleGoForwardMessage(PacketBuffer buffer) {
        this.type = buffer.readInt();
        this.pressedms = buffer.readInt();
    }

    public static void buffer(FlyCapsuleGoForwardMessage message, PacketBuffer buffer) {
        buffer.writeInt(message.type);
        buffer.writeInt(message.pressedms);
    }

    public static void handler(FlyCapsuleGoForwardMessage message, Supplier<NetworkEvent.Context> contextSupplier) {
        NetworkEvent.Context context = contextSupplier.get();
        context.enqueueWork(() -> FlyCapsuleGoForwardMessage.pressAction((PlayerEntity)context.getSender(), message.type, message.pressedms));
        context.setPacketHandled(true);
    }

    public static void pressAction(PlayerEntity entity, int type, int pressedms) {
        World world = entity.field_70170_p;
        double x = entity.func_226277_ct_();
        double y = entity.func_226278_cu_();
        double z = entity.func_226281_cx_();
        if (!world.func_175667_e(entity.func_233580_cy_())) {
            return;
        }
        if (type == 0) {
            FlyCapsuleGoForwardOnKeyPressedProcedure.execute((Entity)entity);
        }
        if (type == 1) {
            FlyCapsuleGoForwardOnKeyReleasedProcedure.execute((Entity)entity);
        }
    }

    @SubscribeEvent
    public static void registerMessage(FMLCommonSetupEvent event) {
        RoboticaMod.addNetworkMessage(FlyCapsuleGoForwardMessage.class, FlyCapsuleGoForwardMessage::buffer, FlyCapsuleGoForwardMessage::new, FlyCapsuleGoForwardMessage::handler);
    }
}

