/*
 * Decompiled with CFR 0.152.
 */
package tn.nightbeam.robotica.network;

import java.util.function.Supplier;
import net.minecraft.client.Minecraft;
import net.minecraft.network.PacketBuffer;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.fml.network.NetworkEvent;
import tn.nightbeam.robotica.RoboticaMod;
import tn.nightbeam.robotica.init.RoboticaModMenus;
import tn.nightbeam.robotica.init.RoboticaModScreens;

@Mod.EventBusSubscriber(bus=Mod.EventBusSubscriber.Bus.MOD)
public class MenuStateUpdateMessage {
    private final int elementType;
    private final String name;
    private final Object elementState;

    public MenuStateUpdateMessage(int elementType, String name, Object elementState) {
        this.elementType = elementType;
        this.name = name;
        this.elementState = elementState;
    }

    public MenuStateUpdateMessage(PacketBuffer buffer) {
        this.elementType = buffer.readInt();
        this.name = buffer.func_218666_n();
        Object elementState = null;
        if (this.elementType == 0) {
            elementState = buffer.func_218666_n();
        } else if (this.elementType == 1) {
            elementState = buffer.readBoolean();
        }
        this.elementState = elementState;
    }

    public static void buffer(MenuStateUpdateMessage message, PacketBuffer buffer) {
        buffer.writeInt(message.elementType);
        buffer.func_180714_a(message.name);
        if (message.elementType == 0) {
            buffer.func_180714_a((String)message.elementState);
        } else if (message.elementType == 1) {
            buffer.writeBoolean(((Boolean)message.elementState).booleanValue());
        }
    }

    public static void handler(MenuStateUpdateMessage message, Supplier<NetworkEvent.Context> contextSupplier) {
        if (message.name.length() > 256 || message.elementState instanceof String && ((String)message.elementState).length() > 8192) {
            return;
        }
        NetworkEvent.Context context = contextSupplier.get();
        context.enqueueWork(() -> {
            if (context.getSender().field_71070_bA instanceof RoboticaModMenus.MenuAccessor) {
                ((RoboticaModMenus.MenuAccessor)context.getSender().field_71070_bA).getMenuState().put(message.elementType + ":" + message.name, message.elementState);
                if (!context.getDirection().getReceptionSide().isServer() && Minecraft.func_71410_x().field_71462_r instanceof RoboticaModScreens.ScreenAccessor) {
                    ((RoboticaModScreens.ScreenAccessor)Minecraft.func_71410_x().field_71462_r).updateMenuState(message.elementType, message.name, message.elementState);
                }
            }
        });
        context.setPacketHandled(true);
    }

    @SubscribeEvent
    public static void registerMessage(FMLCommonSetupEvent event) {
        RoboticaMod.addNetworkMessage(MenuStateUpdateMessage.class, MenuStateUpdateMessage::buffer, MenuStateUpdateMessage::new, MenuStateUpdateMessage::handler);
    }
}

