/*
 * Decompiled with CFR 0.152.
 */
package tn.nightbeam.robotica.client.renderer;

import net.minecraft.client.animation.KeyframeAnimation;
import net.minecraft.client.model.EntityModel;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.entity.MobRenderer;
import net.minecraft.client.renderer.entity.state.LivingEntityRenderState;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.LivingEntity;
import tn.nightbeam.robotica.client.model.Modelboogie;
import tn.nightbeam.robotica.client.model.animations.boogieAnimation;
import tn.nightbeam.robotica.entity.BoggieEntity;

public class BoggieRenderer
extends MobRenderer<BoggieEntity, LivingEntityRenderState, Modelboogie> {
    private BoggieEntity entity = null;

    public BoggieRenderer(EntityRendererProvider.Context context) {
        super(context, (EntityModel)new AnimatedModel(context.bakeLayer(Modelboogie.LAYER_LOCATION)), 0.5f);
    }

    public LivingEntityRenderState createRenderState() {
        return new LivingEntityRenderState();
    }

    public void extractRenderState(BoggieEntity entity, LivingEntityRenderState state, float partialTicks) {
        super.extractRenderState((LivingEntity)entity, state, partialTicks);
        this.entity = entity;
        if (this.model instanceof AnimatedModel) {
            ((AnimatedModel)this.model).setEntity(entity);
        }
    }

    public ResourceLocation getTextureLocation(LivingEntityRenderState state) {
        return ResourceLocation.parse((String)"robotica:textures/entities/boogie_java.png");
    }

    private static final class AnimatedModel
    extends Modelboogie {
        private BoggieEntity entity = null;
        private final KeyframeAnimation keyframeAnimation0;
        private final KeyframeAnimation keyframeAnimation1;
        private final KeyframeAnimation keyframeAnimation2;

        public AnimatedModel(ModelPart root) {
            super(root);
            this.keyframeAnimation0 = boogieAnimation.idle.bake(root);
            this.keyframeAnimation1 = boogieAnimation.walk.bake(root);
            this.keyframeAnimation2 = boogieAnimation.attack.bake(root);
        }

        public void setEntity(BoggieEntity entity) {
            this.entity = entity;
        }

        @Override
        public void setupAnim(LivingEntityRenderState state) {
            this.root().getAllParts().forEach(ModelPart::resetPose);
            this.keyframeAnimation0.apply(this.entity.animationState0, state.ageInTicks, 1.0f);
            this.keyframeAnimation1.applyWalk(state.walkAnimationPos, state.walkAnimationSpeed, 1.0f, 1.0f);
            this.keyframeAnimation2.apply(this.entity.animationState2, state.ageInTicks, 1.0f);
            super.setupAnim(state);
        }
    }
}

