/*
 * Decompiled with CFR 0.152.
 */
package tn.nightbeam.robotica.fluid;

import net.minecraft.world.item.Item;
import net.minecraft.world.level.block.LiquidBlock;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidState;
import net.neoforged.neoforge.fluids.BaseFlowingFluid;
import net.neoforged.neoforge.fluids.FluidType;
import tn.nightbeam.robotica.init.RoboticaModBlocks;
import tn.nightbeam.robotica.init.RoboticaModFluidTypes;
import tn.nightbeam.robotica.init.RoboticaModFluids;
import tn.nightbeam.robotica.init.RoboticaModItems;

public abstract class OilFluid
extends BaseFlowingFluid {
    public static final BaseFlowingFluid.Properties PROPERTIES = new BaseFlowingFluid.Properties(() -> (FluidType)RoboticaModFluidTypes.OIL_TYPE.get(), () -> (Fluid)RoboticaModFluids.OIL.get(), () -> (Fluid)RoboticaModFluids.FLOWING_OIL.get()).explosionResistance(100.0f).tickRate(3).bucket(() -> (Item)RoboticaModItems.OIL_BUCKET.get()).block(() -> (LiquidBlock)RoboticaModBlocks.OIL.get());

    private OilFluid() {
        super(PROPERTIES);
    }

    public static class Flowing
    extends OilFluid {
        protected void createFluidStateDefinition(StateDefinition.Builder<Fluid, FluidState> builder) {
            super.createFluidStateDefinition(builder);
            builder.add(new Property[]{LEVEL});
        }

        public int getAmount(FluidState state) {
            return (Integer)state.getValue((Property)LEVEL);
        }

        public boolean isSource(FluidState state) {
            return false;
        }
    }

    public static class Source
    extends OilFluid {
        public int getAmount(FluidState state) {
            return 8;
        }

        public boolean isSource(FluidState state) {
            return true;
        }
    }
}

