/*
 * Decompiled with CFR 0.152.
 */
package tn.nightbeam.robotica.init;

import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.MobCategory;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.event.entity.EntityAttributeCreationEvent;
import net.neoforged.neoforge.event.entity.RegisterSpawnPlacementsEvent;
import net.neoforged.neoforge.registries.DeferredHolder;
import net.neoforged.neoforge.registries.DeferredRegister;
import tn.nightbeam.robotica.entity.BoggieEntity;
import tn.nightbeam.robotica.entity.MechEntity;
import tn.nightbeam.robotica.entity.SentinelEntity;
import tn.nightbeam.robotica.entity.SpaceShipEntity;

@EventBusSubscriber
public class RoboticaModEntities {
    public static final DeferredRegister<EntityType<?>> REGISTRY = DeferredRegister.create((ResourceKey)Registries.ENTITY_TYPE, (String)"robotica");
    public static final DeferredHolder<EntityType<?>, EntityType<BoggieEntity>> BOGGIE = RoboticaModEntities.register("boggie", EntityType.Builder.of(BoggieEntity::new, (MobCategory)MobCategory.MONSTER).setShouldReceiveVelocityUpdates(true).setTrackingRange(64).setUpdateInterval(3).sized(0.6f, 1.0f));
    public static final DeferredHolder<EntityType<?>, EntityType<SentinelEntity>> SENTINEL = RoboticaModEntities.register("sentinel", EntityType.Builder.of(SentinelEntity::new, (MobCategory)MobCategory.MONSTER).setShouldReceiveVelocityUpdates(true).setTrackingRange(128).setUpdateInterval(3).sized(0.6f, 3.5f));
    public static final DeferredHolder<EntityType<?>, EntityType<MechEntity>> MECH = RoboticaModEntities.register("mech", EntityType.Builder.of(MechEntity::new, (MobCategory)MobCategory.MONSTER).setShouldReceiveVelocityUpdates(true).setTrackingRange(64).setUpdateInterval(3).sized(2.0f, 3.7f));
    public static final DeferredHolder<EntityType<?>, EntityType<SpaceShipEntity>> SPACE_SHIP = RoboticaModEntities.register("space_ship", EntityType.Builder.of(SpaceShipEntity::new, (MobCategory)MobCategory.MONSTER).setShouldReceiveVelocityUpdates(true).setTrackingRange(64).setUpdateInterval(3).sized(4.0f, 2.0f));

    private static <T extends Entity> DeferredHolder<EntityType<?>, EntityType<T>> register(String registryname, EntityType.Builder<T> entityTypeBuilder) {
        return REGISTRY.register(registryname, () -> entityTypeBuilder.build(ResourceKey.create((ResourceKey)Registries.ENTITY_TYPE, (ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"robotica", (String)registryname))));
    }

    @SubscribeEvent
    public static void init(RegisterSpawnPlacementsEvent event) {
        BoggieEntity.init(event);
        SentinelEntity.init(event);
        MechEntity.init(event);
        SpaceShipEntity.init(event);
    }

    @SubscribeEvent
    public static void registerAttributes(EntityAttributeCreationEvent event) {
        event.put((EntityType)BOGGIE.get(), BoggieEntity.createAttributes().build());
        event.put((EntityType)SENTINEL.get(), SentinelEntity.createAttributes().build());
        event.put((EntityType)MECH.get(), MechEntity.createAttributes().build());
        event.put((EntityType)SPACE_SHIP.get(), SpaceShipEntity.createAttributes().build());
    }
}

