/*
 * Decompiled with CFR 0.152.
 */
package tn.nightbeam.nextmillennium.network;

import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.PacketFlow;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.fml.event.lifecycle.FMLCommonSetupEvent;
import net.neoforged.neoforge.network.handling.IPayloadContext;
import tn.nightbeam.nextmillennium.Theyear3001Mod;
import tn.nightbeam.nextmillennium.procedures.FlyCapsuleGoDownOnKeyPressedProcedure;
import tn.nightbeam.nextmillennium.procedures.FlyCapsuleGoUpOnKeyReleasedProcedure;

@EventBusSubscriber(bus=EventBusSubscriber.Bus.MOD)
public record FlyCapsuleGoDownMessage(int eventType, int pressedms) implements CustomPacketPayload
{
    public static final CustomPacketPayload.Type<FlyCapsuleGoDownMessage> TYPE = new CustomPacketPayload.Type(ResourceLocation.fromNamespaceAndPath((String)"theyear3001", (String)"key_fly_capsule_go_down"));
    public static final StreamCodec<RegistryFriendlyByteBuf, FlyCapsuleGoDownMessage> STREAM_CODEC = StreamCodec.of((buffer, message) -> {
        buffer.writeInt(message.eventType);
        buffer.writeInt(message.pressedms);
    }, buffer -> new FlyCapsuleGoDownMessage(buffer.readInt(), buffer.readInt()));

    public CustomPacketPayload.Type<FlyCapsuleGoDownMessage> type() {
        return TYPE;
    }

    public static void handleData(FlyCapsuleGoDownMessage message, IPayloadContext context) {
        if (context.flow() == PacketFlow.SERVERBOUND) {
            context.enqueueWork(() -> FlyCapsuleGoDownMessage.pressAction(context.player(), message.eventType, message.pressedms)).exceptionally(e -> {
                context.connection().disconnect((Component)Component.literal((String)e.getMessage()));
                return null;
            });
        }
    }

    public static void pressAction(Player entity, int type, int pressedms) {
        Level world = entity.level();
        double x = entity.getX();
        double y = entity.getY();
        double z = entity.getZ();
        if (!world.hasChunkAt(entity.blockPosition())) {
            return;
        }
        if (type == 0) {
            FlyCapsuleGoDownOnKeyPressedProcedure.execute((Entity)entity);
        }
        if (type == 1) {
            FlyCapsuleGoUpOnKeyReleasedProcedure.execute((Entity)entity);
        }
    }

    @SubscribeEvent
    public static void registerMessage(FMLCommonSetupEvent event) {
        Theyear3001Mod.addNetworkMessage(TYPE, STREAM_CODEC, FlyCapsuleGoDownMessage::handleData);
    }
}

