/*
 * Decompiled with CFR 0.152.
 */
package tn.nightbeam.nextmillennium.network;

import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.PacketFlow;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.fml.event.lifecycle.FMLCommonSetupEvent;
import net.neoforged.neoforge.network.handling.IPayloadContext;
import tn.nightbeam.nextmillennium.Theyear3001Mod;
import tn.nightbeam.nextmillennium.procedures.FlyCapsuleGoForwardOnKeyPressedProcedure;
import tn.nightbeam.nextmillennium.procedures.FlyCapsuleGoForwardOnKeyReleasedProcedure;

@EventBusSubscriber(bus=EventBusSubscriber.Bus.MOD)
public record FlyCapsuleGoForwardMessage(int eventType, int pressedms) implements CustomPacketPayload
{
    public static final CustomPacketPayload.Type<FlyCapsuleGoForwardMessage> TYPE = new CustomPacketPayload.Type(ResourceLocation.fromNamespaceAndPath((String)"theyear3001", (String)"key_fly_capsule_go_forward"));
    public static final StreamCodec<RegistryFriendlyByteBuf, FlyCapsuleGoForwardMessage> STREAM_CODEC = StreamCodec.of((buffer, message) -> {
        buffer.writeInt(message.eventType);
        buffer.writeInt(message.pressedms);
    }, buffer -> new FlyCapsuleGoForwardMessage(buffer.readInt(), buffer.readInt()));

    public CustomPacketPayload.Type<FlyCapsuleGoForwardMessage> type() {
        return TYPE;
    }

    public static void handleData(FlyCapsuleGoForwardMessage message, IPayloadContext context) {
        if (context.flow() == PacketFlow.SERVERBOUND) {
            context.enqueueWork(() -> FlyCapsuleGoForwardMessage.pressAction(context.player(), message.eventType, message.pressedms)).exceptionally(e -> {
                context.connection().disconnect((Component)Component.literal((String)e.getMessage()));
                return null;
            });
        }
    }

    public static void pressAction(Player entity, int type, int pressedms) {
        Level world = entity.level();
        double x = entity.getX();
        double y = entity.getY();
        double z = entity.getZ();
        if (!world.hasChunkAt(entity.blockPosition())) {
            return;
        }
        if (type == 0) {
            FlyCapsuleGoForwardOnKeyPressedProcedure.execute((Entity)entity);
        }
        if (type == 1) {
            FlyCapsuleGoForwardOnKeyReleasedProcedure.execute((Entity)entity);
        }
    }

    @SubscribeEvent
    public static void registerMessage(FMLCommonSetupEvent event) {
        Theyear3001Mod.addNetworkMessage(TYPE, STREAM_CODEC, FlyCapsuleGoForwardMessage::handleData);
    }
}

