/*
 * Decompiled with CFR 0.152.
 */
package com.mubioh.bedrockcoordinates.config;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Reader;

public class CoordinateConfig {
    public boolean showCoordinates = true;
    private static final File CONFIG_FILE = new File("config/coordinates_config.json");
    private static final Gson GSON = new GsonBuilder().setPrettyPrinting().create();
    public static CoordinateConfig configInstance = new CoordinateConfig();

    public static void load() {
        if (!CONFIG_FILE.exists()) {
            CoordinateConfig.save();
            return;
        }
        try (FileReader reader = new FileReader(CONFIG_FILE);){
            CoordinateConfig loadedConfig = (CoordinateConfig)GSON.fromJson((Reader)reader, CoordinateConfig.class);
            if (loadedConfig != null) {
                configInstance = loadedConfig;
            }
            System.out.println("[CoordinateConfig] Loaded config: showCoordinates=" + CoordinateConfig.configInstance.showCoordinates);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public static void save() {
        try {
            boolean dirsCreated;
            if (!CONFIG_FILE.getParentFile().exists() && (dirsCreated = CONFIG_FILE.getParentFile().mkdirs())) {
                System.out.println("[CoordinateConfig] Created config directory.");
            }
            try (FileWriter writer = new FileWriter(CONFIG_FILE);){
                GSON.toJson((Object)configInstance, (Appendable)writer);
                System.out.println("[CoordinateConfig] Saved config: showCoordinates=" + CoordinateConfig.configInstance.showCoordinates);
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public CoordinateConfig() {
    }

    public CoordinateConfig(boolean showCoordinates) {
        this.showCoordinates = showCoordinates;
    }
}

