/*
 * Decompiled with CFR 0.152.
 */
package coolaid.drsr.mixin;

import coolaid.drsr.DynamicRaidSpawnRadius;
import java.util.Optional;
import net.minecraft.server.world.ServerWorld;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.village.raid.Raid;
import net.minecraft.world.Heightmap;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={Raid.class})
public abstract class RaidMixin {
    @Inject(method={"getRaidersSpawnLocation"}, at={@At(value="HEAD")}, cancellable=true)
    private void overrideRaidSpawnLocation(ServerWorld world, CallbackInfoReturnable<Optional<BlockPos>> cir) {
        int radius = DynamicRaidSpawnRadius.CONFIG.raidSpawnRadius;
        BlockPos center = ((Raid)this).getCenter();
        float angle = world.random.nextFloat() * ((float)Math.PI * 2);
        int offsetX = (int)(MathHelper.cos((float)angle) * (float)radius);
        int offsetZ = (int)(MathHelper.sin((float)angle) * (float)radius);
        BlockPos.Mutable spawnPos = center.mutableCopy().move(offsetX, 0, offsetZ);
        int topY = world.getTopY(Heightmap.Type.WORLD_SURFACE_WG, spawnPos.getX(), spawnPos.getZ());
        spawnPos.setY(topY);
        cir.setReturnValue(Optional.of(spawnPos.toImmutable()));
        cir.cancel();
    }
}

