/*
 * Decompiled with CFR 0.152.
 */
package dev.tr7zw.waveycapes;

import dev.tr7zw.transition.mc.MathUtil;
import dev.tr7zw.transition.mc.VertexConsumerUtil;
import dev.tr7zw.transition.mc.entitywrapper.PlayerWrapper;
import dev.tr7zw.waveycapes.CapeRenderer;
import dev.tr7zw.waveycapes.NMSUtil;
import dev.tr7zw.waveycapes.VanillaCapeRenderer;
import dev.tr7zw.waveycapes.WaveyCapesBase;
import dev.tr7zw.waveycapes.support.ModSupport;
import dev.tr7zw.waveycapes.support.SupportManager;
import dev.tr7zw.waveycapes.versionless.CapeHolder;
import dev.tr7zw.waveycapes.versionless.CapeMovement;
import dev.tr7zw.waveycapes.versionless.CapeStyle;
import dev.tr7zw.waveycapes.versionless.ModBase;
import dev.tr7zw.waveycapes.versionless.WindMode;
import dev.tr7zw.waveycapes.versionless.sim.BasicSimulation;
import dev.tr7zw.waveycapes.versionless.util.Vector3;
import dev.tr7zw.waveycapes.versionless.util.Vector4;
import net.minecraft.class_10055;
import net.minecraft.class_11890;
import net.minecraft.class_4587;
import net.minecraft.class_4588;
import net.minecraft.class_4597;
import net.minecraft.class_4608;
import net.minecraft.class_630;
import org.joml.Matrix4f;
import org.joml.Matrix4fc;
import org.joml.Quaternionfc;
import org.joml.Vector4f;

public class CustomCapeRenderer {
    private static final int PART_COUNT = 16;
    private final class_630[] customCape = NMSUtil.buildCape(64, 64, x -> 0, y -> y);
    private static VanillaCapeRenderer vanillaCape = new VanillaCapeRenderer();

    public void render(PlayerWrapper capeRenderInfo, class_4587 poseStack, class_4597 multiBufferSource, int packedLight, float delta) {
        CapeRenderer renderer = this.getCapeRenderer(capeRenderInfo);
        if (renderer == null) {
            return;
        }
        if (!this.prepareCape(capeRenderInfo)) {
            return;
        }
        class_4588 bufferBuilder = renderer.getVertexConsumer(multiBufferSource, capeRenderInfo);
        if (bufferBuilder == null) {
            return;
        }
        if (ModBase.config.capeStyle == CapeStyle.SMOOTH && renderer.vanillaUvValues()) {
            this.renderSmoothCape(poseStack, bufferBuilder, capeRenderInfo, delta, packedLight);
        } else {
            class_630[] parts = this.customCape;
            for (int part = 0; part < 16; ++part) {
                class_630 model = parts[part];
                this.modifyPoseStack(poseStack, capeRenderInfo, delta, part);
                renderer.render(capeRenderInfo, part, model, poseStack, bufferBuilder, packedLight, class_4608.field_21444);
                poseStack.method_22909();
            }
        }
    }

    private boolean prepareCape(PlayerWrapper capeRenderInfo) {
        CapeHolder holder = (CapeHolder)capeRenderInfo.getAvatar();
        if (holder == null) {
            return false;
        }
        holder.updateSimulation(16);
        return true;
    }

    private void renderSmoothCape(class_4587 poseStack, class_4588 bufferBuilder, PlayerWrapper capeRenderInfo, float delta, int light) {
        float alpha = SupportManager.getAlphaSupplier().get().floatValue();
        Matrix4f oldPositionMatrix = null;
        for (int part = 0; part < 16; ++part) {
            this.modifyPoseStack(poseStack, capeRenderInfo, delta, part);
            if (oldPositionMatrix == null) {
                oldPositionMatrix = poseStack.method_23760().method_23761();
            }
            float capeWidth = 0.625f;
            float capeHeight = 1.0f;
            float capeDepth = 0.0625f;
            if (part == 0) {
                CustomCapeRenderer.addTopVertex(bufferBuilder, poseStack.method_23760().method_23761(), oldPositionMatrix, capeWidth / 2.0f, 0.0f, 0.0f, -capeWidth / 2.0f, 0.0f, -capeDepth, light, alpha);
            }
            if (part == 15) {
                CustomCapeRenderer.addBottomVertex(bufferBuilder, poseStack.method_23760().method_23761(), poseStack.method_23760().method_23761(), capeWidth / 2.0f, (float)(part + 1) * (capeHeight / 16.0f), 0.0f, -capeWidth / 2.0f, (float)(part + 1) * (capeHeight / 16.0f), -capeDepth, light, alpha);
            }
            CustomCapeRenderer.addLeftVertex(bufferBuilder, poseStack.method_23760().method_23761(), oldPositionMatrix, -capeWidth / 2.0f, (float)(part + 1) * (capeHeight / 16.0f), 0.0f, -capeWidth / 2.0f, (float)part * (capeHeight / 16.0f), -capeDepth, part, light, alpha);
            CustomCapeRenderer.addRightVertex(bufferBuilder, poseStack.method_23760().method_23761(), oldPositionMatrix, capeWidth / 2.0f, (float)(part + 1) * (capeHeight / 16.0f), 0.0f, capeWidth / 2.0f, (float)part * (capeHeight / 16.0f), -capeDepth, part, light, alpha);
            CustomCapeRenderer.addBackVertex(bufferBuilder, poseStack.method_23760().method_23761(), oldPositionMatrix, capeWidth / 2.0f, (float)(part + 1) * (capeHeight / 16.0f), -capeDepth, -capeWidth / 2.0f, (float)part * (capeHeight / 16.0f), -capeDepth, part, light, alpha);
            CustomCapeRenderer.addFrontVertex(bufferBuilder, oldPositionMatrix, poseStack.method_23760().method_23761(), capeWidth / 2.0f, (float)(part + 1) * (capeHeight / 16.0f), 0.0f, -capeWidth / 2.0f, (float)part * (capeHeight / 16.0f), 0.0f, part, light, alpha);
            oldPositionMatrix = new Matrix4f((Matrix4fc)poseStack.method_23760().method_23761());
            poseStack.method_22909();
        }
    }

    private void modifyPoseStack(class_4587 poseStack, PlayerWrapper capeRenderInfo, float h, int part) {
        if (WaveyCapesBase.config.capeMovement != CapeMovement.VANILLA) {
            this.modifyPoseStackSimulation(poseStack, capeRenderInfo, h, part);
            return;
        }
        class_10055 renderState = capeRenderInfo.getRenderState();
        poseStack.method_22903();
        poseStack.method_22904(0.0, 0.0, 0.125);
        class_11890 entity = capeRenderInfo.getAvatar();
        poseStack.method_22907((Quaternionfc)MathUtil.XP.rotationDegrees(6.0f + renderState.field_53537 / 2.0f + renderState.field_53536 + this.getNatrualWindSwing(part, entity.method_5869())));
        poseStack.method_22907((Quaternionfc)MathUtil.ZP.rotationDegrees(renderState.field_53538 / 2.0f));
        poseStack.method_22907((Quaternionfc)MathUtil.YP.rotationDegrees(180.0f - renderState.field_53538 / 2.0f));
    }

    private void modifyPoseStackSimulation(class_4587 poseStack, PlayerWrapper capeRenderInfo, float delta, int part) {
        class_11890 entity = capeRenderInfo.getAvatar();
        BasicSimulation simulation = ((CapeHolder)entity).getSimulation();
        poseStack.method_22903();
        poseStack.method_22904(0.0, 0.0, 0.125);
        float x = simulation.getPoints().get(part).getLerpX(delta) - simulation.getPoints().get(0).getLerpX(delta);
        if (x > 0.0f) {
            x = 0.0f;
        }
        float y = simulation.getPoints().get(0).getLerpY(delta) - (float)part - simulation.getPoints().get(part).getLerpY(delta);
        float z = simulation.getPoints().get(0).getLerpZ(delta) - simulation.getPoints().get(part).getLerpZ(delta);
        float sidewaysRotationOffset = 0.0f;
        float partRotation = this.getRotation(delta, part, simulation);
        float height = 0.0f;
        float naturalWindSwing = this.getNatrualWindSwing(part, entity.method_5869());
        poseStack.method_22907((Quaternionfc)MathUtil.XP.rotationDegrees(6.0f + height + naturalWindSwing));
        poseStack.method_22907((Quaternionfc)MathUtil.ZP.rotationDegrees(sidewaysRotationOffset / 2.0f));
        poseStack.method_22907((Quaternionfc)MathUtil.YP.rotationDegrees(180.0f - sidewaysRotationOffset / 2.0f));
        poseStack.method_46416(-z / 16.0f, y / 16.0f, x / 16.0f);
        poseStack.method_22904(0.0, 0.03, -0.03);
        poseStack.method_46416(0.0f, (float)part * 1.0f / 16.0f, (float)(part * 0 / 16));
        poseStack.method_22907((Quaternionfc)MathUtil.XP.rotationDegrees(-partRotation));
        poseStack.method_46416(0.0f, (float)(-part) * 1.0f / 16.0f, (float)(-part * 0 / 16));
        poseStack.method_22904(0.0, -0.03, 0.03);
    }

    private float getRotation(float delta, int part, BasicSimulation simulation) {
        if (part == 15) {
            return this.getRotation(delta, part - 1, simulation);
        }
        return (float)this.getAngle(simulation.getPoints().get(part).getLerpedPos(delta), simulation.getPoints().get(part + 1).getLerpedPos(delta));
    }

    private double getAngle(Vector3 a, Vector3 b) {
        Vector3 angle = b.subtract(a);
        return Math.toDegrees(Math.atan2(angle.x, angle.y)) + 180.0;
    }

    private float getNatrualWindSwing(int part, boolean underwater) {
        long highlightedPart = System.currentTimeMillis() / (long)(underwater ? 9 : 3) % 360L;
        float relativePart = (float)(part + 1) / 16.0f;
        if (WaveyCapesBase.config.windMode == WindMode.WAVES) {
            return (float)(Math.sin(Math.toRadians(relativePart * 360.0f - (float)highlightedPart)) * 3.0);
        }
        return 0.0f;
    }

    private static void addBackVertex(class_4588 bufferBuilder, Matrix4f matrix, Matrix4f oldMatrix, float x1, float y1, float z1, float x2, float y2, float z2, int part, int light, float alpha) {
        float i;
        if (x1 < x2) {
            i = x1;
            x1 = x2;
            x2 = i;
        }
        if (y1 < y2) {
            i = y1;
            y1 = y2;
            y2 = i;
            Matrix4f k = matrix;
            matrix = oldMatrix;
            oldMatrix = k;
        }
        float minU = 0.015625f;
        float maxU = 0.171875f;
        float minV = 0.03125f;
        float maxV = 0.53125f;
        float deltaV = maxV - minV;
        float vPerPart = deltaV / 16.0f;
        maxV = minV + vPerPart * (float)(part + 1);
        Vector3 normalVec = CustomCapeRenderer.getNormalVec(oldMatrix, oldMatrix, matrix, new Vector3(x1, y2, z1), new Vector3(x2, y2, z1), new Vector3(x1, y1, z2), light == 0xF000F0);
        VertexConsumerUtil.addVertex((class_4588)bufferBuilder, (Matrix4f)oldMatrix, (float)x1, (float)y2, (float)z1, (float)maxU, (float)(minV += vPerPart * (float)part), (int)class_4608.field_21444, (int)light, (float)normalVec.x, (float)normalVec.y, (float)normalVec.z, (float)alpha);
        VertexConsumerUtil.addVertex((class_4588)bufferBuilder, (Matrix4f)oldMatrix, (float)x2, (float)y2, (float)z1, (float)minU, (float)minV, (int)class_4608.field_21444, (int)light, (float)normalVec.x, (float)normalVec.y, (float)normalVec.z, (float)alpha);
        VertexConsumerUtil.addVertex((class_4588)bufferBuilder, (Matrix4f)matrix, (float)x2, (float)y1, (float)z2, (float)minU, (float)maxV, (int)class_4608.field_21444, (int)light, (float)normalVec.x, (float)normalVec.y, (float)normalVec.z, (float)alpha);
        VertexConsumerUtil.addVertex((class_4588)bufferBuilder, (Matrix4f)matrix, (float)x1, (float)y1, (float)z2, (float)maxU, (float)maxV, (int)class_4608.field_21444, (int)light, (float)normalVec.x, (float)normalVec.y, (float)normalVec.z, (float)alpha);
    }

    private static void addFrontVertex(class_4588 bufferBuilder, Matrix4f matrix, Matrix4f oldMatrix, float x1, float y1, float z1, float x2, float y2, float z2, int part, int light, float alpha) {
        float i;
        if (x1 < x2) {
            i = x1;
            x1 = x2;
            x2 = i;
        }
        if (y1 < y2) {
            i = y1;
            y1 = y2;
            y2 = i;
            Matrix4f k = matrix;
            matrix = oldMatrix;
            oldMatrix = k;
        }
        float minU = 0.1875f;
        float maxU = 0.34375f;
        float minV = 0.03125f;
        float maxV = 0.53125f;
        float deltaV = maxV - minV;
        float vPerPart = deltaV / 16.0f;
        maxV = minV + vPerPart * (float)(part + 1);
        Vector3 normalVec = CustomCapeRenderer.getNormalVec(oldMatrix, oldMatrix, matrix, new Vector3(x1, y1, z1), new Vector3(x2, y1, z1), new Vector3(x1, y2, z2), light == 0xF000F0);
        VertexConsumerUtil.addVertex((class_4588)bufferBuilder, (Matrix4f)oldMatrix, (float)x1, (float)y1, (float)z1, (float)minU, (float)maxV, (int)class_4608.field_21444, (int)light, (float)normalVec.x, (float)normalVec.y, (float)normalVec.z, (float)alpha);
        VertexConsumerUtil.addVertex((class_4588)bufferBuilder, (Matrix4f)oldMatrix, (float)x2, (float)y1, (float)z1, (float)maxU, (float)maxV, (int)class_4608.field_21444, (int)light, (float)normalVec.x, (float)normalVec.y, (float)normalVec.z, (float)alpha);
        VertexConsumerUtil.addVertex((class_4588)bufferBuilder, (Matrix4f)matrix, (float)x2, (float)y2, (float)z2, (float)maxU, (float)(minV += vPerPart * (float)part), (int)class_4608.field_21444, (int)light, (float)normalVec.x, (float)normalVec.y, (float)normalVec.z, (float)alpha);
        VertexConsumerUtil.addVertex((class_4588)bufferBuilder, (Matrix4f)matrix, (float)x1, (float)y2, (float)z2, (float)minU, (float)minV, (int)class_4608.field_21444, (int)light, (float)normalVec.x, (float)normalVec.y, (float)normalVec.z, (float)alpha);
    }

    private static void addLeftVertex(class_4588 bufferBuilder, Matrix4f matrix, Matrix4f oldMatrix, float x1, float y1, float z1, float x2, float y2, float z2, int part, int light, float alpha) {
        float i;
        if (x1 < x2) {
            i = x1;
            x1 = x2;
            x2 = i;
        }
        if (y1 < y2) {
            i = y1;
            y1 = y2;
            y2 = i;
        }
        float minU = 0.0f;
        float maxU = 0.015625f;
        float minV = 0.03125f;
        float maxV = 0.53125f;
        float deltaV = maxV - minV;
        float vPerPart = deltaV / 16.0f;
        maxV = minV + vPerPart * (float)(part + 1);
        Vector3 normalVec = CustomCapeRenderer.getNormalVec(matrix, matrix, oldMatrix, new Vector3(x2, y1, z1), new Vector3(x2, y1, z2), new Vector3(x2, y2, z1), light == 0xF000F0);
        VertexConsumerUtil.addVertex((class_4588)bufferBuilder, (Matrix4f)matrix, (float)x2, (float)y1, (float)z1, (float)minU, (float)maxV, (int)class_4608.field_21444, (int)light, (float)normalVec.x, (float)normalVec.y, (float)normalVec.z, (float)alpha);
        VertexConsumerUtil.addVertex((class_4588)bufferBuilder, (Matrix4f)matrix, (float)x2, (float)y1, (float)z2, (float)maxU, (float)maxV, (int)class_4608.field_21444, (int)light, (float)normalVec.x, (float)normalVec.y, (float)normalVec.z, (float)alpha);
        VertexConsumerUtil.addVertex((class_4588)bufferBuilder, (Matrix4f)oldMatrix, (float)x2, (float)y2, (float)z2, (float)maxU, (float)(minV += vPerPart * (float)part), (int)class_4608.field_21444, (int)light, (float)normalVec.x, (float)normalVec.y, (float)normalVec.z, (float)alpha);
        VertexConsumerUtil.addVertex((class_4588)bufferBuilder, (Matrix4f)oldMatrix, (float)x2, (float)y2, (float)z1, (float)minU, (float)minV, (int)class_4608.field_21444, (int)light, (float)normalVec.x, (float)normalVec.y, (float)normalVec.z, (float)alpha);
    }

    private static void addRightVertex(class_4588 bufferBuilder, Matrix4f matrix, Matrix4f oldMatrix, float x1, float y1, float z1, float x2, float y2, float z2, int part, int light, float alpha) {
        float i;
        if (x1 < x2) {
            i = x1;
            x1 = x2;
            x2 = i;
        }
        if (y1 < y2) {
            i = y1;
            y1 = y2;
            y2 = i;
        }
        float minU = 0.171875f;
        float maxU = 0.1875f;
        float minV = 0.03125f;
        float maxV = 0.53125f;
        float deltaV = maxV - minV;
        float vPerPart = deltaV / 16.0f;
        maxV = minV + vPerPart * (float)(part + 1);
        Vector3 normalVec = CustomCapeRenderer.getNormalVec(matrix, matrix, oldMatrix, new Vector3(x2, y1, z2), new Vector3(x2, y1, z1), new Vector3(x2, y2, z2), light == 0xF000F0);
        VertexConsumerUtil.addVertex((class_4588)bufferBuilder, (Matrix4f)matrix, (float)x2, (float)y1, (float)z2, (float)minU, (float)maxV, (int)class_4608.field_21444, (int)light, (float)normalVec.x, (float)normalVec.y, (float)normalVec.z, (float)alpha);
        VertexConsumerUtil.addVertex((class_4588)bufferBuilder, (Matrix4f)matrix, (float)x2, (float)y1, (float)z1, (float)maxU, (float)maxV, (int)class_4608.field_21444, (int)light, (float)normalVec.x, (float)normalVec.y, (float)normalVec.z, (float)alpha);
        VertexConsumerUtil.addVertex((class_4588)bufferBuilder, (Matrix4f)oldMatrix, (float)x2, (float)y2, (float)z1, (float)maxU, (float)(minV += vPerPart * (float)part), (int)class_4608.field_21444, (int)light, (float)normalVec.x, (float)normalVec.y, (float)normalVec.z, (float)alpha);
        VertexConsumerUtil.addVertex((class_4588)bufferBuilder, (Matrix4f)oldMatrix, (float)x2, (float)y2, (float)z2, (float)minU, (float)minV, (int)class_4608.field_21444, (int)light, (float)normalVec.x, (float)normalVec.y, (float)normalVec.z, (float)alpha);
    }

    private static void addBottomVertex(class_4588 bufferBuilder, Matrix4f matrix, Matrix4f oldMatrix, float x1, float y1, float z1, float x2, float y2, float z2, int light, float alpha) {
        float i;
        if (x1 < x2) {
            i = x1;
            x1 = x2;
            x2 = i;
        }
        if (y1 < y2) {
            i = y1;
            y1 = y2;
            y2 = i;
        }
        float minU = 0.171875f;
        float maxU = 0.328125f;
        float minV = 0.0f;
        float maxV = 0.03125f;
        Vector3 normalVec = CustomCapeRenderer.getNormalVec(oldMatrix, oldMatrix, matrix, new Vector3(x1, y2, z2), new Vector3(x2, y2, z2), new Vector3(x1, y1, z1), light == 0xF000F0);
        VertexConsumerUtil.addVertex((class_4588)bufferBuilder, (Matrix4f)oldMatrix, (float)x1, (float)y2, (float)z2, (float)maxU, (float)minV, (int)class_4608.field_21444, (int)light, (float)normalVec.x, (float)normalVec.y, (float)normalVec.z, (float)alpha);
        VertexConsumerUtil.addVertex((class_4588)bufferBuilder, (Matrix4f)oldMatrix, (float)x2, (float)y2, (float)z2, (float)minU, (float)minV, (int)class_4608.field_21444, (int)light, (float)normalVec.x, (float)normalVec.y, (float)normalVec.z, (float)alpha);
        VertexConsumerUtil.addVertex((class_4588)bufferBuilder, (Matrix4f)matrix, (float)x2, (float)y1, (float)z1, (float)minU, (float)maxV, (int)class_4608.field_21444, (int)light, (float)normalVec.x, (float)normalVec.y, (float)normalVec.z, (float)alpha);
        VertexConsumerUtil.addVertex((class_4588)bufferBuilder, (Matrix4f)matrix, (float)x1, (float)y1, (float)z1, (float)maxU, (float)maxV, (int)class_4608.field_21444, (int)light, (float)normalVec.x, (float)normalVec.y, (float)normalVec.z, (float)alpha);
    }

    private static void addTopVertex(class_4588 bufferBuilder, Matrix4f matrix, Matrix4f oldMatrix, float x1, float y1, float z1, float x2, float y2, float z2, int light, float alpha) {
        float i;
        if (x1 < x2) {
            i = x1;
            x1 = x2;
            x2 = i;
        }
        if (y1 < y2) {
            i = y1;
            y1 = y2;
            y2 = i;
        }
        float minU = 0.015625f;
        float maxU = 0.171875f;
        float minV = 0.0f;
        float maxV = 0.03125f;
        Vector3 normalVec = CustomCapeRenderer.getNormalVec(oldMatrix, oldMatrix, matrix, new Vector3(x1, y2, z1), new Vector3(x2, y2, z1), new Vector3(x1, y1, z2), light == 0xF000F0);
        VertexConsumerUtil.addVertex((class_4588)bufferBuilder, (Matrix4f)oldMatrix, (float)x1, (float)y2, (float)z1, (float)maxU, (float)maxV, (int)class_4608.field_21444, (int)light, (float)normalVec.x, (float)normalVec.y, (float)normalVec.z, (float)alpha);
        VertexConsumerUtil.addVertex((class_4588)bufferBuilder, (Matrix4f)oldMatrix, (float)x2, (float)y2, (float)z1, (float)minU, (float)maxV, (int)class_4608.field_21444, (int)light, (float)normalVec.x, (float)normalVec.y, (float)normalVec.z, (float)alpha);
        VertexConsumerUtil.addVertex((class_4588)bufferBuilder, (Matrix4f)matrix, (float)x2, (float)y1, (float)z2, (float)minU, (float)minV, (int)class_4608.field_21444, (int)light, (float)normalVec.x, (float)normalVec.y, (float)normalVec.z, (float)alpha);
        VertexConsumerUtil.addVertex((class_4588)bufferBuilder, (Matrix4f)matrix, (float)x1, (float)y1, (float)z2, (float)maxU, (float)minV, (int)class_4608.field_21444, (int)light, (float)normalVec.x, (float)normalVec.y, (float)normalVec.z, (float)alpha);
    }

    private static Vector3 getNormalVec(Matrix4f matrix1, Matrix4f matrix2, Matrix4f matrix3, Vector3 vector1, Vector3 vector2, Vector3 vector3, boolean inverse) {
        Vector3 vector1Transformed = CustomCapeRenderer.transform(matrix1, new Vector4(vector1.x, vector1.y, vector1.z, 1.0f)).toVec3();
        Vector3 vector2Transformed = CustomCapeRenderer.transform(matrix2, new Vector4(vector2.x, vector2.y, vector2.z, 1.0f)).toVec3();
        Vector3 vector3Transformed = CustomCapeRenderer.transform(matrix3, new Vector4(vector3.x, vector3.y, vector3.z, 1.0f)).toVec3();
        vector2Transformed.subtract(vector1Transformed);
        vector3Transformed.subtract(vector1Transformed);
        vector2Transformed.cross(vector3Transformed);
        vector2Transformed.normalize();
        return inverse ? vector2Transformed.mul(-1.0f) : vector2Transformed;
    }

    private static Vector4 transform(Matrix4f matrix, Vector4 vector) {
        Vector4f vector4f = matrix.transform(new Vector4f(vector.x, vector.y, vector.z, vector.w));
        return new Vector4(vector4f.x, vector4f.y, vector4f.z, vector4f.w);
    }

    private CapeRenderer getCapeRenderer(PlayerWrapper capeRenderInfo) {
        for (ModSupport support : SupportManager.getSupportedMods()) {
            if (!support.shouldBeUsed(capeRenderInfo)) continue;
            return support.getRenderer();
        }
        if (capeRenderInfo.getCapeTexture() == null || !capeRenderInfo.isCapeVisible()) {
            return null;
        }
        return vanillaCape;
    }
}

