/*
 * Decompiled with CFR 0.152.
 */
package dev.tr7zw.waveycapes.support;

import com.mojang.blaze3d.vertex.VertexConsumer;
import dev.tr7zw.transition.mc.entitywrapper.PlayerWrapper;
import dev.tr7zw.waveycapes.CapeRenderer;
import dev.tr7zw.waveycapes.support.ModSupport;
import dev.tr7zw.waveycapes.versionless.ModBase;
import java.util.UUID;
import java.util.function.Function;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.entity.ItemRenderer;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Player;
import net.minecraftcapes.config.MinecraftCapesConfig;
import net.minecraftcapes.player.PlayerHandler;

public class MinecraftCapesSupport
implements ModSupport {
    private MinecraftCapesRenderer render = new MinecraftCapesRenderer();
    private Function<PlayerWrapper, PlayerHandler> getCape = null;

    private void init(PlayerWrapper test) {
        try {
            this.getCape = player -> {
                Player entity = player.getEntity();
                PlayerHandler.get((UUID)entity.getUUID()).getCapeLocation();
                return PlayerHandler.get((UUID)entity.getUUID());
            };
            this.getCape.apply(test);
            ModBase.LOGGER.info("Using 'get(UUID)' method for MinecraftCapes.");
            return;
        }
        catch (Throwable throwable) {
            this.getCape = player -> null;
            ModBase.LOGGER.info("Unable to find a method for MinecraftCapes.");
            return;
        }
    }

    @Override
    public boolean shouldBeUsed(PlayerWrapper capeRenderInfo) {
        PlayerHandler handler;
        if (!MinecraftCapesConfig.isCapeVisible()) {
            return false;
        }
        if (this.getCape == null) {
            this.init(capeRenderInfo);
        }
        return (handler = this.getCape.apply(capeRenderInfo)) != null && handler.getCapeLocation() != null;
    }

    @Override
    public CapeRenderer getRenderer() {
        return this.render;
    }

    @Override
    public boolean blockFeatureRenderer(Object feature) {
        return false;
    }

    private class MinecraftCapesRenderer
    implements CapeRenderer {
        private MinecraftCapesRenderer() {
        }

        @Override
        public VertexConsumer getVertexConsumer(MultiBufferSource multiBufferSource, PlayerWrapper capeRenderInfo) {
            PlayerHandler playerHandler = MinecraftCapesSupport.this.getCape.apply(capeRenderInfo);
            if (MinecraftCapesConfig.isCapeVisible() && playerHandler.getCapeLocation() != null) {
                return ItemRenderer.getArmorFoilBuffer((MultiBufferSource)multiBufferSource, (RenderType)RenderType.entityTranslucent((ResourceLocation)playerHandler.getCapeLocation()), (boolean)playerHandler.getHasCapeGlint());
            }
            return ItemRenderer.getArmorFoilBuffer((MultiBufferSource)multiBufferSource, (RenderType)RenderType.entityTranslucent((ResourceLocation)capeRenderInfo.getCapeTexture()), (boolean)false);
        }
    }
}

