/*
 * Decompiled with CFR 0.152.
 */
package dev.tr7zw.waveycapes;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import dev.tr7zw.transition.mc.MathUtil;
import dev.tr7zw.transition.mc.VertexConsumerUtil;
import dev.tr7zw.transition.mc.entitywrapper.PlayerWrapper;
import dev.tr7zw.waveycapes.CapeRenderer;
import dev.tr7zw.waveycapes.NMSUtil;
import dev.tr7zw.waveycapes.VanillaCapeRenderer;
import dev.tr7zw.waveycapes.WaveyCapesBase;
import dev.tr7zw.waveycapes.support.ModSupport;
import dev.tr7zw.waveycapes.support.SupportManager;
import dev.tr7zw.waveycapes.versionless.CapeHolder;
import dev.tr7zw.waveycapes.versionless.CapeMovement;
import dev.tr7zw.waveycapes.versionless.CapeStyle;
import dev.tr7zw.waveycapes.versionless.ModBase;
import dev.tr7zw.waveycapes.versionless.WindMode;
import dev.tr7zw.waveycapes.versionless.sim.BasicSimulation;
import dev.tr7zw.waveycapes.versionless.util.Vector3;
import dev.tr7zw.waveycapes.versionless.util.Vector4;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.player.AbstractClientPlayer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.player.Player;
import org.joml.Matrix4f;
import org.joml.Matrix4fc;
import org.joml.Vector4f;

public class CustomCapeRenderer {
    private static final int PART_COUNT = 16;
    private final ModelPart[] customCape = NMSUtil.buildCape(64, 64, x -> 0, y -> y);
    private static VanillaCapeRenderer vanillaCape = new VanillaCapeRenderer();

    public void render(PlayerWrapper capeRenderInfo, PoseStack poseStack, MultiBufferSource multiBufferSource, int packedLight, float delta) {
        CapeRenderer renderer = this.getCapeRenderer(capeRenderInfo);
        if (renderer == null) {
            return;
        }
        if (!this.prepareCape(capeRenderInfo)) {
            return;
        }
        VertexConsumer bufferBuilder = renderer.getVertexConsumer(multiBufferSource, capeRenderInfo);
        if (bufferBuilder == null) {
            return;
        }
        if (ModBase.config.capeStyle == CapeStyle.SMOOTH && renderer.vanillaUvValues()) {
            this.renderSmoothCape(poseStack, bufferBuilder, capeRenderInfo, delta, packedLight);
        } else {
            ModelPart[] parts = this.customCape;
            for (int part = 0; part < 16; ++part) {
                ModelPart model = parts[part];
                this.modifyPoseStack(poseStack, capeRenderInfo, delta, part);
                renderer.render(capeRenderInfo, part, model, poseStack, bufferBuilder, packedLight, OverlayTexture.f_118083_);
                poseStack.m_85849_();
            }
        }
    }

    private boolean prepareCape(PlayerWrapper capeRenderInfo) {
        CapeHolder holder = (CapeHolder)capeRenderInfo.getEntity();
        if (holder == null) {
            return false;
        }
        holder.updateSimulation(16);
        return true;
    }

    private void renderSmoothCape(PoseStack poseStack, VertexConsumer bufferBuilder, PlayerWrapper capeRenderInfo, float delta, int light) {
        RenderSystem.enableBlend();
        RenderSystem.defaultBlendFunc();
        float alpha = SupportManager.getAlphaSupplier().get().floatValue();
        Matrix4f oldPositionMatrix = null;
        for (int part = 0; part < 16; ++part) {
            this.modifyPoseStack(poseStack, capeRenderInfo, delta, part);
            if (oldPositionMatrix == null) {
                oldPositionMatrix = poseStack.m_85850_().m_252922_();
            }
            float capeWidth = 0.625f;
            float capeHeight = 1.0f;
            float capeDepth = 0.0625f;
            if (part == 0) {
                CustomCapeRenderer.addTopVertex(bufferBuilder, poseStack.m_85850_().m_252922_(), oldPositionMatrix, capeWidth / 2.0f, 0.0f, 0.0f, -capeWidth / 2.0f, 0.0f, -capeDepth, light, alpha);
            }
            if (part == 15) {
                CustomCapeRenderer.addBottomVertex(bufferBuilder, poseStack.m_85850_().m_252922_(), poseStack.m_85850_().m_252922_(), capeWidth / 2.0f, (float)(part + 1) * (capeHeight / 16.0f), 0.0f, -capeWidth / 2.0f, (float)(part + 1) * (capeHeight / 16.0f), -capeDepth, light, alpha);
            }
            CustomCapeRenderer.addLeftVertex(bufferBuilder, poseStack.m_85850_().m_252922_(), oldPositionMatrix, -capeWidth / 2.0f, (float)(part + 1) * (capeHeight / 16.0f), 0.0f, -capeWidth / 2.0f, (float)part * (capeHeight / 16.0f), -capeDepth, part, light, alpha);
            CustomCapeRenderer.addRightVertex(bufferBuilder, poseStack.m_85850_().m_252922_(), oldPositionMatrix, capeWidth / 2.0f, (float)(part + 1) * (capeHeight / 16.0f), 0.0f, capeWidth / 2.0f, (float)part * (capeHeight / 16.0f), -capeDepth, part, light, alpha);
            CustomCapeRenderer.addBackVertex(bufferBuilder, poseStack.m_85850_().m_252922_(), oldPositionMatrix, capeWidth / 2.0f, (float)(part + 1) * (capeHeight / 16.0f), -capeDepth, -capeWidth / 2.0f, (float)part * (capeHeight / 16.0f), -capeDepth, part, light, alpha);
            CustomCapeRenderer.addFrontVertex(bufferBuilder, oldPositionMatrix, poseStack.m_85850_().m_252922_(), capeWidth / 2.0f, (float)(part + 1) * (capeHeight / 16.0f), 0.0f, -capeWidth / 2.0f, (float)part * (capeHeight / 16.0f), 0.0f, part, light, alpha);
            oldPositionMatrix = new Matrix4f((Matrix4fc)poseStack.m_85850_().m_252922_());
            poseStack.m_85849_();
        }
    }

    private void modifyPoseStack(PoseStack poseStack, PlayerWrapper capeRenderInfo, float h, int part) {
        if (WaveyCapesBase.config.capeMovement != CapeMovement.VANILLA) {
            this.modifyPoseStackSimulation(poseStack, capeRenderInfo, h, part);
            return;
        }
        this.modifyPoseStackVanilla(poseStack, (AbstractClientPlayer)capeRenderInfo.getEntity(), h, part);
    }

    private void modifyPoseStackSimulation(PoseStack poseStack, PlayerWrapper capeRenderInfo, float delta, int part) {
        Player entity = capeRenderInfo.getEntity();
        BasicSimulation simulation = ((CapeHolder)entity).getSimulation();
        poseStack.m_85836_();
        poseStack.m_85837_(0.0, 0.0, 0.125);
        float x = simulation.getPoints().get(part).getLerpX(delta) - simulation.getPoints().get(0).getLerpX(delta);
        if (x > 0.0f) {
            x = 0.0f;
        }
        float y = simulation.getPoints().get(0).getLerpY(delta) - (float)part - simulation.getPoints().get(part).getLerpY(delta);
        float z = simulation.getPoints().get(0).getLerpZ(delta) - simulation.getPoints().get(part).getLerpZ(delta);
        float sidewaysRotationOffset = 0.0f;
        float partRotation = this.getRotation(delta, part, simulation);
        float height = 0.0f;
        float naturalWindSwing = this.getNatrualWindSwing(part, entity.m_5842_());
        poseStack.m_252781_(MathUtil.XP.m_252977_(6.0f + height + naturalWindSwing));
        poseStack.m_252781_(MathUtil.ZP.m_252977_(sidewaysRotationOffset / 2.0f));
        poseStack.m_252781_(MathUtil.YP.m_252977_(180.0f - sidewaysRotationOffset / 2.0f));
        poseStack.m_252880_(-z / 16.0f, y / 16.0f, x / 16.0f);
        poseStack.m_85837_(0.0, 0.03, -0.03);
        poseStack.m_252880_(0.0f, (float)part * 1.0f / 16.0f, (float)(part * 0 / 16));
        poseStack.m_252781_(MathUtil.XP.m_252977_(-partRotation));
        poseStack.m_252880_(0.0f, (float)(-part) * 1.0f / 16.0f, (float)(-part * 0 / 16));
        poseStack.m_85837_(0.0, -0.03, 0.03);
    }

    private float getRotation(float delta, int part, BasicSimulation simulation) {
        if (part == 15) {
            return this.getRotation(delta, part - 1, simulation);
        }
        return (float)this.getAngle(simulation.getPoints().get(part).getLerpedPos(delta), simulation.getPoints().get(part + 1).getLerpedPos(delta));
    }

    private double getAngle(Vector3 a, Vector3 b) {
        Vector3 angle = b.subtract(a);
        return Math.toDegrees(Math.atan2(angle.x, angle.y)) + 180.0;
    }

    private void modifyPoseStackVanilla(PoseStack poseStack, AbstractClientPlayer abstractClientPlayer, float h, int part) {
        poseStack.m_85836_();
        poseStack.m_85837_(0.0, 0.0, 0.125);
        double d = Mth.m_14139_((double)h, (double)abstractClientPlayer.f_36102_, (double)abstractClientPlayer.f_36105_) - Mth.m_14139_((double)h, (double)abstractClientPlayer.f_19854_, (double)abstractClientPlayer.m_20185_());
        double e = Mth.m_14139_((double)h, (double)abstractClientPlayer.f_36103_, (double)abstractClientPlayer.f_36106_) - Mth.m_14139_((double)h, (double)abstractClientPlayer.f_19855_, (double)abstractClientPlayer.m_20186_());
        double m = Mth.m_14139_((double)h, (double)abstractClientPlayer.f_36104_, (double)abstractClientPlayer.f_36075_) - Mth.m_14139_((double)h, (double)abstractClientPlayer.f_19856_, (double)abstractClientPlayer.m_20189_());
        float n = abstractClientPlayer.f_20884_ + abstractClientPlayer.f_20883_ - abstractClientPlayer.f_20884_;
        double o = Mth.m_14031_((float)(n * ((float)Math.PI / 180)));
        double p = -Mth.m_14089_((float)(n * ((float)Math.PI / 180)));
        float height = (float)e * 10.0f;
        height = Mth.m_14036_((float)height, (float)-6.0f, (float)32.0f);
        float swing = (float)(d * o + m * p) * CustomCapeRenderer.easeOutSine(0.0625f * (float)part) * 100.0f;
        swing = Mth.m_14036_((float)swing, (float)0.0f, (float)(150.0f * CustomCapeRenderer.easeOutSine(0.0625f * (float)part)));
        float sidewaysRotationOffset = (float)(d * p - m * o) * 100.0f;
        sidewaysRotationOffset = Mth.m_14036_((float)sidewaysRotationOffset, (float)-20.0f, (float)20.0f);
        float t = Mth.m_14179_((float)h, (float)abstractClientPlayer.f_36099_, (float)abstractClientPlayer.f_36100_);
        float naturalWindSwing = this.getNatrualWindSwing(part, abstractClientPlayer.m_5842_());
        poseStack.m_252781_(MathUtil.XP.m_252977_(6.0f + swing / 2.0f + (height += Mth.m_14031_((float)(Mth.m_14179_((float)h, (float)abstractClientPlayer.f_19867_, (float)abstractClientPlayer.f_19787_) * 6.0f)) * 32.0f * t) + naturalWindSwing));
        poseStack.m_252781_(MathUtil.ZP.m_252977_(sidewaysRotationOffset / 2.0f));
        poseStack.m_252781_(MathUtil.YP.m_252977_(180.0f - sidewaysRotationOffset / 2.0f));
    }

    private static float easeOutSine(float x) {
        return Mth.m_14031_((float)((float)((double)x * Math.PI / 2.0)));
    }

    private float getNatrualWindSwing(int part, boolean underwater) {
        long highlightedPart = System.currentTimeMillis() / (long)(underwater ? 9 : 3) % 360L;
        float relativePart = (float)(part + 1) / 16.0f;
        if (WaveyCapesBase.config.windMode == WindMode.WAVES) {
            return (float)(Math.sin(Math.toRadians(relativePart * 360.0f - (float)highlightedPart)) * 3.0);
        }
        return 0.0f;
    }

    private static void addBackVertex(VertexConsumer bufferBuilder, Matrix4f matrix, Matrix4f oldMatrix, float x1, float y1, float z1, float x2, float y2, float z2, int part, int light, float alpha) {
        float i;
        if (x1 < x2) {
            i = x1;
            x1 = x2;
            x2 = i;
        }
        if (y1 < y2) {
            i = y1;
            y1 = y2;
            y2 = i;
            Matrix4f k = matrix;
            matrix = oldMatrix;
            oldMatrix = k;
        }
        float minU = 0.015625f;
        float maxU = 0.171875f;
        float minV = 0.03125f;
        float maxV = 0.53125f;
        float deltaV = maxV - minV;
        float vPerPart = deltaV / 16.0f;
        maxV = minV + vPerPart * (float)(part + 1);
        Vector3 normalVec = CustomCapeRenderer.getNormalVec(oldMatrix, oldMatrix, matrix, new Vector3(x1, y2, z1), new Vector3(x2, y2, z1), new Vector3(x1, y1, z2), light == 0xF000F0);
        VertexConsumerUtil.addVertex((VertexConsumer)bufferBuilder, (Matrix4f)oldMatrix, (float)x1, (float)y2, (float)z1, (float)maxU, (float)(minV += vPerPart * (float)part), (int)OverlayTexture.f_118083_, (int)light, (float)normalVec.x, (float)normalVec.y, (float)normalVec.z, (float)alpha);
        VertexConsumerUtil.addVertex((VertexConsumer)bufferBuilder, (Matrix4f)oldMatrix, (float)x2, (float)y2, (float)z1, (float)minU, (float)minV, (int)OverlayTexture.f_118083_, (int)light, (float)normalVec.x, (float)normalVec.y, (float)normalVec.z, (float)alpha);
        VertexConsumerUtil.addVertex((VertexConsumer)bufferBuilder, (Matrix4f)matrix, (float)x2, (float)y1, (float)z2, (float)minU, (float)maxV, (int)OverlayTexture.f_118083_, (int)light, (float)normalVec.x, (float)normalVec.y, (float)normalVec.z, (float)alpha);
        VertexConsumerUtil.addVertex((VertexConsumer)bufferBuilder, (Matrix4f)matrix, (float)x1, (float)y1, (float)z2, (float)maxU, (float)maxV, (int)OverlayTexture.f_118083_, (int)light, (float)normalVec.x, (float)normalVec.y, (float)normalVec.z, (float)alpha);
    }

    private static void addFrontVertex(VertexConsumer bufferBuilder, Matrix4f matrix, Matrix4f oldMatrix, float x1, float y1, float z1, float x2, float y2, float z2, int part, int light, float alpha) {
        float i;
        if (x1 < x2) {
            i = x1;
            x1 = x2;
            x2 = i;
        }
        if (y1 < y2) {
            i = y1;
            y1 = y2;
            y2 = i;
            Matrix4f k = matrix;
            matrix = oldMatrix;
            oldMatrix = k;
        }
        float minU = 0.1875f;
        float maxU = 0.34375f;
        float minV = 0.03125f;
        float maxV = 0.53125f;
        float deltaV = maxV - minV;
        float vPerPart = deltaV / 16.0f;
        maxV = minV + vPerPart * (float)(part + 1);
        Vector3 normalVec = CustomCapeRenderer.getNormalVec(oldMatrix, oldMatrix, matrix, new Vector3(x1, y1, z1), new Vector3(x2, y1, z1), new Vector3(x1, y2, z2), light == 0xF000F0);
        VertexConsumerUtil.addVertex((VertexConsumer)bufferBuilder, (Matrix4f)oldMatrix, (float)x1, (float)y1, (float)z1, (float)minU, (float)maxV, (int)OverlayTexture.f_118083_, (int)light, (float)normalVec.x, (float)normalVec.y, (float)normalVec.z, (float)alpha);
        VertexConsumerUtil.addVertex((VertexConsumer)bufferBuilder, (Matrix4f)oldMatrix, (float)x2, (float)y1, (float)z1, (float)maxU, (float)maxV, (int)OverlayTexture.f_118083_, (int)light, (float)normalVec.x, (float)normalVec.y, (float)normalVec.z, (float)alpha);
        VertexConsumerUtil.addVertex((VertexConsumer)bufferBuilder, (Matrix4f)matrix, (float)x2, (float)y2, (float)z2, (float)maxU, (float)(minV += vPerPart * (float)part), (int)OverlayTexture.f_118083_, (int)light, (float)normalVec.x, (float)normalVec.y, (float)normalVec.z, (float)alpha);
        VertexConsumerUtil.addVertex((VertexConsumer)bufferBuilder, (Matrix4f)matrix, (float)x1, (float)y2, (float)z2, (float)minU, (float)minV, (int)OverlayTexture.f_118083_, (int)light, (float)normalVec.x, (float)normalVec.y, (float)normalVec.z, (float)alpha);
    }

    private static void addLeftVertex(VertexConsumer bufferBuilder, Matrix4f matrix, Matrix4f oldMatrix, float x1, float y1, float z1, float x2, float y2, float z2, int part, int light, float alpha) {
        float i;
        if (x1 < x2) {
            i = x1;
            x1 = x2;
            x2 = i;
        }
        if (y1 < y2) {
            i = y1;
            y1 = y2;
            y2 = i;
        }
        float minU = 0.0f;
        float maxU = 0.015625f;
        float minV = 0.03125f;
        float maxV = 0.53125f;
        float deltaV = maxV - minV;
        float vPerPart = deltaV / 16.0f;
        maxV = minV + vPerPart * (float)(part + 1);
        Vector3 normalVec = CustomCapeRenderer.getNormalVec(matrix, matrix, oldMatrix, new Vector3(x2, y1, z1), new Vector3(x2, y1, z2), new Vector3(x2, y2, z1), light == 0xF000F0);
        VertexConsumerUtil.addVertex((VertexConsumer)bufferBuilder, (Matrix4f)matrix, (float)x2, (float)y1, (float)z1, (float)minU, (float)maxV, (int)OverlayTexture.f_118083_, (int)light, (float)normalVec.x, (float)normalVec.y, (float)normalVec.z, (float)alpha);
        VertexConsumerUtil.addVertex((VertexConsumer)bufferBuilder, (Matrix4f)matrix, (float)x2, (float)y1, (float)z2, (float)maxU, (float)maxV, (int)OverlayTexture.f_118083_, (int)light, (float)normalVec.x, (float)normalVec.y, (float)normalVec.z, (float)alpha);
        VertexConsumerUtil.addVertex((VertexConsumer)bufferBuilder, (Matrix4f)oldMatrix, (float)x2, (float)y2, (float)z2, (float)maxU, (float)(minV += vPerPart * (float)part), (int)OverlayTexture.f_118083_, (int)light, (float)normalVec.x, (float)normalVec.y, (float)normalVec.z, (float)alpha);
        VertexConsumerUtil.addVertex((VertexConsumer)bufferBuilder, (Matrix4f)oldMatrix, (float)x2, (float)y2, (float)z1, (float)minU, (float)minV, (int)OverlayTexture.f_118083_, (int)light, (float)normalVec.x, (float)normalVec.y, (float)normalVec.z, (float)alpha);
    }

    private static void addRightVertex(VertexConsumer bufferBuilder, Matrix4f matrix, Matrix4f oldMatrix, float x1, float y1, float z1, float x2, float y2, float z2, int part, int light, float alpha) {
        float i;
        if (x1 < x2) {
            i = x1;
            x1 = x2;
            x2 = i;
        }
        if (y1 < y2) {
            i = y1;
            y1 = y2;
            y2 = i;
        }
        float minU = 0.171875f;
        float maxU = 0.1875f;
        float minV = 0.03125f;
        float maxV = 0.53125f;
        float deltaV = maxV - minV;
        float vPerPart = deltaV / 16.0f;
        maxV = minV + vPerPart * (float)(part + 1);
        Vector3 normalVec = CustomCapeRenderer.getNormalVec(matrix, matrix, oldMatrix, new Vector3(x2, y1, z2), new Vector3(x2, y1, z1), new Vector3(x2, y2, z2), light == 0xF000F0);
        VertexConsumerUtil.addVertex((VertexConsumer)bufferBuilder, (Matrix4f)matrix, (float)x2, (float)y1, (float)z2, (float)minU, (float)maxV, (int)OverlayTexture.f_118083_, (int)light, (float)normalVec.x, (float)normalVec.y, (float)normalVec.z, (float)alpha);
        VertexConsumerUtil.addVertex((VertexConsumer)bufferBuilder, (Matrix4f)matrix, (float)x2, (float)y1, (float)z1, (float)maxU, (float)maxV, (int)OverlayTexture.f_118083_, (int)light, (float)normalVec.x, (float)normalVec.y, (float)normalVec.z, (float)alpha);
        VertexConsumerUtil.addVertex((VertexConsumer)bufferBuilder, (Matrix4f)oldMatrix, (float)x2, (float)y2, (float)z1, (float)maxU, (float)(minV += vPerPart * (float)part), (int)OverlayTexture.f_118083_, (int)light, (float)normalVec.x, (float)normalVec.y, (float)normalVec.z, (float)alpha);
        VertexConsumerUtil.addVertex((VertexConsumer)bufferBuilder, (Matrix4f)oldMatrix, (float)x2, (float)y2, (float)z2, (float)minU, (float)minV, (int)OverlayTexture.f_118083_, (int)light, (float)normalVec.x, (float)normalVec.y, (float)normalVec.z, (float)alpha);
    }

    private static void addBottomVertex(VertexConsumer bufferBuilder, Matrix4f matrix, Matrix4f oldMatrix, float x1, float y1, float z1, float x2, float y2, float z2, int light, float alpha) {
        float i;
        if (x1 < x2) {
            i = x1;
            x1 = x2;
            x2 = i;
        }
        if (y1 < y2) {
            i = y1;
            y1 = y2;
            y2 = i;
        }
        float minU = 0.171875f;
        float maxU = 0.328125f;
        float minV = 0.0f;
        float maxV = 0.03125f;
        Vector3 normalVec = CustomCapeRenderer.getNormalVec(oldMatrix, oldMatrix, matrix, new Vector3(x1, y2, z2), new Vector3(x2, y2, z2), new Vector3(x1, y1, z1), light == 0xF000F0);
        VertexConsumerUtil.addVertex((VertexConsumer)bufferBuilder, (Matrix4f)oldMatrix, (float)x1, (float)y2, (float)z2, (float)maxU, (float)minV, (int)OverlayTexture.f_118083_, (int)light, (float)normalVec.x, (float)normalVec.y, (float)normalVec.z, (float)alpha);
        VertexConsumerUtil.addVertex((VertexConsumer)bufferBuilder, (Matrix4f)oldMatrix, (float)x2, (float)y2, (float)z2, (float)minU, (float)minV, (int)OverlayTexture.f_118083_, (int)light, (float)normalVec.x, (float)normalVec.y, (float)normalVec.z, (float)alpha);
        VertexConsumerUtil.addVertex((VertexConsumer)bufferBuilder, (Matrix4f)matrix, (float)x2, (float)y1, (float)z1, (float)minU, (float)maxV, (int)OverlayTexture.f_118083_, (int)light, (float)normalVec.x, (float)normalVec.y, (float)normalVec.z, (float)alpha);
        VertexConsumerUtil.addVertex((VertexConsumer)bufferBuilder, (Matrix4f)matrix, (float)x1, (float)y1, (float)z1, (float)maxU, (float)maxV, (int)OverlayTexture.f_118083_, (int)light, (float)normalVec.x, (float)normalVec.y, (float)normalVec.z, (float)alpha);
    }

    private static void addTopVertex(VertexConsumer bufferBuilder, Matrix4f matrix, Matrix4f oldMatrix, float x1, float y1, float z1, float x2, float y2, float z2, int light, float alpha) {
        float i;
        if (x1 < x2) {
            i = x1;
            x1 = x2;
            x2 = i;
        }
        if (y1 < y2) {
            i = y1;
            y1 = y2;
            y2 = i;
        }
        float minU = 0.015625f;
        float maxU = 0.171875f;
        float minV = 0.0f;
        float maxV = 0.03125f;
        Vector3 normalVec = CustomCapeRenderer.getNormalVec(oldMatrix, oldMatrix, matrix, new Vector3(x1, y2, z1), new Vector3(x2, y2, z1), new Vector3(x1, y1, z2), light == 0xF000F0);
        VertexConsumerUtil.addVertex((VertexConsumer)bufferBuilder, (Matrix4f)oldMatrix, (float)x1, (float)y2, (float)z1, (float)maxU, (float)maxV, (int)OverlayTexture.f_118083_, (int)light, (float)normalVec.x, (float)normalVec.y, (float)normalVec.z, (float)alpha);
        VertexConsumerUtil.addVertex((VertexConsumer)bufferBuilder, (Matrix4f)oldMatrix, (float)x2, (float)y2, (float)z1, (float)minU, (float)maxV, (int)OverlayTexture.f_118083_, (int)light, (float)normalVec.x, (float)normalVec.y, (float)normalVec.z, (float)alpha);
        VertexConsumerUtil.addVertex((VertexConsumer)bufferBuilder, (Matrix4f)matrix, (float)x2, (float)y1, (float)z2, (float)minU, (float)minV, (int)OverlayTexture.f_118083_, (int)light, (float)normalVec.x, (float)normalVec.y, (float)normalVec.z, (float)alpha);
        VertexConsumerUtil.addVertex((VertexConsumer)bufferBuilder, (Matrix4f)matrix, (float)x1, (float)y1, (float)z2, (float)maxU, (float)minV, (int)OverlayTexture.f_118083_, (int)light, (float)normalVec.x, (float)normalVec.y, (float)normalVec.z, (float)alpha);
    }

    private static Vector3 getNormalVec(Matrix4f matrix1, Matrix4f matrix2, Matrix4f matrix3, Vector3 vector1, Vector3 vector2, Vector3 vector3, boolean inverse) {
        Vector3 vector1Transformed = CustomCapeRenderer.transform(matrix1, new Vector4(vector1.x, vector1.y, vector1.z, 1.0f)).toVec3();
        Vector3 vector2Transformed = CustomCapeRenderer.transform(matrix2, new Vector4(vector2.x, vector2.y, vector2.z, 1.0f)).toVec3();
        Vector3 vector3Transformed = CustomCapeRenderer.transform(matrix3, new Vector4(vector3.x, vector3.y, vector3.z, 1.0f)).toVec3();
        vector2Transformed.subtract(vector1Transformed);
        vector3Transformed.subtract(vector1Transformed);
        vector2Transformed.cross(vector3Transformed);
        vector2Transformed.normalize();
        return inverse ? vector2Transformed.mul(-1.0f) : vector2Transformed;
    }

    private static Vector4 transform(Matrix4f matrix, Vector4 vector) {
        Vector4f vector4f = matrix.transform(new Vector4f(vector.x, vector.y, vector.z, vector.w));
        return new Vector4(vector4f.x, vector4f.y, vector4f.z, vector4f.w);
    }

    private CapeRenderer getCapeRenderer(PlayerWrapper capeRenderInfo) {
        for (ModSupport support : SupportManager.getSupportedMods()) {
            if (!support.shouldBeUsed(capeRenderInfo)) continue;
            return support.getRenderer();
        }
        if (capeRenderInfo.getCapeTexture() == null || !capeRenderInfo.isCapeVisible()) {
            return null;
        }
        return vanillaCape;
    }
}

