/*
 * Decompiled with CFR 0.152.
 */
package dev.tr7zw.waveycapes;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Matrix4f;
import com.mojang.math.Vector4f;
import dev.tr7zw.transition.mc.MathUtil;
import dev.tr7zw.transition.mc.VertexConsumerUtil;
import dev.tr7zw.transition.mc.entitywrapper.PlayerWrapper;
import dev.tr7zw.waveycapes.CapeRenderer;
import dev.tr7zw.waveycapes.NMSUtil;
import dev.tr7zw.waveycapes.VanillaCapeRenderer;
import dev.tr7zw.waveycapes.WaveyCapesBase;
import dev.tr7zw.waveycapes.support.ModSupport;
import dev.tr7zw.waveycapes.support.SupportManager;
import dev.tr7zw.waveycapes.versionless.CapeHolder;
import dev.tr7zw.waveycapes.versionless.CapeMovement;
import dev.tr7zw.waveycapes.versionless.CapeStyle;
import dev.tr7zw.waveycapes.versionless.ModBase;
import dev.tr7zw.waveycapes.versionless.WindMode;
import dev.tr7zw.waveycapes.versionless.sim.BasicSimulation;
import dev.tr7zw.waveycapes.versionless.util.Vector3;
import dev.tr7zw.waveycapes.versionless.util.Vector4;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.player.AbstractClientPlayer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.player.Player;

public class CustomCapeRenderer {
    private static final int PART_COUNT = 16;
    private final ModelPart[] customCape = NMSUtil.buildCape(64, 64, x -> 0, y -> y);
    private static final float CAPE_WIDTH = 0.625f;
    private static final float CAPE_HEIGHT = 1.0f;
    private static final float CAPE_DEPTH = 0.0625f;
    private static VanillaCapeRenderer vanillaCape = new VanillaCapeRenderer();

    public void render(PlayerWrapper capeRenderInfo, PoseStack poseStack, MultiBufferSource multiBufferSource, int packedLight, float delta) {
        CapeRenderer renderer = this.getCapeRenderer(capeRenderInfo);
        if (renderer == null) {
            return;
        }
        if (!this.prepareCape(capeRenderInfo)) {
            return;
        }
        VertexConsumer bufferBuilder = renderer.getVertexConsumer(multiBufferSource, capeRenderInfo);
        if (bufferBuilder == null) {
            return;
        }
        if (ModBase.config.capeStyle == CapeStyle.SMOOTH && renderer.vanillaUvValues()) {
            this.renderSmoothCape(poseStack, bufferBuilder, capeRenderInfo, delta, packedLight);
        } else {
            ModelPart[] parts = this.customCape;
            for (int part = 0; part < 16; ++part) {
                ModelPart model = parts[part];
                this.modifyPoseStack(poseStack, capeRenderInfo, delta, part);
                renderer.render(capeRenderInfo, part, model, poseStack, bufferBuilder, packedLight, OverlayTexture.f_118083_);
                poseStack.m_85849_();
            }
        }
    }

    private boolean prepareCape(PlayerWrapper capeRenderInfo) {
        CapeHolder holder = (CapeHolder)capeRenderInfo.getEntity();
        if (holder == null) {
            return false;
        }
        holder.updateSimulation(16);
        return true;
    }

    private void renderSmoothCape(PoseStack poseStack, VertexConsumer bufferBuilder, PlayerWrapper capeRenderInfo, float delta, int light) {
        int part;
        RenderSystem.m_69478_();
        RenderSystem.m_69453_();
        float alpha = SupportManager.getAlphaSupplier().get().floatValue();
        Matrix4f[] positionMatrices = new Matrix4f[16];
        Vector3[] frontNormalVecs = new Vector3[16];
        Vector3[] backNormalVecs = new Vector3[16];
        for (part = 0; part < 16; ++part) {
            this.modifyPoseStack(poseStack, capeRenderInfo, delta, part);
            positionMatrices[part] = new Matrix4f(poseStack.m_85850_().m_85861_());
            frontNormalVecs[part] = CustomCapeRenderer.getNormalVec(positionMatrices[Math.max(part - 1, 0)], positionMatrices[Math.max(part - 1, 0)], positionMatrices[part], new Vector3(0.3125f, (float)part * 0.0625f, -0.0625f), new Vector3(-0.3125f, (float)part * 0.0625f, -0.0625f), new Vector3(0.3125f, (float)(part + 1) * 0.0625f, -0.0625f), light == 0xF000F0);
            backNormalVecs[part] = CustomCapeRenderer.getNormalVec(positionMatrices[Math.max(part - 1, 0)], positionMatrices[Math.max(part - 1, 0)], positionMatrices[part], new Vector3(0.3125f, (float)(part + 1) * 0.0625f, 0.0f), new Vector3(-0.3125f, (float)(part + 1) * 0.0625f, 0.0f), new Vector3(0.3125f, (float)part * 0.0625f, 0.0f), light == 0xF000F0);
            poseStack.m_85849_();
        }
        for (part = 0; part < 16; ++part) {
            Vector3 normalVec;
            float maxV;
            float minV;
            float maxU;
            float minU;
            if (part == 0) {
                minU = 0.015625f;
                maxU = 0.171875f;
                minV = 0.0f;
                maxV = 0.03125f;
                normalVec = CustomCapeRenderer.getNormalVec(positionMatrices[0], positionMatrices[0], positionMatrices[0], new Vector3(0.3125f, 0.0f, 0.0f), new Vector3(-0.3125f, 0.0f, 0.0f), new Vector3(0.3125f, 0.0f, 0.0625f), light == 0xF000F0);
                VertexConsumerUtil.addVertex((VertexConsumer)bufferBuilder, (Matrix4f)positionMatrices[0], (float)0.3125f, (float)0.0f, (float)0.0f, (float)maxU, (float)maxV, (int)OverlayTexture.f_118083_, (int)light, (float)normalVec.x, (float)normalVec.y, (float)normalVec.z, (float)alpha);
                VertexConsumerUtil.addVertex((VertexConsumer)bufferBuilder, (Matrix4f)positionMatrices[0], (float)-0.3125f, (float)0.0f, (float)0.0f, (float)minU, (float)maxV, (int)OverlayTexture.f_118083_, (int)light, (float)normalVec.x, (float)normalVec.y, (float)normalVec.z, (float)alpha);
                VertexConsumerUtil.addVertex((VertexConsumer)bufferBuilder, (Matrix4f)positionMatrices[0], (float)-0.3125f, (float)0.0f, (float)-0.0625f, (float)minU, (float)minV, (int)OverlayTexture.f_118083_, (int)light, (float)normalVec.x, (float)normalVec.y, (float)normalVec.z, (float)alpha);
                VertexConsumerUtil.addVertex((VertexConsumer)bufferBuilder, (Matrix4f)positionMatrices[0], (float)0.3125f, (float)0.0f, (float)-0.0625f, (float)maxU, (float)minV, (int)OverlayTexture.f_118083_, (int)light, (float)normalVec.x, (float)normalVec.y, (float)normalVec.z, (float)alpha);
            }
            if (part == 15) {
                minU = 0.171875f;
                maxU = 0.328125f;
                minV = 0.0f;
                maxV = 0.03125f;
                normalVec = CustomCapeRenderer.getNormalVec(positionMatrices[part], positionMatrices[part], positionMatrices[part], new Vector3(0.3125f, 1.0f, -0.0625f), new Vector3(-0.3125f, 1.0f, -0.0625f), new Vector3(0.3125f, 1.0f, 0.0f), light == 0xF000F0);
                VertexConsumerUtil.addVertex((VertexConsumer)bufferBuilder, (Matrix4f)positionMatrices[part], (float)0.3125f, (float)1.0f, (float)-0.0625f, (float)maxU, (float)minV, (int)OverlayTexture.f_118083_, (int)light, (float)normalVec.x, (float)normalVec.y, (float)normalVec.z, (float)alpha);
                VertexConsumerUtil.addVertex((VertexConsumer)bufferBuilder, (Matrix4f)positionMatrices[part], (float)-0.3125f, (float)1.0f, (float)-0.0625f, (float)minU, (float)minV, (int)OverlayTexture.f_118083_, (int)light, (float)normalVec.x, (float)normalVec.y, (float)normalVec.z, (float)alpha);
                VertexConsumerUtil.addVertex((VertexConsumer)bufferBuilder, (Matrix4f)positionMatrices[part], (float)-0.3125f, (float)1.0f, (float)0.0f, (float)minU, (float)maxV, (int)OverlayTexture.f_118083_, (int)light, (float)normalVec.x, (float)normalVec.y, (float)normalVec.z, (float)alpha);
                VertexConsumerUtil.addVertex((VertexConsumer)bufferBuilder, (Matrix4f)positionMatrices[part], (float)0.3125f, (float)1.0f, (float)0.0f, (float)maxU, (float)maxV, (int)OverlayTexture.f_118083_, (int)light, (float)normalVec.x, (float)normalVec.y, (float)normalVec.z, (float)alpha);
            }
            minU = 0.0f;
            maxU = 0.015625f;
            minV = 0.03125f * (float)(part + 1);
            maxV = minV + 0.03125f;
            normalVec = CustomCapeRenderer.getNormalVec(positionMatrices[part], positionMatrices[part], positionMatrices[Math.max(part - 1, 0)], new Vector3(-0.3125f, (float)(part + 1) * 0.0625f, 0.0f), new Vector3(-0.3125f, (float)(part + 1) * 0.0625f, -0.0625f), new Vector3(-0.3125f, (float)part * 0.0625f, 0.0f), light == 0xF000F0);
            VertexConsumerUtil.addVertex((VertexConsumer)bufferBuilder, (Matrix4f)positionMatrices[part], (float)-0.3125f, (float)((float)(part + 1) * 0.0625f), (float)0.0f, (float)minU, (float)maxV, (int)OverlayTexture.f_118083_, (int)light, (float)normalVec.x, (float)normalVec.y, (float)normalVec.z, (float)alpha);
            VertexConsumerUtil.addVertex((VertexConsumer)bufferBuilder, (Matrix4f)positionMatrices[part], (float)-0.3125f, (float)((float)(part + 1) * 0.0625f), (float)-0.0625f, (float)maxU, (float)maxV, (int)OverlayTexture.f_118083_, (int)light, (float)normalVec.x, (float)normalVec.y, (float)normalVec.z, (float)alpha);
            VertexConsumerUtil.addVertex((VertexConsumer)bufferBuilder, (Matrix4f)positionMatrices[Math.max(part - 1, 0)], (float)-0.3125f, (float)((float)part * 0.0625f), (float)-0.0625f, (float)maxU, (float)minV, (int)OverlayTexture.f_118083_, (int)light, (float)normalVec.x, (float)normalVec.y, (float)normalVec.z, (float)alpha);
            VertexConsumerUtil.addVertex((VertexConsumer)bufferBuilder, (Matrix4f)positionMatrices[Math.max(part - 1, 0)], (float)-0.3125f, (float)((float)part * 0.0625f), (float)0.0f, (float)minU, (float)minV, (int)OverlayTexture.f_118083_, (int)light, (float)normalVec.x, (float)normalVec.y, (float)normalVec.z, (float)alpha);
            minU = 0.171875f;
            maxU = 0.1875f;
            normalVec = CustomCapeRenderer.getNormalVec(positionMatrices[part], positionMatrices[part], positionMatrices[Math.max(part - 1, 0)], new Vector3(0.3125f, (float)(part + 1) * 0.0625f, -0.0625f), new Vector3(0.3125f, (float)(part + 1) * 0.0625f, 0.0f), new Vector3(0.3125f, (float)part * 0.0625f, -0.0625f), light == 0xF000F0);
            VertexConsumerUtil.addVertex((VertexConsumer)bufferBuilder, (Matrix4f)positionMatrices[part], (float)0.3125f, (float)((float)(part + 1) * 0.0625f), (float)-0.0625f, (float)minU, (float)maxV, (int)OverlayTexture.f_118083_, (int)light, (float)normalVec.x, (float)normalVec.y, (float)normalVec.z, (float)alpha);
            VertexConsumerUtil.addVertex((VertexConsumer)bufferBuilder, (Matrix4f)positionMatrices[part], (float)0.3125f, (float)((float)(part + 1) * 0.0625f), (float)0.0f, (float)maxU, (float)maxV, (int)OverlayTexture.f_118083_, (int)light, (float)normalVec.x, (float)normalVec.y, (float)normalVec.z, (float)alpha);
            VertexConsumerUtil.addVertex((VertexConsumer)bufferBuilder, (Matrix4f)positionMatrices[Math.max(part - 1, 0)], (float)0.3125f, (float)((float)part * 0.0625f), (float)0.0f, (float)maxU, (float)minV, (int)OverlayTexture.f_118083_, (int)light, (float)normalVec.x, (float)normalVec.y, (float)normalVec.z, (float)alpha);
            VertexConsumerUtil.addVertex((VertexConsumer)bufferBuilder, (Matrix4f)positionMatrices[Math.max(part - 1, 0)], (float)0.3125f, (float)((float)part * 0.0625f), (float)-0.0625f, (float)minU, (float)minV, (int)OverlayTexture.f_118083_, (int)light, (float)normalVec.x, (float)normalVec.y, (float)normalVec.z, (float)alpha);
            minU = 0.015625f;
            maxU = 0.171875f;
            Vector3 normalVecTop = frontNormalVecs[part].clone().add(frontNormalVecs[Math.max(part - 1, 0)]).div(2.0f);
            Vector3 normalVecBottom = frontNormalVecs[part].clone().add(frontNormalVecs[Math.min(part + 1, 15)]).div(2.0f);
            VertexConsumerUtil.addVertex((VertexConsumer)bufferBuilder, (Matrix4f)positionMatrices[Math.max(part - 1, 0)], (float)0.3125f, (float)((float)part * 0.0625f), (float)-0.0625f, (float)maxU, (float)minV, (int)OverlayTexture.f_118083_, (int)light, (float)normalVecTop.x, (float)normalVecTop.y, (float)normalVecTop.z, (float)alpha);
            VertexConsumerUtil.addVertex((VertexConsumer)bufferBuilder, (Matrix4f)positionMatrices[Math.max(part - 1, 0)], (float)-0.3125f, (float)((float)part * 0.0625f), (float)-0.0625f, (float)minU, (float)minV, (int)OverlayTexture.f_118083_, (int)light, (float)normalVecTop.x, (float)normalVecTop.y, (float)normalVecTop.z, (float)alpha);
            VertexConsumerUtil.addVertex((VertexConsumer)bufferBuilder, (Matrix4f)positionMatrices[part], (float)-0.3125f, (float)((float)(part + 1) * 0.0625f), (float)-0.0625f, (float)minU, (float)maxV, (int)OverlayTexture.f_118083_, (int)light, (float)normalVecBottom.x, (float)normalVecBottom.y, (float)normalVecBottom.z, (float)alpha);
            VertexConsumerUtil.addVertex((VertexConsumer)bufferBuilder, (Matrix4f)positionMatrices[part], (float)0.3125f, (float)((float)(part + 1) * 0.0625f), (float)-0.0625f, (float)maxU, (float)maxV, (int)OverlayTexture.f_118083_, (int)light, (float)normalVecBottom.x, (float)normalVecBottom.y, (float)normalVecBottom.z, (float)alpha);
            minU = 0.1875f;
            maxU = 0.34375f;
            normalVecTop = backNormalVecs[part].clone().add(backNormalVecs[Math.max(part - 1, 0)]).div(2.0f);
            normalVecBottom = backNormalVecs[part].clone().add(backNormalVecs[Math.min(part + 1, 15)]).div(2.0f);
            VertexConsumerUtil.addVertex((VertexConsumer)bufferBuilder, (Matrix4f)positionMatrices[Math.max(part - 1, 0)], (float)0.3125f, (float)((float)part * 0.0625f), (float)0.0f, (float)minU, (float)maxV, (int)OverlayTexture.f_118083_, (int)light, (float)normalVecTop.x, (float)normalVecTop.y, (float)normalVecTop.z, (float)alpha);
            VertexConsumerUtil.addVertex((VertexConsumer)bufferBuilder, (Matrix4f)positionMatrices[Math.max(part - 1, 0)], (float)-0.3125f, (float)((float)part * 0.0625f), (float)0.0f, (float)maxU, (float)maxV, (int)OverlayTexture.f_118083_, (int)light, (float)normalVecTop.x, (float)normalVecTop.y, (float)normalVecTop.z, (float)alpha);
            VertexConsumerUtil.addVertex((VertexConsumer)bufferBuilder, (Matrix4f)positionMatrices[part], (float)-0.3125f, (float)((float)(part + 1) * 0.0625f), (float)0.0f, (float)maxU, (float)minV, (int)OverlayTexture.f_118083_, (int)light, (float)normalVecBottom.x, (float)normalVecBottom.y, (float)normalVecBottom.z, (float)alpha);
            VertexConsumerUtil.addVertex((VertexConsumer)bufferBuilder, (Matrix4f)positionMatrices[part], (float)0.3125f, (float)((float)(part + 1) * 0.0625f), (float)0.0f, (float)minU, (float)minV, (int)OverlayTexture.f_118083_, (int)light, (float)normalVecBottom.x, (float)normalVecBottom.y, (float)normalVecBottom.z, (float)alpha);
        }
    }

    private void modifyPoseStack(PoseStack poseStack, PlayerWrapper capeRenderInfo, float h, int part) {
        if (WaveyCapesBase.config.capeMovement != CapeMovement.VANILLA) {
            this.modifyPoseStackSimulation(poseStack, capeRenderInfo, h, part);
            return;
        }
        this.modifyPoseStackVanilla(poseStack, (AbstractClientPlayer)capeRenderInfo.getEntity(), h, part);
    }

    private void modifyPoseStackSimulation(PoseStack poseStack, PlayerWrapper capeRenderInfo, float delta, int part) {
        Player entity = capeRenderInfo.getEntity();
        BasicSimulation simulation = ((CapeHolder)entity).getSimulation();
        poseStack.m_85836_();
        poseStack.m_85837_(0.0, 0.0, 0.125);
        float x = simulation.getPoints().get(part).getLerpX(delta) - simulation.getPoints().get(0).getLerpX(delta);
        if (x > 0.0f) {
            x = 0.0f;
        }
        float y = simulation.getPoints().get(0).getLerpY(delta) - (float)part - simulation.getPoints().get(part).getLerpY(delta);
        float z = simulation.getPoints().get(0).getLerpZ(delta) - simulation.getPoints().get(part).getLerpZ(delta);
        float sidewaysRotationOffset = 0.0f;
        float partRotation = this.getRotation(delta, part, simulation);
        float height = 0.0f;
        float naturalWindSwing = this.getNatrualWindSwing(part, entity.m_5842_());
        poseStack.m_85845_(MathUtil.XP.m_122240_(6.0f + height + naturalWindSwing));
        poseStack.m_85845_(MathUtil.ZP.m_122240_(sidewaysRotationOffset / 2.0f));
        poseStack.m_85845_(MathUtil.YP.m_122240_(180.0f - sidewaysRotationOffset / 2.0f));
        poseStack.m_85837_((double)(-z / 16.0f), (double)(y / 16.0f), (double)(x / 16.0f));
        poseStack.m_85837_(0.0, 0.03, -0.03);
        poseStack.m_85837_(0.0, (double)((float)part * 1.0f / 16.0f), (double)(part * 0 / 16));
        poseStack.m_85845_(MathUtil.XP.m_122240_(-partRotation));
        poseStack.m_85837_(0.0, (double)((float)(-part) * 1.0f / 16.0f), (double)(-part * 0 / 16));
        poseStack.m_85837_(0.0, -0.03, 0.03);
    }

    private float getRotation(float delta, int part, BasicSimulation simulation) {
        if (part == 15) {
            return this.getRotation(delta, part - 1, simulation);
        }
        return (float)this.getAngle(simulation.getPoints().get(part).getLerpedPos(delta), simulation.getPoints().get(part + 1).getLerpedPos(delta));
    }

    private double getAngle(Vector3 a, Vector3 b) {
        Vector3 angle = b.subtract(a);
        return Math.toDegrees(Math.atan2(angle.x, angle.y)) + 180.0;
    }

    private void modifyPoseStackVanilla(PoseStack poseStack, AbstractClientPlayer abstractClientPlayer, float h, int part) {
        poseStack.m_85836_();
        poseStack.m_85837_(0.0, 0.0, 0.125);
        double d = Mth.m_14139_((double)h, (double)abstractClientPlayer.f_36102_, (double)abstractClientPlayer.f_36105_) - Mth.m_14139_((double)h, (double)abstractClientPlayer.f_19854_, (double)abstractClientPlayer.m_20185_());
        double e = Mth.m_14139_((double)h, (double)abstractClientPlayer.f_36103_, (double)abstractClientPlayer.f_36106_) - Mth.m_14139_((double)h, (double)abstractClientPlayer.f_19855_, (double)abstractClientPlayer.m_20186_());
        double m = Mth.m_14139_((double)h, (double)abstractClientPlayer.f_36104_, (double)abstractClientPlayer.f_36075_) - Mth.m_14139_((double)h, (double)abstractClientPlayer.f_19856_, (double)abstractClientPlayer.m_20189_());
        float n = abstractClientPlayer.f_20884_ + abstractClientPlayer.f_20883_ - abstractClientPlayer.f_20884_;
        double o = Mth.m_14031_((float)(n * ((float)Math.PI / 180)));
        double p = -Mth.m_14089_((float)(n * ((float)Math.PI / 180)));
        float height = (float)e * 10.0f;
        height = Mth.m_14036_((float)height, (float)-6.0f, (float)32.0f);
        float swing = (float)(d * o + m * p) * CustomCapeRenderer.easeOutSine(0.0625f * (float)part) * 100.0f;
        swing = Mth.m_14036_((float)swing, (float)0.0f, (float)(150.0f * CustomCapeRenderer.easeOutSine(0.0625f * (float)part)));
        float sidewaysRotationOffset = (float)(d * p - m * o) * 100.0f;
        sidewaysRotationOffset = Mth.m_14036_((float)sidewaysRotationOffset, (float)-20.0f, (float)20.0f);
        float t = Mth.m_14179_((float)h, (float)abstractClientPlayer.f_36099_, (float)abstractClientPlayer.f_36100_);
        float naturalWindSwing = this.getNatrualWindSwing(part, abstractClientPlayer.m_5842_());
        poseStack.m_85845_(MathUtil.XP.m_122240_(6.0f + swing / 2.0f + (height += Mth.m_14031_((float)(Mth.m_14179_((float)h, (float)abstractClientPlayer.f_19867_, (float)abstractClientPlayer.f_19787_) * 6.0f)) * 32.0f * t) + naturalWindSwing));
        poseStack.m_85845_(MathUtil.ZP.m_122240_(sidewaysRotationOffset / 2.0f));
        poseStack.m_85845_(MathUtil.YP.m_122240_(180.0f - sidewaysRotationOffset / 2.0f));
    }

    private static float easeOutSine(float x) {
        return Mth.m_14031_((float)((float)((double)x * Math.PI / 2.0)));
    }

    private float getNatrualWindSwing(int part, boolean underwater) {
        long highlightedPart = System.currentTimeMillis() / (long)(underwater ? 9 : 3) % 360L;
        float relativePart = (float)(part + 1) / 16.0f;
        if (WaveyCapesBase.config.windMode == WindMode.WAVES) {
            return (float)(Math.sin(Math.toRadians(relativePart * 360.0f - (float)highlightedPart)) * 3.0);
        }
        return 0.0f;
    }

    private static Vector3 getNormalVec(Matrix4f matrix1, Matrix4f matrix2, Matrix4f matrix3, Vector3 vector1, Vector3 vector2, Vector3 vector3, boolean inverse) {
        Vector3 vector1Transformed = CustomCapeRenderer.transform(matrix1, new Vector4(vector1.x, vector1.y, vector1.z, 1.0f)).toVec3();
        Vector3 vector2Transformed = CustomCapeRenderer.transform(matrix2, new Vector4(vector2.x, vector2.y, vector2.z, 1.0f)).toVec3();
        Vector3 vector3Transformed = CustomCapeRenderer.transform(matrix3, new Vector4(vector3.x, vector3.y, vector3.z, 1.0f)).toVec3();
        vector2Transformed.subtract(vector1Transformed);
        vector3Transformed.subtract(vector1Transformed);
        vector2Transformed.cross(vector3Transformed);
        vector2Transformed.normalize();
        return inverse ? vector2Transformed.mul(-1.0f) : vector2Transformed;
    }

    private static Vector4 transform(Matrix4f matrix, Vector4 vector) {
        Vector4f vector4f = new Vector4f(vector.x, vector.y, vector.z, vector.w);
        vector4f.m_123607_(matrix);
        return new Vector4(vector4f.m_123601_(), vector4f.m_123615_(), vector4f.m_123616_(), vector4f.m_123617_());
    }

    private CapeRenderer getCapeRenderer(PlayerWrapper capeRenderInfo) {
        for (ModSupport support : SupportManager.getSupportedMods()) {
            if (!support.shouldBeUsed(capeRenderInfo)) continue;
            return support.getRenderer();
        }
        if (capeRenderInfo.getCapeTexture() == null || !capeRenderInfo.isCapeVisible()) {
            return null;
        }
        return vanillaCape;
    }
}

