/*
 * Decompiled with CFR 0.152.
 */
package winterwolfsv.cobblemon_quests.commands;

import com.cobblemon.mod.common.api.pokemon.PokemonSpecies;
import com.cobblemon.mod.common.pokemon.Species;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.suggestion.SuggestionProvider;
import com.mojang.brigadier.suggestion.SuggestionsBuilder;
import com.mojang.brigadier.tree.CommandNode;
import java.util.List;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.commands.SharedSuggestionProvider;
import net.minecraft.network.chat.Component;
import winterwolfsv.cobblemon_quests.commands.suggestions.ListSuggestionProvider;
import winterwolfsv.cobblemon_quests.config.CobblemonQuestsConfig;

public class BlacklistPokemonCommand {
    public static CommandNode<CommandSourceStack> register() {
        return ((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.literal((String)"blacklisted_pokemon").then(Commands.argument((String)"action", (ArgumentType)StringArgumentType.string()).suggests((SuggestionProvider)new ListSuggestionProvider(List.of("add", "remove"))).then(Commands.argument((String)"pokemon", (ArgumentType)StringArgumentType.string()).suggests((context, builder) -> {
            if (StringArgumentType.getString((CommandContext)context, (String)"action").equals("add")) {
                return SharedSuggestionProvider.suggest(PokemonSpecies.getSpecies().stream().map(Species::getName).toList(), (SuggestionsBuilder)builder);
            }
            if (StringArgumentType.getString((CommandContext)context, (String)"action").equals("remove")) {
                return SharedSuggestionProvider.suggest(CobblemonQuestsConfig.ignoredPokemon, (SuggestionsBuilder)builder);
            }
            return builder.buildFuture();
        }).executes(context -> {
            String action = StringArgumentType.getString((CommandContext)context, (String)"action");
            String pokemon = StringArgumentType.getString((CommandContext)context, (String)"pokemon").toLowerCase();
            if (action.equals("add")) {
                if (CobblemonQuestsConfig.ignoredPokemon.contains(pokemon)) {
                    ((CommandSourceStack)context.getSource()).sendSystemMessage((Component)Component.literal((String)("Pok\u00e9mon " + pokemon + " is already blacklisted.")));
                    return 0;
                }
                CobblemonQuestsConfig.ignoredPokemon.add(pokemon);
                CobblemonQuestsConfig.save();
                ((CommandSourceStack)context.getSource()).sendSystemMessage((Component)Component.literal((String)("Pok\u00e9mon " + pokemon + " has been blacklisted.")));
            } else if (action.equals("remove")) {
                if (!CobblemonQuestsConfig.ignoredPokemon.contains(pokemon)) {
                    ((CommandSourceStack)context.getSource()).sendSystemMessage((Component)Component.literal((String)("Pok\u00e9mon " + pokemon + " is not blacklisted.")));
                    return 0;
                }
                CobblemonQuestsConfig.ignoredPokemon.remove(pokemon);
                CobblemonQuestsConfig.save();
                ((CommandSourceStack)context.getSource()).sendSystemMessage((Component)Component.literal((String)("Pok\u00e9mon " + pokemon + " has been removed from the blacklist.")));
            }
            return 1;
        })))).executes(context -> {
            ((CommandSourceStack)context.getSource()).sendSystemMessage((Component)Component.literal((String)("Currently blacklisted Pok\u00e9mon: " + String.valueOf(CobblemonQuestsConfig.ignoredPokemon))));
            return 1;
        })).build();
    }
}

