/*
 * Decompiled with CFR 0.152.
 */
package winterwolfsv.cobblemon_quests.commands;

import com.cobblemon.mod.common.Cobblemon;
import com.cobblemon.mod.common.api.pokemon.PokemonProperties;
import com.cobblemon.mod.common.api.storage.party.PlayerPartyStore;
import com.cobblemon.mod.common.command.argument.PokemonPropertiesArgumentType;
import com.cobblemon.mod.common.pokemon.Pokemon;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.BoolArgumentType;
import com.mojang.brigadier.arguments.IntegerArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.tree.CommandNode;
import java.util.List;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.commands.arguments.EntityArgument;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;
import winterwolfsv.cobblemon_quests.CobblemonQuests;
import winterwolfsv.cobblemon_quests.commands.arguments.types.ActionListArgumentType;

public class GivePokemonCommand {
    public static CommandNode<CommandSourceStack> register() {
        return ((LiteralArgumentBuilder)Commands.literal((String)"givepokemon").then(Commands.argument((String)"player", (ArgumentType)EntityArgument.player()).then(Commands.argument((String)"should_give", (ArgumentType)BoolArgumentType.bool()).then(Commands.argument((String)"amount", (ArgumentType)IntegerArgumentType.integer()).then(Commands.argument((String)"action", (ArgumentType)ActionListArgumentType.actionList()).then(Commands.argument((String)"properties", (ArgumentType)PokemonPropertiesArgumentType.Companion.properties()).executes(GivePokemonCommand::execute))))))).build();
    }

    private static int execute(CommandContext<CommandSourceStack> context) throws CommandSyntaxException {
        List<String> actionList = ActionListArgumentType.getActionList(context, "action");
        ServerPlayer player = EntityArgument.getPlayer(context, (String)"player");
        boolean givePokemon = BoolArgumentType.getBool(context, (String)"should_give");
        int amount = IntegerArgumentType.getInteger(context, (String)"amount");
        PokemonProperties pokemonProperties = PokemonPropertiesArgumentType.Companion.getPokemonProperties(context, "properties");
        Pokemon pokemon = pokemonProperties.create();
        for (String action : actionList) {
            CobblemonQuests.eventHandler.processTasksForTeam(pokemon, action, (long)amount, player);
        }
        if (givePokemon) {
            PlayerPartyStore party = Cobblemon.INSTANCE.getStorage().getParty(player);
            party.add(pokemon);
        }
        ((CommandSourceStack)context.getSource()).sendSuccess(() -> Component.literal((String)("Successfully ran command givepokemon for player " + player.getName().getString() + " with actions " + String.valueOf(actionList) + " for pokemon " + pokemon.getSpecies().getName())), true);
        return 1;
    }
}

