/*
 * Decompiled with CFR 0.152.
 */
package winterwolfsv.cobblemon_quests.events;

import com.cobblemon.mod.common.Cobblemon;
import com.cobblemon.mod.common.api.Priority;
import com.cobblemon.mod.common.api.battles.model.actor.ActorType;
import com.cobblemon.mod.common.api.battles.model.actor.BattleActor;
import com.cobblemon.mod.common.api.events.CobblemonEvents;
import com.cobblemon.mod.common.api.events.battles.BattleVictoryEvent;
import com.cobblemon.mod.common.api.events.fishing.BobberSpawnPokemonEvent;
import com.cobblemon.mod.common.api.events.pokeball.ThrownPokeballHitEvent;
import com.cobblemon.mod.common.api.events.pokedex.scanning.PokemonScannedEvent;
import com.cobblemon.mod.common.api.events.pokemon.FossilRevivedEvent;
import com.cobblemon.mod.common.api.events.pokemon.LevelUpEvent;
import com.cobblemon.mod.common.api.events.pokemon.PokedexDataChangedEvent;
import com.cobblemon.mod.common.api.events.pokemon.PokemonCapturedEvent;
import com.cobblemon.mod.common.api.events.pokemon.TradeEvent;
import com.cobblemon.mod.common.api.events.pokemon.evolution.EvolutionAcceptedEvent;
import com.cobblemon.mod.common.api.events.pokemon.evolution.EvolutionCompleteEvent;
import com.cobblemon.mod.common.api.events.starter.StarterChosenEvent;
import com.cobblemon.mod.common.api.events.storage.ReleasePokemonEvent;
import com.cobblemon.mod.common.api.pokedex.PokedexEntryProgress;
import com.cobblemon.mod.common.api.pokedex.PokedexManager;
import com.cobblemon.mod.common.battles.pokemon.BattlePokemon;
import com.cobblemon.mod.common.entity.pokemon.PokemonEntity;
import com.cobblemon.mod.common.pokemon.Pokemon;
import dev.architectury.event.EventResult;
import dev.architectury.event.events.common.EntityEvent;
import dev.architectury.event.events.common.PlayerEvent;
import dev.architectury.hooks.level.entity.PlayerHooks;
import dev.ftb.mods.ftbquests.api.QuestFile;
import dev.ftb.mods.ftbquests.events.ClearFileCacheEvent;
import dev.ftb.mods.ftbquests.quest.ServerQuestFile;
import dev.ftb.mods.ftbquests.quest.TeamData;
import dev.ftb.mods.ftbquests.quest.task.Task;
import dev.ftb.mods.ftbteams.api.Team;
import dev.ftb.mods.ftbteams.data.TeamManagerImpl;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.Optional;
import java.util.UUID;
import net.minecraft.class_1282;
import net.minecraft.class_1297;
import net.minecraft.class_1309;
import net.minecraft.class_1657;
import net.minecraft.class_1937;
import net.minecraft.class_3222;
import winterwolfsv.cobblemon_quests.CobblemonQuests;
import winterwolfsv.cobblemon_quests.tasks.CobblemonTask;

public class CobblemonQuestsEventHandler {
    private HashSet<CobblemonTask> pokemonTasks = null;
    private UUID lastPokemonUuid = null;

    public CobblemonQuestsEventHandler init() {
        EntityEvent.LIVING_DEATH.register(this::entityKill);
        ClearFileCacheEvent.EVENT.register(this::fileCacheClear);
        CobblemonEvents.POKEMON_CAPTURED.subscribe(Priority.LOWEST, this::pokemonCatchEvent);
        CobblemonEvents.BATTLE_VICTORY.subscribe(Priority.LOWEST, this::pokemonBattleVictory);
        CobblemonEvents.STARTER_CHOSEN.subscribe(Priority.LOWEST, this::pokemonStarterChosen);
        CobblemonEvents.EVOLUTION_COMPLETE.subscribe(Priority.LOWEST, this::pokemonEvolutionComplete);
        CobblemonEvents.LEVEL_UP_EVENT.subscribe(Priority.LOWEST, this::pokemonLevelUp);
        CobblemonEvents.EVOLUTION_ACCEPTED.subscribe(Priority.LOWEST, this::pokemonEvolutionAccepted);
        CobblemonEvents.TRADE_EVENT_POST.subscribe(Priority.LOWEST, this::pokemonTrade);
        CobblemonEvents.POKEMON_RELEASED_EVENT_PRE.subscribe(Priority.LOWEST, this::pokemonRelease);
        CobblemonEvents.FOSSIL_REVIVED.subscribe(Priority.LOWEST, this::fossilRevived);
        CobblemonEvents.BOBBER_SPAWN_POKEMON_POST.subscribe(Priority.LOWEST, this::pokemonBobberSpawn);
        CobblemonEvents.POKEMON_SCANNED.subscribe(Priority.LOWEST, this::pokemonScan);
        CobblemonEvents.POKEDEX_DATA_CHANGED_POST.subscribe(Priority.LOWEST, this::pokeDexChangedPost);
        CobblemonEvents.POKEDEX_DATA_CHANGED_PRE.subscribe(Priority.LOWEST, this::pokeDexChanged);
        CobblemonEvents.THROWN_POKEBALL_HIT.subscribe(Priority.LOWEST, this::pokeballHit);
        PlayerEvent.PLAYER_JOIN.register(this::playerJoin);
        return this;
    }

    private void triggerPokeDexUpdate(UUID playerUUID) {
        try {
            TeamData teamData = this.getTeamData(playerUUID);
            if (teamData == null) {
                return;
            }
            PokedexManager pokedexManager = Cobblemon.playerDataManager.getPokedexData(playerUUID);
            for (CobblemonTask task : this.pokemonTasks) {
                task.increaseHaveRegistered(teamData, pokedexManager);
            }
        }
        catch (Exception e) {
            CobblemonQuests.LOGGER.warning("Error adding caught pokemon to the dex " + Arrays.toString(e.getStackTrace()));
        }
    }

    private void playerJoin(class_3222 player) {
        this.triggerPokeDexUpdate(player.method_5667());
    }

    private void pokeDexChanged(PokedexDataChangedEvent pre) {
        try {
            int value;
            Pokemon pokemon = pre.getDataSource().getPokemon();
            PokedexEntryProgress before = pre.getPokedexManager().getKnowledgeForSpecies(pokemon.getSpecies().getResourceIdentifier());
            PokedexEntryProgress after = pre.getKnowledge();
            int n = after.equals((Object)PokedexEntryProgress.CAUGHT) ? (before.equals((Object)PokedexEntryProgress.ENCOUNTERED) ? 1 : 2) : (value = after.equals((Object)PokedexEntryProgress.ENCOUNTERED) ? 0 : -1);
            if (value == -1) {
                throw new Exception("Invalid pokedex change.", new Throwable("Before: " + String.valueOf(before) + " After: " + String.valueOf(after)));
            }
            class_1309 owner = pre.getDataSource().getPokemon().getOwnerEntity();
            PokemonEntity pokemonEntity = pokemon.getEntity();
            class_1937 world = Optional.ofNullable(owner).map(class_1297::method_37908).orElseGet(() -> Optional.ofNullable(pokemonEntity).map(class_1297::method_37908).orElse(null));
            if (world == null) {
                Throwable cause = new Throwable("Owner uuid " + String.valueOf(pre.getPlayerUUID()) + "Owner: " + String.valueOf(owner) + " PokemonEntity: " + String.valueOf(pokemonEntity));
                throw new NoSuchElementException("World is null while processing pokedex.", cause);
            }
            class_1657 player = world.method_18470(pre.getPlayerUUID());
            if (player instanceof class_3222) {
                class_3222 serverPlayer = (class_3222)player;
                this.processTasksForTeam(pokemon, "register", (long)value, serverPlayer);
            }
        }
        catch (Exception e) {
            CobblemonQuests.LOGGER.warning("Error processing pokedex changed event " + String.valueOf(e.getCause()) + " " + Arrays.toString(e.getStackTrace()));
        }
    }

    private void pokeDexChangedPost(PokedexDataChangedEvent.Post post) {
        this.triggerPokeDexUpdate(post.getPlayerUUID());
    }

    private void pokemonScan(PokemonScannedEvent pokemonScannedEvent) {
        try {
            if (!(pokemonScannedEvent.getScannedEntity().resolveEntityScan() instanceof PokemonEntity)) {
                return;
            }
            Pokemon pokemon = ((PokemonEntity)pokemonScannedEvent.getScannedEntity()).getPokemon();
            if (this.lastPokemonUuid == pokemon.getUuid()) {
                return;
            }
            this.lastPokemonUuid = pokemon.getUuid();
            class_3222 player = pokemonScannedEvent.getPlayer();
            this.processTasksForTeam(pokemon, "scan", 1L, player);
        }
        catch (Exception e) {
            CobblemonQuests.LOGGER.warning("Error processing scan event " + Arrays.toString(e.getStackTrace()));
        }
    }

    private void pokemonBobberSpawn(BobberSpawnPokemonEvent.Post post) {
        try {
            Pokemon pokemon = post.getPokemon().getPokemon();
            class_3222 player = (class_3222)post.component1().method_6947();
            this.processTasksForTeam(pokemon, "reel", 1L, player);
        }
        catch (Exception e) {
            CobblemonQuests.LOGGER.warning("Error processing bobber spawn event " + Arrays.toString(e.getStackTrace()));
        }
    }

    private void fossilRevived(FossilRevivedEvent fossilRevivedEvent) {
        try {
            class_3222 player = fossilRevivedEvent.getPlayer();
            Pokemon pokemon = fossilRevivedEvent.getPokemon();
            this.processTasksForTeam(pokemon, "revive_fossil", 1L, player);
        }
        catch (Exception e) {
            CobblemonQuests.LOGGER.warning("Error processing fossil revive event " + Arrays.toString(e.getStackTrace()));
        }
    }

    private void fileCacheClear(QuestFile file) {
        if (file.isServerSide()) {
            this.pokemonTasks = null;
        }
    }

    private void pokemonRelease(ReleasePokemonEvent.Pre pre) {
        try {
            class_3222 player = pre.getPlayer();
            Pokemon pokemon = pre.getPokemon();
            this.processTasksForTeam(pokemon, "release", 1L, player);
        }
        catch (Exception e) {
            CobblemonQuests.LOGGER.warning("Error processing release event " + Arrays.toString(e.getStackTrace()));
        }
    }

    private void pokemonTrade(TradeEvent tradeEvent) {
        try {
            Pokemon pokemonGivenByPlayer1 = tradeEvent.getTradeParticipant2Pokemon();
            Pokemon pokemonGivenByPlayer2 = tradeEvent.getTradeParticipant1Pokemon();
            class_3222 player1 = pokemonGivenByPlayer2.getOwnerPlayer();
            class_3222 player2 = pokemonGivenByPlayer1.getOwnerPlayer();
            this.processTasksForTeam(pokemonGivenByPlayer2, "trade_for", 1L, player1);
            this.processTasksForTeam(pokemonGivenByPlayer1, "trade_away", 1L, player1);
            this.processTasksForTeam(pokemonGivenByPlayer1, "trade_for", 1L, player2);
            this.processTasksForTeam(pokemonGivenByPlayer2, "trade_away", 1L, player2);
        }
        catch (Exception e) {
            CobblemonQuests.LOGGER.warning("Error processing trade event " + Arrays.toString(e.getStackTrace()));
        }
    }

    private void pokemonBattleVictory(BattleVictoryEvent battleVictoryEvent) {
        try {
            class_3222 player;
            List players = battleVictoryEvent.getBattle().getPlayers();
            if (players.isEmpty()) {
                return;
            }
            if (players.size() == 2) {
                class_3222 player1 = (class_3222)players.get(0);
                class_3222 player2 = (class_3222)players.get(1);
                if (player1.method_5667().equals(((BattleActor)battleVictoryEvent.getWinners().getFirst()).getUuid())) {
                    this.processTasksForTeam(player2.method_5477().getString(), "defeat_player", 1L, player1);
                } else {
                    this.processTasksForTeam(player1.method_5477().getString(), "defeat_player", 1L, player2);
                }
            }
            if (!(player = (class_3222)players.getFirst()).method_5667().equals(((BattleActor)battleVictoryEvent.getWinners().getFirst()).getUuid())) {
                return;
            }
            for (BattleActor actor : battleVictoryEvent.getBattle().getActors()) {
                if (actor.getType() == ActorType.NPC) {
                    this.processTasksForTeam(actor.getName().getString(), "defeat_npc", 1L, player);
                } else {
                    if (actor.getType() != ActorType.WILD) continue;
                    if (((BattlePokemon)actor.getPokemonList().getFirst()).getEffectedPokemon().getUuid() == this.lastPokemonUuid) {
                        return;
                    }
                    this.processTasksForTeam(((BattlePokemon)actor.getPokemonList().getFirst()).getEffectedPokemon(), "defeat", 1L, player);
                }
                break;
            }
        }
        catch (Exception e) {
            CobblemonQuests.LOGGER.warning("Error processing battle victory event " + Arrays.toString(e.getStackTrace()));
        }
    }

    private void pokemonCatchEvent(PokemonCapturedEvent pokemonCapturedEvent) {
        this.lastPokemonUuid = pokemonCapturedEvent.getPokemon().getUuid();
        this.pokemonCatch(pokemonCapturedEvent.getPokemon(), pokemonCapturedEvent.getPlayer());
    }

    private void pokeballHit(ThrownPokeballHitEvent thrownPokeballHitEvent) {
        try {
            class_1297 ballOwner = thrownPokeballHitEvent.getPokeBall().method_24921();
            if (ballOwner instanceof class_3222) {
                class_3222 player = (class_3222)ballOwner;
                Pokemon pokemon = thrownPokeballHitEvent.getPokemon().getPokemon();
                pokemon.setCaughtBall(thrownPokeballHitEvent.getPokeBall().getPokeBall());
                this.processTasksForTeam(pokemon, "throw_ball", 1L, player);
            }
        }
        catch (Exception e) {
            CobblemonQuests.LOGGER.warning("Error processing pok\u00e9ball hit event " + Arrays.toString(e.getStackTrace()));
        }
    }

    private EventResult entityKill(class_1297 livingEntity, class_1282 damageSource) {
        try {
            class_3222 player;
            class_1297 class_12972 = damageSource.method_5529();
            if (class_12972 instanceof class_3222 && !PlayerHooks.isFake((class_1657)(player = (class_3222)class_12972))) {
                Pokemon pokemon;
                Pokemon pokemon2 = pokemon = livingEntity instanceof PokemonEntity ? ((PokemonEntity)livingEntity).getPokemon() : null;
                if (pokemon == null) {
                    return EventResult.pass();
                }
                this.processTasksForTeam(pokemon, "kill", 1L, player);
            }
        }
        catch (Exception e) {
            CobblemonQuests.LOGGER.warning("Error processing entity kill event " + Arrays.toString(e.getStackTrace()));
        }
        return EventResult.pass();
    }

    public void pokemonCatch(Pokemon pokemon, class_3222 player) {
        try {
            this.processTasksForTeam(pokemon, "catch", 1L, player);
        }
        catch (Exception e) {
            CobblemonQuests.LOGGER.warning("Error processing catch event " + Arrays.toString(e.getStackTrace()));
        }
    }

    private void pokemonStarterChosen(StarterChosenEvent starterChosenEvent) {
        try {
            class_3222 player = starterChosenEvent.getPlayer();
            Pokemon pokemon = starterChosenEvent.getPokemon();
            this.processTasksForTeam(pokemon, "select_starter", 1L, player);
            this.pokemonCatch(pokemon, player);
        }
        catch (Exception e) {
            CobblemonQuests.LOGGER.warning("Error processing starter chosen event " + Arrays.toString(e.getStackTrace()));
        }
    }

    private void pokemonEvolutionComplete(EvolutionCompleteEvent evolutionCompleteEvent) {
        try {
            Pokemon pokemon = evolutionCompleteEvent.getPokemon();
            class_3222 player = pokemon.getOwnerPlayer();
            this.processTasksForTeam(pokemon, "evolve_into", 1L, player);
            this.pokemonCatch(pokemon, pokemon.getOwnerPlayer());
        }
        catch (Exception e) {
            CobblemonQuests.LOGGER.warning("Error processing evolution complete event " + Arrays.toString(e.getStackTrace()));
        }
    }

    private void pokemonEvolutionAccepted(EvolutionAcceptedEvent evolutionAcceptedEvent) {
        try {
            Pokemon pokemon = evolutionAcceptedEvent.getPokemon();
            class_3222 player = pokemon.getOwnerPlayer();
            this.processTasksForTeam(pokemon, "evolve", 1L, player);
        }
        catch (Exception e) {
            CobblemonQuests.LOGGER.warning("Error processing evolution event " + Arrays.toString(e.getStackTrace()));
        }
    }

    private void pokemonLevelUp(LevelUpEvent levelUpEvent) {
        try {
            class_3222 player = levelUpEvent.getPokemon().getOwnerPlayer();
            Pokemon pokemon = levelUpEvent.getPokemon();
            long deltaLevel = levelUpEvent.getNewLevel() - levelUpEvent.getOldLevel();
            System.out.println("Old level: " + levelUpEvent.getOldLevel() + " New level: " + levelUpEvent.getNewLevel() + " Delta level: " + deltaLevel);
            this.processTasksForTeam(pokemon, "level_up_to", (long)levelUpEvent.getNewLevel(), player);
            this.processTasksForTeam(pokemon, "level_up", deltaLevel, player);
        }
        catch (Exception e) {
            CobblemonQuests.LOGGER.warning("Error processing level up event " + Arrays.toString(e.getStackTrace()));
        }
    }

    public void processTasksForTeam(Pokemon pokemon, String action, long amount, class_3222 player) {
        try {
            TeamData teamData = this.getTeamData(player);
            if (teamData == null) {
                return;
            }
            for (CobblemonTask task : this.pokemonTasks) {
                if (teamData.getProgress((Task)task) >= task.getMaxProgress() || !teamData.canStartTasks(task.getQuest())) continue;
                task.increase(teamData, pokemon, action, amount, player);
            }
        }
        catch (Exception e) {
            CobblemonQuests.LOGGER.warning("(1) Error processing task for team " + Arrays.toString(e.getStackTrace()));
        }
    }

    public void processTasksForTeam(String data, String action, long amount, class_3222 player) {
        try {
            TeamData teamData = this.getTeamData(player);
            if (teamData == null) {
                return;
            }
            for (CobblemonTask task : this.pokemonTasks) {
                if (teamData.getProgress((Task)task) >= task.getMaxProgress() || !teamData.canStartTasks(task.getQuest())) continue;
                task.increaseWoPokemon(teamData, data, action, amount);
            }
        }
        catch (Exception e) {
            CobblemonQuests.LOGGER.warning("(2) Error processing task for team " + Arrays.toString(e.getStackTrace()));
        }
    }

    private TeamData getTeamData(class_3222 player) {
        if (this.pokemonTasks == null) {
            this.pokemonTasks = new HashSet(ServerQuestFile.INSTANCE.collect(CobblemonTask.class));
        }
        if (this.pokemonTasks.isEmpty()) {
            return null;
        }
        Team team = TeamManagerImpl.INSTANCE.getTeamForPlayer(player).orElse(null);
        if (team == null) {
            return null;
        }
        return ServerQuestFile.INSTANCE.getOrCreateTeamData(team);
    }

    private TeamData getTeamData(UUID uuid) {
        if (this.pokemonTasks == null) {
            this.pokemonTasks = new HashSet(ServerQuestFile.INSTANCE.collect(CobblemonTask.class));
        }
        if (uuid == null) {
            return null;
        }
        if (this.pokemonTasks.isEmpty()) {
            return null;
        }
        Team team = TeamManagerImpl.INSTANCE.getTeamByID(uuid).orElse(null);
        if (team == null) {
            return null;
        }
        return ServerQuestFile.INSTANCE.getOrCreateTeamData(team);
    }
}

