/*
 * Decompiled with CFR 0.152.
 */
package org.aussiebox.dfwaypoints.features;

import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import dev.dfonline.flint.Flint;
import dev.dfonline.flint.feature.trait.CommandFeature;
import java.io.IOException;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import net.fabricmc.fabric.api.client.command.v2.ClientCommandManager;
import net.fabricmc.fabric.api.client.command.v2.FabricClientCommandSource;
import net.minecraft.class_243;
import net.minecraft.class_2558;
import net.minecraft.class_2561;
import net.minecraft.class_2568;
import net.minecraft.class_2583;
import net.minecraft.class_5250;
import net.minecraft.class_7157;
import org.aussiebox.dfwaypoints.Dfwaypoints;
import org.aussiebox.dfwaypoints.util.CommandSender;
import org.aussiebox.dfwaypoints.waypoints.Waypoint;
import org.aussiebox.dfwaypoints.waypoints.Waypoints;

public class WaypointCommands
implements CommandFeature {
    public String commandName() {
        return "waypoint";
    }

    public Set<String> aliases() {
        return Set.of("wp");
    }

    public LiteralArgumentBuilder<FabricClientCommandSource> createCommand(LiteralArgumentBuilder<FabricClientCommandSource> builder, class_7157 commandRegistryAccess) {
        return (LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)builder.then(ClientCommandManager.literal((String)"create").then(ClientCommandManager.argument((String)"text", (ArgumentType)StringArgumentType.greedyString()).executes(context -> this.createWaypoint((CommandContext<FabricClientCommandSource>)context, StringArgumentType.getString((CommandContext)context, (String)"text")))))).then(ClientCommandManager.literal((String)"list").executes(this::listWaypoints))).then(ClientCommandManager.literal((String)"teleport").then(ClientCommandManager.argument((String)"text", (ArgumentType)StringArgumentType.greedyString()).suggests((context, suggestionsBuilder) -> {
            if (Flint.getUser().getPlot() == null) {
                return suggestionsBuilder.buildFuture();
            }
            List<Waypoint> waypoints = Waypoints.getWaypoints(Flint.getUser().getPlot().getId());
            List<String> names = waypoints.stream().map(Waypoint::getName).filter(name -> name.startsWith(suggestionsBuilder.getRemaining())).sorted().toList();
            for (String name2 : names) {
                suggestionsBuilder.suggest(name2);
            }
            return suggestionsBuilder.buildFuture();
        }).executes(context -> {
            try {
                return this.teleportToWaypoint((CommandContext<FabricClientCommandSource>)context, StringArgumentType.getString((CommandContext)context, (String)"text"));
            }
            catch (InterruptedException e) {
                throw new RuntimeException(e);
            }
        })))).then(ClientCommandManager.literal((String)"tp").then(ClientCommandManager.argument((String)"text", (ArgumentType)StringArgumentType.greedyString()).suggests((context, suggestionsBuilder) -> {
            if (Flint.getUser().getPlot() == null) {
                return suggestionsBuilder.buildFuture();
            }
            List<Waypoint> waypoints = Waypoints.getWaypoints(Flint.getUser().getPlot().getId());
            List<String> names = waypoints.stream().map(Waypoint::getName).filter(name -> name.startsWith(suggestionsBuilder.getRemaining())).sorted().toList();
            for (String name2 : names) {
                suggestionsBuilder.suggest(name2);
            }
            return suggestionsBuilder.buildFuture();
        }).executes(context -> {
            try {
                return this.teleportToWaypoint((CommandContext<FabricClientCommandSource>)context, StringArgumentType.getString((CommandContext)context, (String)"text"));
            }
            catch (InterruptedException e) {
                throw new RuntimeException(e);
            }
        })))).then(ClientCommandManager.literal((String)"delete").then(ClientCommandManager.argument((String)"text", (ArgumentType)StringArgumentType.greedyString()).suggests((context, suggestionsBuilder) -> {
            if (Flint.getUser().getPlot() == null) {
                return suggestionsBuilder.buildFuture();
            }
            List<Waypoint> waypoints = Waypoints.getWaypoints(Flint.getUser().getPlot().getId());
            List<String> names = waypoints.stream().map(Waypoint::getName).filter(name -> name.startsWith(suggestionsBuilder.getRemaining())).sorted().toList();
            for (String name2 : names) {
                suggestionsBuilder.suggest(name2);
            }
            return suggestionsBuilder.buildFuture();
        }).executes(context -> this.deleteWaypoint((CommandContext<FabricClientCommandSource>)context, StringArgumentType.getString((CommandContext)context, (String)"text")))));
    }

    private int createWaypoint(CommandContext<FabricClientCommandSource> context, String text) {
        assert (Dfwaypoints.MC.field_1724 != null);
        class_5250 waypointEnterPlotMessage = class_2561.method_43470((String)"\u00bb ").method_54663(0xFF5555).method_27694(style -> style.method_10982(Boolean.valueOf(true))).method_10852((class_2561)class_2561.method_43470((String)"You must be on a plot to create waypoints!").method_54663(0xFFFFFF).method_27694(style -> style.method_10982(Boolean.valueOf(false))));
        if (Flint.getUser().getPlot() == null) {
            Dfwaypoints.MC.field_1724.method_7353((class_2561)waypointEnterPlotMessage, false);
            return 0;
        }
        class_5250 waypointNoPermissionsMessage = class_2561.method_43470((String)"\u00bb ").method_54663(0xFF5555).method_27694(style -> style.method_10982(Boolean.valueOf(true))).method_10852((class_2561)class_2561.method_43470((String)"You must be in dev/build mode to create waypoints!").method_54663(0xFFFFFF).method_27694(style -> style.method_10982(Boolean.valueOf(false))));
        if (!Flint.getUser().getMode().isEditor()) {
            Dfwaypoints.MC.field_1724.method_7353((class_2561)waypointNoPermissionsMessage, false);
            return 0;
        }
        String plotID = String.valueOf(Flint.getUser().getPlot().getId());
        String rawPlotName = String.valueOf(Flint.getUser().getPlot().getName()) + "replace";
        String plotName = rawPlotName.replace("literal{", "").replace("}replace", "");
        class_5250 hoverText = class_2561.method_43473().method_10852((class_2561)class_2561.method_43470((String)"\u00bb ").method_54663(0x55FF55).method_27694(style -> style.method_10982(Boolean.valueOf(true)))).method_10852((class_2561)class_2561.method_43470((String)"Waypoint Name: ").method_54663(0xFFFFFF).method_27694(style -> style.method_10982(Boolean.valueOf(false)))).method_10852((class_2561)class_2561.method_43470((String)text).method_54663(0xFFFF55)).method_10852((class_2561)class_2561.method_43470((String)"\n\u00bb ").method_54663(0x55FF55).method_27694(style -> style.method_10982(Boolean.valueOf(true)))).method_10852((class_2561)class_2561.method_43470((String)"Plot: ").method_54663(0xFFFFFF).method_27694(style -> style.method_10982(Boolean.valueOf(false)))).method_10852((class_2561)class_2561.method_43470((String)plotName).method_54663(0x55FFFF)).method_10852((class_2561)class_2561.method_43470((String)(" (" + plotID + ")")).method_54663(0xAAAAAA));
        class_5250 waypointCreatedMessage = class_2561.method_43470((String)"\u00bb ").method_54663(0x55FF55).method_27694(style -> style.method_10982(Boolean.valueOf(true))).method_10852((class_2561)class_2561.method_43470((String)"Waypoint Created. ").method_54663(0xFFFFFF).method_27694(style -> style.method_10982(Boolean.valueOf(false)))).method_10852((class_2561)class_2561.method_43470((String)"(Hover for details)").method_54663(0xAAAAAA).method_27694(style -> style.method_10982(Boolean.valueOf(false)))).method_27694(style -> style.method_10949(new class_2568(class_2568.class_5247.field_24342, (Object)hoverText)));
        class_5250 waypointCreatedNotSavedMessage = class_2561.method_43470((String)"\u00bb ").method_54663(0xFF5555).method_27694(style -> style.method_10982(Boolean.valueOf(true))).method_10852((class_2561)class_2561.method_43470((String)"DFWaypoints ran into an issue saving waypoint data. Your waypoint has been created, but may not save upon closing the game. ").method_54663(0xFFFFFF).method_27694(style -> style.method_10982(Boolean.valueOf(false)))).method_10852((class_2561)class_2561.method_43470((String)"(Hover for details)").method_54663(0xAAAAAA).method_27694(style -> style.method_10982(Boolean.valueOf(false)))).method_27694(style -> style.method_10949(new class_2568(class_2568.class_5247.field_24342, (Object)hoverText)));
        class_5250 waypointAlreadyExistsMessage = class_2561.method_43470((String)"\u00bb ").method_54663(0xFF5555).method_27694(style -> style.method_10982(Boolean.valueOf(true))).method_10852((class_2561)class_2561.method_43470((String)"You already have a waypoint with this name!").method_54663(0xFFFFFF).method_27694(style -> style.method_10982(Boolean.valueOf(false))));
        List<Waypoint> waypoints = Waypoints.getWaypoints(Flint.getUser().getPlot().getId());
        for (Waypoint waypoint : waypoints) {
            if (!Objects.equals(waypoint.getName(), text)) continue;
            Dfwaypoints.MC.field_1724.method_7353((class_2561)waypointAlreadyExistsMessage, false);
            return 0;
        }
        if (Dfwaypoints.MC.field_1724 != null) {
            Waypoints.addWaypoint(Flint.getUser().getPlot().getId(), new Waypoint(text, Dfwaypoints.MC.field_1724.method_19538()));
            try {
                Waypoints.save();
                Dfwaypoints.MC.field_1724.method_7353((class_2561)waypointCreatedMessage, false);
            }
            catch (IOException e) {
                Dfwaypoints.MC.field_1724.method_7353((class_2561)waypointCreatedNotSavedMessage, false);
            }
        }
        return 0;
    }

    private int listWaypoints(CommandContext<FabricClientCommandSource> context) {
        assert (Flint.getUser().getPlot() != null);
        assert (Dfwaypoints.MC.field_1724 != null);
        class_5250 waypointEnterPlotMessage = class_2561.method_43470((String)"\u00bb ").method_54663(0xFF5555).method_27694(style -> style.method_10982(Boolean.valueOf(true))).method_10852((class_2561)class_2561.method_43470((String)"You must be on a plot to list your waypoints!").method_54663(0xFFFFFF).method_27694(style -> style.method_10982(Boolean.valueOf(false))));
        if (Flint.getUser().getPlot() == null) {
            Dfwaypoints.MC.field_1724.method_7353((class_2561)waypointEnterPlotMessage, false);
            return 0;
        }
        class_5250 teleportHover = class_2561.method_43473().method_10852((class_2561)class_2561.method_43470((String)"\u00bb ").method_54663(0x55FF55).method_27694(style -> style.method_10982(Boolean.valueOf(true)))).method_10852((class_2561)class_2561.method_43470((String)"Teleport to waypoint").method_54663(0xFFFFFF).method_27694(style -> style.method_10982(Boolean.valueOf(false))));
        class_5250 deleteHover = class_2561.method_43473().method_10852((class_2561)class_2561.method_43470((String)"\u00bb ").method_54663(0xFF5555).method_27694(style -> style.method_10982(Boolean.valueOf(true)))).method_10852((class_2561)class_2561.method_43470((String)"Delete Waypoint").method_54663(0xFFFFFF).method_27694(style -> style.method_10982(Boolean.valueOf(false))));
        class_5250 waypointListMessage = class_2561.method_43470((String)"\u00bb ").method_54663(0x55FFFF).method_27694(style -> style.method_10982(Boolean.valueOf(true))).method_10852((class_2561)class_2561.method_43470((String)"Your waypoints for ").method_54663(0xFFFFFF).method_27694(style -> style.method_10982(Boolean.valueOf(false)))).method_10852((class_2561)class_2561.method_43470((String)"Plot ").method_54663(0x55FFFF).method_27694(style -> style.method_10982(Boolean.valueOf(false)))).method_10852((class_2561)class_2561.method_43470((String)String.valueOf(Flint.getUser().getPlot().getId())).method_54663(0x55FFFF).method_27694(style -> style.method_10982(Boolean.valueOf(false)))).method_10852((class_2561)class_2561.method_43470((String)":").method_54663(0xFFFFFF).method_27694(style -> style.method_10982(Boolean.valueOf(false))));
        List<Waypoint> waypoints = Waypoints.getWaypoints(Flint.getUser().getPlot().getId());
        List<String> names = waypoints.stream().map(Waypoint::getName).sorted().toList();
        Dfwaypoints.MC.field_1724.method_7353((class_2561)waypointListMessage, false);
        for (String name : names) {
            class_5250 listWaypoint = class_2561.method_43470((String)" \u00bb ").method_54663(0xFFFFFF).method_10852((class_2561)class_2561.method_43470((String)name).method_54663(0xFFFFFF)).method_10852((class_2561)class_2561.method_43470((String)" - ").method_54663(0xAAAAAA)).method_10852((class_2561)class_2561.method_43470((String)"[").method_10862(class_2583.field_24360.method_10958(new class_2558(class_2558.class_2559.field_11750, "/wtp " + name))).method_54663(0x55FF55).method_27694(style -> style.method_10949(new class_2568(class_2568.class_5247.field_24342, (Object)teleportHover)))).method_10852((class_2561)class_2561.method_43470((String)"\u2318").method_10862(class_2583.field_24360.method_10958(new class_2558(class_2558.class_2559.field_11750, "/wtp " + name))).method_54663(2359076).method_27694(style -> style.method_10949(new class_2568(class_2568.class_5247.field_24342, (Object)teleportHover)))).method_10852((class_2561)class_2561.method_43470((String)"] ").method_10862(class_2583.field_24360.method_10958(new class_2558(class_2558.class_2559.field_11750, "/wtp " + name))).method_54663(0x55FF55).method_27694(style -> style.method_10949(new class_2568(class_2568.class_5247.field_24342, (Object)teleportHover)))).method_10852((class_2561)class_2561.method_43470((String)"[").method_10862(class_2583.field_24360.method_10958(new class_2558(class_2558.class_2559.field_11750, "/waypoint delete " + name))).method_54663(0xFF5555).method_27694(style -> style.method_10949(new class_2568(class_2568.class_5247.field_24342, (Object)deleteHover)))).method_10852((class_2561)class_2561.method_43470((String)"\u2718").method_10862(class_2583.field_24360.method_10958(new class_2558(class_2558.class_2559.field_11750, "/waypoint delete " + name))).method_54663(0xFF3535).method_27694(style -> style.method_10949(new class_2568(class_2568.class_5247.field_24342, (Object)deleteHover)))).method_10852((class_2561)class_2561.method_43470((String)"]").method_10862(class_2583.field_24360.method_10958(new class_2558(class_2558.class_2559.field_11750, "/waypoint delete " + name))).method_54663(0xFF5555).method_27694(style -> style.method_10949(new class_2568(class_2568.class_5247.field_24342, (Object)deleteHover))));
            Dfwaypoints.MC.field_1724.method_7353((class_2561)listWaypoint, false);
        }
        return 0;
    }

    private int teleportToWaypoint(CommandContext<FabricClientCommandSource> context, String text) throws InterruptedException {
        assert (Flint.getUser().getPlot() != null);
        assert (Flint.getClient().field_1724 != null);
        assert (Dfwaypoints.MC.field_1724 != null);
        class_5250 waypointEnterPlotMessage = class_2561.method_43470((String)"\u00bb ").method_54663(0xFF5555).method_27694(style -> style.method_10982(Boolean.valueOf(true))).method_10852((class_2561)class_2561.method_43470((String)"You must be on a plot to teleport to waypoints!").method_54663(0xFFFFFF).method_27694(style -> style.method_10982(Boolean.valueOf(false))));
        if (Flint.getUser().getPlot() == null) {
            Dfwaypoints.MC.field_1724.method_7353((class_2561)waypointEnterPlotMessage, false);
            return 0;
        }
        class_5250 waypointNoPermissionsMessage = class_2561.method_43470((String)"\u00bb ").method_54663(0xFF5555).method_27694(style -> style.method_10982(Boolean.valueOf(true))).method_10852((class_2561)class_2561.method_43470((String)"You must be in dev/build mode to teleport to waypoints!").method_54663(0xFFFFFF).method_27694(style -> style.method_10982(Boolean.valueOf(false))));
        if (!Flint.getUser().getMode().isEditor()) {
            Dfwaypoints.MC.field_1724.method_7353((class_2561)waypointNoPermissionsMessage, false);
            return 0;
        }
        List<Waypoint> waypoints = Waypoints.getWaypoints(Flint.getUser().getPlot().getId());
        for (Waypoint waypoint : waypoints) {
            if (!Objects.equals(waypoint.getName(), text)) continue;
            class_5250 teleportingToWaypoint = class_2561.method_43470((String)"\u00bb ").method_54663(0x55FFFF).method_27694(style -> style.method_10982(Boolean.valueOf(true))).method_10852((class_2561)class_2561.method_43470((String)"Teleporting to waypoint... ").method_54663(0xFFFFFF).method_27694(style -> style.method_10982(Boolean.valueOf(false))));
            class_243 position = waypoint.getPosition();
            CommandSender.queue("ptp " + position.field_1352 + " " + position.field_1351 + " " + position.field_1350);
            Dfwaypoints.MC.field_1724.method_7353((class_2561)teleportingToWaypoint, false);
            return 0;
        }
        class_5250 waypointNotExistMessage = class_2561.method_43470((String)"\u00bb ").method_54663(0xFF5555).method_27694(style -> style.method_10982(Boolean.valueOf(true))).method_10852((class_2561)class_2561.method_43470((String)"That waypoint does not exist!").method_54663(0xFFFFFF).method_27694(style -> style.method_10982(Boolean.valueOf(false))));
        Dfwaypoints.MC.field_1724.method_7353((class_2561)waypointNotExistMessage, false);
        return 0;
    }

    private int deleteWaypoint(CommandContext<FabricClientCommandSource> context, String text) {
        assert (Dfwaypoints.MC.field_1724 != null);
        class_5250 waypointEnterPlotMessage = class_2561.method_43470((String)"\u00bb ").method_54663(0xFF5555).method_27694(style -> style.method_10982(Boolean.valueOf(true))).method_10852((class_2561)class_2561.method_43470((String)"You must be on a plot to delete waypoints!").method_54663(0xFFFFFF).method_27694(style -> style.method_10982(Boolean.valueOf(false))));
        if (Flint.getUser().getPlot() == null) {
            Dfwaypoints.MC.field_1724.method_7353((class_2561)waypointEnterPlotMessage, false);
            return 0;
        }
        class_5250 waypointDeletedMessage = class_2561.method_43470((String)"\u00bb ").method_54663(0x55FF55).method_27694(style -> style.method_10982(Boolean.valueOf(true))).method_10852((class_2561)class_2561.method_43470((String)"Waypoint Deleted. ").method_54663(0xFFFFFF).method_27694(style -> style.method_10982(Boolean.valueOf(false))));
        class_5250 waypointDeletedNotSavedMessage = class_2561.method_43470((String)"\u00bb ").method_54663(0xFF5555).method_27694(style -> style.method_10982(Boolean.valueOf(true))).method_10852((class_2561)class_2561.method_43470((String)"DFWaypoints ran into an issue saving waypoint data. Your waypoint has been deleted, but may not save upon closing the game. ").method_54663(0xFFFFFF).method_27694(style -> style.method_10982(Boolean.valueOf(false))));
        class_5250 waypointNotExistMessage = class_2561.method_43470((String)"\u00bb ").method_54663(0xFF5555).method_27694(style -> style.method_10982(Boolean.valueOf(true))).method_10852((class_2561)class_2561.method_43470((String)"That waypoint does not exist!").method_54663(0xFFFFFF).method_27694(style -> style.method_10982(Boolean.valueOf(false))));
        List<Waypoint> waypoints = Waypoints.getWaypoints(Flint.getUser().getPlot().getId());
        for (Waypoint waypoint : waypoints) {
            if (!Objects.equals(waypoint.getName(), text)) continue;
            Waypoints.removeWaypoint(Flint.getUser().getPlot().getId(), waypoint);
            try {
                Waypoints.save();
                Dfwaypoints.MC.field_1724.method_7353((class_2561)waypointDeletedMessage, false);
            }
            catch (IOException e) {
                Dfwaypoints.MC.field_1724.method_7353((class_2561)waypointDeletedNotSavedMessage, false);
            }
            return 0;
        }
        Dfwaypoints.MC.field_1724.method_7353((class_2561)waypointNotExistMessage, false);
        return 0;
    }
}

