/*
 * Decompiled with CFR 0.152.
 */
package org.aussiebox.dfwaypoints.features;

import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import dev.dfonline.flint.Flint;
import dev.dfonline.flint.feature.trait.CommandFeature;
import java.util.List;
import java.util.Objects;
import net.fabricmc.fabric.api.client.command.v2.ClientCommandManager;
import net.fabricmc.fabric.api.client.command.v2.FabricClientCommandSource;
import net.minecraft.class_243;
import net.minecraft.class_2561;
import net.minecraft.class_5250;
import net.minecraft.class_7157;
import org.aussiebox.dfwaypoints.Dfwaypoints;
import org.aussiebox.dfwaypoints.util.CommandSender;
import org.aussiebox.dfwaypoints.waypoints.Waypoint;
import org.aussiebox.dfwaypoints.waypoints.Waypoints;

public class WaypointTeleportCommand
implements CommandFeature {
    public String commandName() {
        return "wtp";
    }

    public LiteralArgumentBuilder<FabricClientCommandSource> createCommand(LiteralArgumentBuilder<FabricClientCommandSource> builder, class_7157 commandRegistryAccess) {
        return (LiteralArgumentBuilder)builder.then(ClientCommandManager.argument((String)"text", (ArgumentType)StringArgumentType.greedyString()).suggests((context, suggestionsBuilder) -> {
            if (Flint.getUser().getPlot() == null) {
                return suggestionsBuilder.buildFuture();
            }
            List<Waypoint> waypoints = Waypoints.getWaypoints(Flint.getUser().getPlot().getId());
            List<String> names = waypoints.stream().map(Waypoint::getName).filter(name -> name.startsWith(suggestionsBuilder.getRemaining())).sorted().toList();
            for (String name2 : names) {
                suggestionsBuilder.suggest(name2);
            }
            return suggestionsBuilder.buildFuture();
        }).executes(context -> {
            try {
                return this.teleportToWaypoint((CommandContext<FabricClientCommandSource>)context, StringArgumentType.getString((CommandContext)context, (String)"text"));
            }
            catch (InterruptedException e) {
                throw new RuntimeException(e);
            }
        }));
    }

    private int teleportToWaypoint(CommandContext<FabricClientCommandSource> context, String text) throws InterruptedException {
        assert (Flint.getUser().getPlot() != null);
        assert (Flint.getClient().field_1724 != null);
        assert (Dfwaypoints.MC.field_1724 != null);
        class_5250 waypointEnterPlotMessage = class_2561.method_43470((String)"\u00bb ").method_54663(0xFF5555).method_27694(style -> style.method_10982(Boolean.valueOf(true))).method_10852((class_2561)class_2561.method_43470((String)"You must be on a plot to teleport to waypoints!").method_54663(0xFFFFFF).method_27694(style -> style.method_10982(Boolean.valueOf(false))));
        if (Flint.getUser().getPlot() == null) {
            Dfwaypoints.MC.field_1724.method_7353((class_2561)waypointEnterPlotMessage, false);
            return 0;
        }
        class_5250 waypointNoPermissionsMessage = class_2561.method_43470((String)"\u00bb ").method_54663(0xFF5555).method_27694(style -> style.method_10982(Boolean.valueOf(true))).method_10852((class_2561)class_2561.method_43470((String)"You must be in dev/build mode to teleport to waypoints!").method_54663(0xFFFFFF).method_27694(style -> style.method_10982(Boolean.valueOf(false))));
        if (!Flint.getUser().getMode().isEditor()) {
            Dfwaypoints.MC.field_1724.method_7353((class_2561)waypointNoPermissionsMessage, false);
            return 0;
        }
        List<Waypoint> waypoints = Waypoints.getWaypoints(Flint.getUser().getPlot().getId());
        for (Waypoint waypoint : waypoints) {
            if (!Objects.equals(waypoint.getName(), text)) continue;
            class_5250 teleportingToWaypoint = class_2561.method_43470((String)"\u00bb ").method_54663(0x55FFFF).method_27694(style -> style.method_10982(Boolean.valueOf(true))).method_10852((class_2561)class_2561.method_43470((String)"Teleporting to waypoint... ").method_54663(0xFFFFFF).method_27694(style -> style.method_10982(Boolean.valueOf(false))));
            class_243 position = waypoint.getPosition();
            CommandSender.queue("ptp " + position.field_1352 + " " + position.field_1351 + " " + position.field_1350);
            Dfwaypoints.MC.field_1724.method_7353((class_2561)teleportingToWaypoint, false);
            return 0;
        }
        class_5250 waypointNotExistMessage = class_2561.method_43470((String)"\u00bb ").method_54663(0xFF5555).method_27694(style -> style.method_10982(Boolean.valueOf(true))).method_10852((class_2561)class_2561.method_43470((String)"That waypoint does not exist!").method_54663(0xFFFFFF).method_27694(style -> style.method_10982(Boolean.valueOf(false))));
        Dfwaypoints.MC.field_1724.method_7353((class_2561)waypointNotExistMessage, false);
        return 0;
    }
}

